# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastapi_xml']

package_data = \
{'': ['*']}

install_requires = \
['fastapi>=0.70.0',
 'pydantic>=1.10.2,<1.11',
 'tox>=3.26.0,<4.0.0',
 'xsdata>=22.9']

extras_require = \
{':extra == "docs"': ['Sphinx>=5.2.3,<6.0.0'],
 ':extra == "local"': ['uvicorn>=0.18.2,<0.19.0'],
 ':extra == "testing"': ['pre-commit>=2.20.0,<3.0.0',
                         'tox-poetry>=0.4.1,<0.5.0',
                         'pytest>=7.1.3,<8.0.0',
                         'pytest-cov>=4.0.0,<5.0.0']}

setup_kwargs = {
    'name': 'fastapi-xml',
    'version': '1.0.0b1',
    'description': 'adds xml support to fastapi',
    'long_description': '# FastAPI::XML\n\n![tests](https://github.com/cercide/fastapi-xml/actions/workflows/tests.yml/badge.svg)\n[![codecov](https://codecov.io/gh/cercide/fastapi-xml/branch/master/graph/badge.svg)](https://app.codecov.io/gh/cercide/fastapi-xml)\n![license](https://img.shields.io/github/license/cercide/fastapi-xml)\n![languages](https://img.shields.io/github/languages/top/cercide/fastapi-xml.svg)\n[![CodeFactor](https://www.codefactor.io/repository/github/cercide/fastapi-xml/badge)](https://www.codefactor.io/repository/github/cercide/fastapi-xml)\n![versions](https://img.shields.io/pypi/pyversions/fastapi-xml.svg)\n\n`pip install fastapi-xml`\n\n\nA bridge between [FastAPI](https://github.com/tiangolo/fastapi) and [xsdata](https://github.com/tefra/xsdata). Together,\nfastapi handles xml data structures using dataclasses generated by xsdata. Whilst, fastapi handles the api calls, xsdata\ncovers xml serialisation and deserialization. In addition, openapi support works as well.\n\n![Swagger Example](https://github.com/cercide/fastapi-xml/raw/master/.github/rsc/example.png)\n\n```python\nfrom dataclasses import dataclass, field\nfrom fastapi import FastAPI\nfrom fastapi_xml import add_openapi_extension\nfrom fastapi_xml import NonJsonRoute\nfrom fastapi_xml import XmlAppResponse\nfrom fastapi_xml import XmlBody\n\n@dataclass\nclass HelloWorld:\n    message: str = field(metadata={"example": "Foo","name": "Message", "type": "Element"})\n\napp = FastAPI(title="FastAPI::XML", default_response_class=XmlAppResponse)\napp.router.route_class = NonJsonRoute\nadd_openapi_extension(app)\n\n@app.post("/echo", response_model=HelloWorld, tags=["Example"])\ndef echo(x: HelloWorld = XmlBody()) -> HelloWorld:\n    x.message += " For ever!"\n    return x\n\nif __name__ == "__main__":\n    import uvicorn\n    uvicorn.run(app, host="127.0.0.1", port=8000)\n```\n',
    'author': 'Leon Rendel',
    'author_email': 'cercide@tuta.io',
    'maintainer': 'Leon Rendel',
    'maintainer_email': 'cercide@tuta.io',
    'url': 'https://github.com/cercide/fastapi-xml',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
