"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dms_generated_1 = require("./dms.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return dms_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::DMS::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::DMS::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new dms_generated_1.RosInstance(this, id, {
            instanceSource: props.instanceSource,
            databasePassword: props.databasePassword,
            port: props.port,
            host: props.host,
            exportTimeout: props.exportTimeout,
            safeRule: props.safeRule,
            ddlOnline: props.ddlOnline,
            envType: props.envType,
            tid: props.tid,
            useDsql: props.useDsql,
            sid: props.sid,
            ecsInstanceId: props.ecsInstanceId,
            vpcId: props.vpcId,
            dbaUid: props.dbaUid,
            ecsRegion: props.ecsRegion,
            networkType: props.networkType,
            instanceAlias: props.instanceAlias,
            databaseUser: props.databaseUser,
            instanceType: props.instanceType,
            dataLinkName: props.dataLinkName,
            queryTimeout: props.queryTimeout,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrHost = rosInstance.attrHost;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrPort = rosInstance.attrPort;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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