# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from __future__ import unicode_literals

from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_vpcpeer20220101 import models as vpc_peer_20220101_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(self, config):
        super(Client, self).__init__(config)
        self._endpoint_rule = ''
        self.check_config(config)
        self._endpoint = self.get_endpoint('vpcpeer', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(self, product_id, region_id, endpoint_rule, network, suffix, endpoint_map, endpoint):
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def accept_vpc_peer_connection_with_options(self, request, runtime):
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.caller_bid_login_email):
            body['CallerBidLoginEmail'] = request.caller_bid_login_email
        if not UtilClient.is_unset(request.caller_uid_login_email):
            body['CallerUidLoginEmail'] = request.caller_uid_login_email
        if not UtilClient.is_unset(request.channel):
            body['Channel'] = request.channel
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            body['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_id):
            body['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            body['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id_login_email):
            body['OwnerIdLoginEmail'] = request.owner_id_login_email
        if not UtilClient.is_unset(request.request_content):
            body['RequestContent'] = request.request_content
        if not UtilClient.is_unset(request.resource_owner_account):
            body['ResourceOwnerAccount'] = request.resource_owner_account
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AcceptVpcPeerConnection',
            version='2022-01-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_peer_20220101_models.AcceptVpcPeerConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    def accept_vpc_peer_connection(self, request):
        runtime = util_models.RuntimeOptions()
        return self.accept_vpc_peer_connection_with_options(request, runtime)

    def create_vpc_peer_connection_with_options(self, request, runtime):
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.accepting_ali_uid):
            body['AcceptingAliUid'] = request.accepting_ali_uid
        if not UtilClient.is_unset(request.accepting_region_id):
            body['AcceptingRegionId'] = request.accepting_region_id
        if not UtilClient.is_unset(request.accepting_vpc_id):
            body['AcceptingVpcId'] = request.accepting_vpc_id
        if not UtilClient.is_unset(request.channel):
            body['Channel'] = request.channel
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            body['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            body['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.region_id):
            body['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpc_id):
            body['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateVpcPeerConnection',
            version='2022-01-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_peer_20220101_models.CreateVpcPeerConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    def create_vpc_peer_connection(self, request):
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_peer_connection_with_options(request, runtime)

    def delete_vpc_peer_connection_with_options(self, request, runtime):
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.channel):
            body['Channel'] = request.channel
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            body['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_id):
            body['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteVpcPeerConnection',
            version='2022-01-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_peer_20220101_models.DeleteVpcPeerConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    def delete_vpc_peer_connection(self, request):
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_peer_connection_with_options(request, runtime)

    def get_vpc_peer_connection_attribute_with_options(self, request, runtime):
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.caller_bid_login_email):
            body['CallerBidLoginEmail'] = request.caller_bid_login_email
        if not UtilClient.is_unset(request.caller_uid_login_email):
            body['CallerUidLoginEmail'] = request.caller_uid_login_email
        if not UtilClient.is_unset(request.channel):
            body['Channel'] = request.channel
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            body['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_id):
            body['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            body['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id_login_email):
            body['OwnerIdLoginEmail'] = request.owner_id_login_email
        if not UtilClient.is_unset(request.request_content):
            body['RequestContent'] = request.request_content
        if not UtilClient.is_unset(request.resource_owner_account):
            body['ResourceOwnerAccount'] = request.resource_owner_account
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetVpcPeerConnectionAttribute',
            version='2022-01-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_peer_20220101_models.GetVpcPeerConnectionAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    def get_vpc_peer_connection_attribute(self, request):
        runtime = util_models.RuntimeOptions()
        return self.get_vpc_peer_connection_attribute_with_options(request, runtime)

    def list_vpc_peer_connections_with_options(self, tmp_req, runtime):
        UtilClient.validate_model(tmp_req)
        request = vpc_peer_20220101_models.ListVpcPeerConnectionsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.vpc_id):
            request.vpc_id_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.vpc_id, 'VpcId', 'simple')
        body = {}
        if not UtilClient.is_unset(request.channel):
            body['Channel'] = request.channel
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            body['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_id):
            body['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.max_results):
            body['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.next_token):
            body['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            body['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpc_id_shrink):
            body['VpcId'] = request.vpc_id_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListVpcPeerConnections',
            version='2022-01-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_peer_20220101_models.ListVpcPeerConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    def list_vpc_peer_connections(self, request):
        runtime = util_models.RuntimeOptions()
        return self.list_vpc_peer_connections_with_options(request, runtime)

    def modify_vpc_peer_connection_with_options(self, request, runtime):
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.channel):
            body['Channel'] = request.channel
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            body['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            body['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_id):
            body['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ModifyVpcPeerConnection',
            version='2022-01-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_peer_20220101_models.ModifyVpcPeerConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    def modify_vpc_peer_connection(self, request):
        runtime = util_models.RuntimeOptions()
        return self.modify_vpc_peer_connection_with_options(request, runtime)

    def reject_vpc_peer_connection_with_options(self, request, runtime):
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.caller_bid_login_email):
            body['CallerBidLoginEmail'] = request.caller_bid_login_email
        if not UtilClient.is_unset(request.caller_uid_login_email):
            body['CallerUidLoginEmail'] = request.caller_uid_login_email
        if not UtilClient.is_unset(request.channel):
            body['Channel'] = request.channel
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            body['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_id):
            body['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            body['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id_login_email):
            body['OwnerIdLoginEmail'] = request.owner_id_login_email
        if not UtilClient.is_unset(request.request_content):
            body['RequestContent'] = request.request_content
        if not UtilClient.is_unset(request.resource_owner_account):
            body['ResourceOwnerAccount'] = request.resource_owner_account
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='RejectVpcPeerConnection',
            version='2022-01-01',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_peer_20220101_models.RejectVpcPeerConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    def reject_vpc_peer_connection(self, request):
        runtime = util_models.RuntimeOptions()
        return self.reject_vpc_peer_connection_with_options(request, runtime)
