"use strict";
/**
 * This aimes to verify we can deploy a DynamoDB table with an attribute being
 * a key attribute in one GSI, and a non-key attribute in another.
 *
 * See https://github.com/aws/aws-cdk/issues/4398
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'aws-cdk-dynamodb-gsi');
const table = new lib_1.Table(stack, 'Table', {
    partitionKey: { name: 'pkey', type: lib_1.AttributeType.NUMBER },
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
table.addGlobalSecondaryIndex({
    indexName: 'IndexA',
    partitionKey: { name: 'foo', type: lib_1.AttributeType.STRING },
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: ['bar'],
});
table.addGlobalSecondaryIndex({
    indexName: 'IndexB',
    partitionKey: { name: 'baz', type: lib_1.AttributeType.STRING },
    sortKey: { name: 'bar', type: lib_1.AttributeType.STRING },
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: ['blah'],
});
//# sourceMappingURL=data:application/json;base64,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