"""create_local_train_profile_table

Revision ID: c1ee06d84c12
Revises: c22620b97e39
Create Date: 2021-06-07 17:43:49.859860

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'c1ee06d84c12'
down_revision = 'c22620b97e39'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('local_train_profile',
    sa.Column('id', sa.String(length=32), nullable=False),
    sa.Column('train_task_id', sa.String(length=32), nullable=True),
    sa.Column('algorithm_id', sa.String(length=32), nullable=False),
    sa.Column('algorithm_dir', sa.String(length=4096), nullable=True),
    sa.Column('algorithm_archive', sa.String(length=4096), nullable=True),
    sa.Column('dataset_id', sa.String(length=32), nullable=False),
    sa.Column('dataset_dir', sa.String(length=4096), nullable=True),
    sa.Column('dataset_archive', sa.String(length=4096), nullable=True),
    sa.Column('entrypoint', sa.String(length=4096), nullable=True),
    sa.Column('train_params', sa.String(length=4096), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.ForeignKeyConstraint(['train_task_id'], ['local_train_task.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('local_train_profile')
    # ### end Alembic commands ###
