/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.ansj.app.crf.Model;
import org.ansj.app.crf.SplitWord;
import org.ansj.app.crf.model.CRFModel;
import org.ansj.dic.DicReader;
import org.ansj.domain.AnsjItem;
import org.ansj.library.DATDictionary;
import org.ansj.library.UserDefineLibrary;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.util.FileFinder;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.ObjConver;
import org.nlpcn.commons.lang.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyStaticValue {
    public static final Forest EMPTY_FOREST;
    public static final Logger LIBRARYLOG;
    public static final String DIC_DEFAULT = "dic";
    public static final String CRF_DEFAULT = "crf";
    public static Boolean isNameRecognition;
    public static Boolean isNumRecognition;
    public static Boolean isQuantifierRecognition;
    public static Boolean isRealName;
    public static final Map<String, Object> DIC;
    public static final Map<String, Object> CRF;
    public static String ambiguityLibrary;
    public static boolean isSkipUserDefine;

    public static BufferedReader getPersonReader() {
        return DicReader.getReader("person/person.dic");
    }

    public static BufferedReader getCompanReader() {
        return DicReader.getReader("company/company.data");
    }

    public static BufferedReader getNewWordReader() {
        return DicReader.getReader("newWord/new_word_freq.dic");
    }

    public static BufferedReader getArraysReader() {
        return DicReader.getReader("arrays.dic");
    }

    public static BufferedReader getNumberReader() {
        return DicReader.getReader("numberLibrary.dic");
    }

    public static BufferedReader getEnglishReader() {
        return DicReader.getReader("englishLibrary.dic");
    }

    public static BufferedReader getNatureMapReader() {
        return DicReader.getReader("nature/nature.map");
    }

    public static BufferedReader getNatureTableReader() {
        return DicReader.getReader("nature/nature.table");
    }

    public static BufferedReader getPersonFreqReader() {
        return DicReader.getReader("person/name_freq.dic");
    }

    public static Map<String, int[][]> getPersonFreqMap() {
        Map<String, Object> map = new HashMap<String, int[][]>(0);
        try {
            InputStream inputStream = DicReader.getInputStream("person/asian_name_freq.data");
            Throwable throwable = null;
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                map = (Map)objectInputStream.readObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LIBRARYLOG.warn("IO\u5f02\u5e38", e);
        }
        catch (ClassNotFoundException e) {
            LIBRARYLOG.warn("\u627e\u4e0d\u5230\u7c7b", e);
        }
        return map;
    }

    public static void initBigramTables() {
        try {
            BufferedReader reader = IOUtil.getReader(DicReader.getInputStream("bigramdict.dic"), "UTF-8");
            Throwable throwable = null;
            try {
                String temp = null;
                String[] strs = null;
                int freq = 0;
                while ((temp = reader.readLine()) != null) {
                    if (StringUtil.isBlank(temp)) continue;
                    strs = temp.split("\t");
                    freq = Integer.parseInt(strs[1]);
                    strs = strs[0].split("@");
                    AnsjItem fromItem = DATDictionary.getItem(strs[0]);
                    AnsjItem toItem = DATDictionary.getItem(strs[1]);
                    if (fromItem == AnsjItem.NULL && strs[0].contains("#")) {
                        fromItem = AnsjItem.BEGIN;
                    }
                    if (toItem == AnsjItem.NULL && strs[1].contains("#")) {
                        toItem = AnsjItem.END;
                    }
                    if (fromItem == AnsjItem.NULL || toItem == AnsjItem.NULL) continue;
                    if (fromItem.bigramEntryMap == null) {
                        fromItem.bigramEntryMap = new HashMap<Integer, Integer>();
                    }
                    fromItem.bigramEntryMap.put(toItem.getIndex(), freq);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            LIBRARYLOG.warn("\u6570\u5b57\u683c\u5f0f\u5f02\u5e38", e);
        }
        catch (UnsupportedEncodingException e) {
            LIBRARYLOG.warn("\u4e0d\u652f\u6301\u7684\u7f16\u7801", e);
        }
        catch (IOException e) {
            LIBRARYLOG.warn("IO\u5f02\u5e38", e);
        }
    }

    public static SplitWord getCRFSplitWord() {
        return MyStaticValue.getCRFSplitWord(CRF_DEFAULT);
    }

    public static SplitWord getCRFSplitWord(String key) {
        Object temp = CRF.get(key);
        if (temp == null) {
            if (CRF_DEFAULT.equals(key)) {
                return MyStaticValue.initDefaultModel();
            }
            LIBRARYLOG.warn("crf {} not found in config ", (Object)key);
            return null;
        }
        if (temp instanceof String) {
            return MyStaticValue.initCRFModel(key, (String)temp);
        }
        return (SplitWord)temp;
    }

    private static synchronized SplitWord initDefaultModel() {
        Object obj = CRF.get(CRF_DEFAULT);
        if (obj != null && obj instanceof SplitWord) {
            return (SplitWord)obj;
        }
        try {
            LIBRARYLOG.info("init deafult crf model begin !");
            CRFModel model = new CRFModel(CRF_DEFAULT);
            model.loadModel(DicReader.getInputStream("crf.model"));
            SplitWord splitWord = new SplitWord(model);
            CRF.put(CRF_DEFAULT, splitWord);
            return splitWord;
        }
        catch (Exception e) {
            LIBRARYLOG.error("init err!", e);
            return null;
        }
    }

    private static synchronized SplitWord initCRFModel(String key, String modelPath) {
        try {
            Object obj = CRF.get(key);
            if (obj != null && obj instanceof SplitWord) {
                return (SplitWord)obj;
            }
            if (new File(modelPath).isFile() && new File(modelPath).exists()) {
                long start = System.currentTimeMillis();
                LIBRARYLOG.info("begin init crf model!");
                SplitWord crfSplitWord = new SplitWord(Model.load(key, modelPath));
                CRF.put(key, crfSplitWord);
                LIBRARYLOG.info("load crf use time:{} path is : {}", (Object)(System.currentTimeMillis() - start), (Object)modelPath);
                return crfSplitWord;
            }
            LIBRARYLOG.info("{} file  not found ,please make sure it is exists : {}", (Object)key, (Object)modelPath);
        }
        catch (Exception e) {
            LIBRARYLOG.info("{} file : {} load err {}", key, modelPath, e.getMessage());
        }
        return null;
    }

    public static Forest getDicForest() {
        return MyStaticValue.getDicForest(DIC_DEFAULT);
    }

    public static Forest getDicForest(String key) {
        Object temp = DIC.get(key);
        if (temp == null) {
            LIBRARYLOG.warn("dic {} not found in config ", (Object)key);
            return null;
        }
        if (temp instanceof String) {
            return MyStaticValue.initForest(key, (String)temp);
        }
        return (Forest)temp;
    }

    private static synchronized Forest initForest(String key, String dicPath) {
        Object obj = CRF.get(key);
        if (obj != null && obj instanceof Forest) {
            return (Forest)obj;
        }
        Forest forest = new Forest();
        UserDefineLibrary.loadLibrary(forest, dicPath);
        DIC.put(key, forest);
        return forest;
    }

    static {
        File find;
        EMPTY_FOREST = new Forest();
        LIBRARYLOG = LoggerFactory.getLogger("DICLOG");
        isNameRecognition = true;
        isNumRecognition = true;
        isQuantifierRecognition = true;
        isRealName = false;
        DIC = new HashMap<String, Object>();
        CRF = new HashMap<String, Object>();
        ambiguityLibrary = "library/ambiguity.dic";
        isSkipUserDefine = false;
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("ansj_library");
        }
        catch (Exception e) {
            try {
                find = FileFinder.find("ansj_library.properties", 2);
                if (find != null && find.isFile()) {
                    rb = new PropertyResourceBundle(IOUtil.getReader(find.getAbsolutePath(), System.getProperty("file.encoding")));
                    LIBRARYLOG.info("load ansj_library not find in classPath ! i find it in {} make sure it is your config!", (Object)find.getAbsolutePath());
                }
            }
            catch (Exception e1) {
                LIBRARYLOG.warn("not find ansj_library.properties. and err {} i think it is a bug!", (Object)e1.getMessage());
            }
        }
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle("library");
            }
            catch (Exception e) {
                try {
                    find = FileFinder.find("library.properties", 2);
                    if (find != null && find.isFile()) {
                        rb = new PropertyResourceBundle(IOUtil.getReader(find.getAbsolutePath(), System.getProperty("file.encoding")));
                        LIBRARYLOG.info("load library not find in classPath ! i find it in {} make sure it is your config!", (Object)find.getAbsolutePath());
                    }
                }
                catch (Exception e1) {
                    LIBRARYLOG.warn("not find library.properties. and err {} i think it is a bug!", (Object)e1.getMessage());
                }
            }
        }
        DIC.put(DIC_DEFAULT, "library/default.dic");
        if (rb == null) {
            LIBRARYLOG.warn("not find library.properties in classpath use it by default !");
        } else {
            for (String key : rb.keySet()) {
                if (key.equals(DIC_DEFAULT)) {
                    DIC.put(key, rb.getString(key));
                    continue;
                }
                if (key.equals(CRF_DEFAULT)) {
                    CRF.put(key, rb.getString(key));
                    continue;
                }
                if (key.startsWith("dic_")) {
                    if (DIC.containsKey(key)) {
                        LIBRARYLOG.warn("{} dic config repeat definition now overwrite it !", (Object)key);
                    }
                    DIC.put(key, rb.getString(key));
                    continue;
                }
                if (key.startsWith("crf_")) {
                    if (CRF.containsKey(key)) {
                        LIBRARYLOG.warn("{} crf config repeat definition now overwrite it !", (Object)key);
                    }
                    CRF.put(key, rb.getString(key));
                    continue;
                }
                try {
                    Field field = MyStaticValue.class.getField(key);
                    field.set(null, ObjConver.conversion(rb.getString(key), field.getType()));
                }
                catch (NoSuchFieldException e) {
                    LIBRARYLOG.error("not find field by {}", (Object)key);
                }
                catch (SecurityException e) {
                    LIBRARYLOG.error("\u5b89\u5168\u5f02\u5e38", e);
                }
                catch (IllegalArgumentException e) {
                    LIBRARYLOG.error("\u975e\u6cd5\u53c2\u6570", e);
                }
                catch (IllegalAccessException e) {
                    LIBRARYLOG.error("\u975e\u6cd5\u8bbf\u95ee", e);
                }
            }
        }
    }
}

