/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ansj.app.crf.Config;
import org.ansj.app.crf.Model;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.ObjConver;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.tuples.Pair;

public class CRFppTxtModel
extends Model {
    public CRFppTxtModel(String name) {
        super(name);
    }

    @Override
    public void loadModel(String modelPath) throws Exception {
        long start = System.currentTimeMillis();
        BufferedReader reader = IOUtil.getReader(modelPath, "utf-8");
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        int[] statusCoven = this.loadTagCoven(reader);
        Map<String, Integer> featureIndex = this.loadConfig(reader);
        StringBuilder sb = new StringBuilder();
        for (int[] t1 : this.config.getTemplate()) {
            sb.append(Arrays.toString(t1) + " ");
        }
        this.logger.info("load template ok template : {}", (Object)sb);
        TreeMap<Integer, Pair<String, String>> featureNames = this.loadFeatureName(featureIndex, reader);
        this.logger.info("load feature ok feature size : {}", (Object)featureNames.size());
        this.loadFeatureWeight(reader, statusCoven, featureNames);
        this.logger.info("load crfpp model ok ! use time :{}", (Object)(System.currentTimeMillis() - start));
    }

    private TreeMap<Integer, Pair<String, String>> loadFeatureName(Map<String, Integer> featureIndex, BufferedReader br) throws Exception {
        TreeMap<Integer, Pair<String, String>> featureNames = new TreeMap<Integer, Pair<String, String>>();
        String temp = null;
        while (StringUtil.isNotBlank(temp = br.readLine().trim())) {
            String[] split;
            int indexOf = temp.indexOf(" ");
            int id = ObjConver.getIntValue(temp.substring(0, indexOf));
            if (indexOf > 0) {
                temp = temp.substring(indexOf);
            }
            if ((split = temp.split(":")).length == 1) {
                featureNames.put(id, Pair.with(temp.trim(), ""));
                continue;
            }
            String name = split[1];
            if (split.length > 2) {
                for (int j = 2; j < split.length; ++j) {
                    name = name + ":" + split[j];
                }
            }
            int lastFeatureId = featureIndex.get(split[0].trim());
            if ("/".equals(name)) {
                name = "//";
            }
            if (name.contains("//")) {
                name = name.replaceAll("//", "/XIEGANG/");
            }
            String featureName = this.toFeatureName(name.trim().split("/"), lastFeatureId);
            featureNames.put(id, Pair.with(split[0].trim(), featureName));
        }
        return featureNames;
    }

    private String toFeatureName(String[] split, int lastFeatureId) throws Exception {
        StringBuilder result = new StringBuilder();
        for (String str : split) {
            if ("".equals(str)) continue;
            if (str.length() == 1) {
                result.append(str.charAt(0));
                continue;
            }
            if (str.equals("XIEGANG")) {
                result.append('/');
                continue;
            }
            if (str.startsWith("num")) {
                result.append((char)(130 + ObjConver.getIntValue(str.replace("num", ""))));
                continue;
            }
            if (str.startsWith("en")) {
                result.append((char)(140 + ObjConver.getIntValue(str.replace("en", ""))));
                continue;
            }
            if (str.startsWith("_B-")) {
                result.append('\u0080');
                continue;
            }
            if (str.startsWith("_B+")) {
                result.append('\u0081');
                continue;
            }
            throw new Exception("can find feature named " + str + " in " + Arrays.toString(split));
        }
        result.append((char)(lastFeatureId + 150));
        return result.toString();
    }

    private void loadFeatureWeight(BufferedReader br, int[] statusCoven, TreeMap<Integer, Pair<String, String>> featureNames) throws Exception {
        this.featureTree = new SmartForest();
        int tag = 0;
        int len = 0;
        String name = null;
        float[] tempW = null;
        String temp = null;
        for (Pair<String, String> pair : featureNames.values()) {
            int i;
            char fc = Character.toUpperCase(pair.getValue0().charAt(0));
            int n = fc == 'B' ? 16 : (fc == 'U' ? 4 : (len = fc == '*' ? 20 : 0));
            if (len == 0) {
                throw new Exception("unknow feature type " + pair.getValue0());
            }
            if (fc == 'B') {
                for (i = 0; i < len; ++i) {
                    temp = br.readLine();
                    int from = statusCoven[i / 4];
                    int to = statusCoven[i % 4];
                    this.status[from][to] = ObjConver.getFloatValue(temp).floatValue();
                }
                continue;
            }
            name = pair.getValue1();
            tempW = new float[len];
            for (i = 0; i < len; ++i) {
                temp = br.readLine();
                tag = statusCoven[i];
                tempW[tag] = ObjConver.getFloatValue(temp).floatValue();
            }
            this.featureTree.add(name, tempW);
        }
    }

    private int[] loadTagCoven(BufferedReader br) throws Exception {
        int i;
        int[] conver = new int[20];
        String temp = null;
        block6: for (i = 0; i < 4; ++i) {
            String line = br.readLine();
            if (StringUtil.isBlank(line)) {
                --i;
                continue;
            }
            char c = line.charAt(0);
            switch (c) {
                case 'S': {
                    conver[i] = Config.S;
                    continue block6;
                }
                case 'B': {
                    conver[i] = Config.B;
                    continue block6;
                }
                case 'M': {
                    conver[i] = Config.M;
                    continue block6;
                }
                case 'E': {
                    conver[i] = Config.E;
                    continue block6;
                }
                default: {
                    throw new Exception("err tag named " + c + " in model " + temp);
                }
            }
        }
        for (i = 4; i < conver.length; ++i) {
            conver[i] = conver[(i - 4) / 4] * 4 + conver[i % 4] + 4;
        }
        return conver;
    }

    private Map<String, Integer> loadConfig(BufferedReader br) throws IOException {
        HashMap<String, Integer> featureIndex = new HashMap<String, Integer>();
        String temp = br.readLine();
        ArrayList<int[]> list = new ArrayList<int[]>();
        while (StringUtil.isNotBlank(temp = br.readLine())) {
            List<String> matcherAll = StringUtil.matcherAll("\\[.*?\\]", temp);
            if (matcherAll.size() == 0) continue;
            int[] is = new int[matcherAll.size()];
            for (int j = 0; j < is.length; ++j) {
                is[j] = ObjConver.getIntValue(StringUtil.matcherFirst("[-\\d]+", matcherAll.get(j)));
            }
            featureIndex.put(temp.split(":")[0].trim(), list.size());
            list.add(is);
        }
        int[][] template = new int[list.size()][0];
        for (int i = 0; i < template.length; ++i) {
            template[i] = (int[])list.get(i);
        }
        this.config = new Config(template);
        return featureIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkModel(String modelPath) {
        try {
            InputStream is = IOUtil.getInputStream(modelPath);
            Throwable throwable = null;
            try {
                byte[] bytes = new byte[100];
                is.read(bytes);
                String string = new String(bytes);
                if (!string.startsWith("version")) return false;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("IO\u5f02\u5e38", e);
        }
        return false;
    }
}

