/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ansj.app.crf.Config;
import org.ansj.app.crf.Model;
import org.ansj.app.crf.pojo.Element;
import org.ansj.util.MatrixUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class SplitWord {
    private Model model = null;

    public SplitWord(Model model) {
        this.model = model;
    }

    public List<String> cut(char[] chars) {
        return this.cut(new String(chars));
    }

    public List<String> cut(String line) {
        if (StringUtil.isBlank(line)) {
            return Collections.emptyList();
        }
        List<Element> elements = this.vterbi(line);
        ArrayList<String> result = new ArrayList<String>();
        Element e = null;
        int begin = 0;
        int end = 0;
        int size = elements.size() - 1;
        block4: for (int i = 0; i < elements.size(); ++i) {
            e = elements.get(i);
            switch (e.getTag()) {
                case 0: {
                    result.add(line.substring(begin, end += e.len));
                    begin = end;
                    continue block4;
                }
                case 1: {
                    end += e.len;
                    while (i < size && (e = elements.get(++i)).getTag() != 3) {
                        end += e.len;
                    }
                    result.add(line.substring(begin, end += e.len));
                    begin = end;
                }
            }
        }
        return result;
    }

    private List<Element> vterbi(String line) {
        int i;
        List<Element> elements = Config.wordAlert(line);
        int length = elements.size();
        if (length == 0) {
            return elements;
        }
        if (length == 1) {
            elements.get(0).updateTag(0);
            return elements;
        }
        for (i = 0; i < length; ++i) {
            this.computeTagScore(elements, i);
        }
        elements.get((int)0).tagScore[2] = -1000.0f;
        elements.get((int)0).tagScore[3] = -1000.0f;
        for (i = 1; i < length; ++i) {
            elements.get(i).maxFrom(this.model, elements.get(i - 1));
        }
        Element next = elements.get(elements.size() - 1);
        Element self = null;
        int maxStatus = next.tagScore[0] > next.tagScore[3] ? 0 : 3;
        next.updateTag(maxStatus);
        maxStatus = next.from[maxStatus];
        for (int i2 = elements.size() - 2; i2 > 0; --i2) {
            self = elements.get(i2);
            self.updateTag(maxStatus);
            maxStatus = self.from[self.getTag()];
            next = self;
        }
        elements.get(0).updateTag(maxStatus);
        return elements;
    }

    private void computeTagScore(List<Element> elements, int index) {
        char[][] feautres = this.model.getConfig().makeFeatureArr(elements, index);
        float[] tagScore = new float[20];
        for (int i = 0; i < feautres.length; ++i) {
            MatrixUtil.dot(tagScore, this.model.getFeature(feautres[i]));
        }
        elements.get((int)index).tagScore = tagScore;
    }

    public float cohesion(String word) {
        if (word.length() == 0) {
            return -2.1474836E9f;
        }
        List<Element> elements = Config.wordAlert(word);
        for (int i = 0; i < elements.size(); ++i) {
            this.computeTagScore(elements, i);
        }
        float value = elements.get((int)0).tagScore[1];
        int len = elements.size() - 1;
        for (int i = 1; i < len; ++i) {
            value += elements.get((int)i).tagScore[2];
        }
        if ((value += elements.get((int)len).tagScore[3]) < 0.0f) {
            return 1.0f;
        }
        return value += 1.0f;
    }
}

