# -*- coding: utf-8 -*-

"""
    mundiapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import mundiapi.models.create_cancel_charge_split_rules_request
import mundiapi.models.create_split_request

class CreateCancelChargeRequest(object):

    """Implementation of the 'CreateCancelChargeRequest' model.

    Request for canceling a charge.

    Attributes:
        amount (int): The amount that will be canceled.
        split_rules (list of CreateCancelChargeSplitRulesRequest): The split
            rules request
        split (list of CreateSplitRequest): Splits
        operation_reference (string): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "operation_reference":'operation_reference',
        "amount":'amount',
        "split_rules":'split_rules',
        "split":'split'
    }

    def __init__(self,
                 operation_reference=None,
                 amount=None,
                 split_rules=None,
                 split=None):
        """Constructor for the CreateCancelChargeRequest class"""

        # Initialize members of the class
        self.amount = amount
        self.split_rules = split_rules
        self.split = split
        self.operation_reference = operation_reference


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        operation_reference = dictionary.get('operation_reference')
        amount = dictionary.get('amount')
        split_rules = None
        if dictionary.get('split_rules') != None:
            split_rules = list()
            for structure in dictionary.get('split_rules'):
                split_rules.append(mundiapi.models.create_cancel_charge_split_rules_request.CreateCancelChargeSplitRulesRequest.from_dictionary(structure))
        split = None
        if dictionary.get('split') != None:
            split = list()
            for structure in dictionary.get('split'):
                split.append(mundiapi.models.create_split_request.CreateSplitRequest.from_dictionary(structure))

        # Return an object of this model
        return cls(operation_reference,
                   amount,
                   split_rules,
                   split)


