# drb-topic-sentinel5
The `drb-topic-sentinel5` is a DRB plugin declaring topics about
[Sentinel-5](https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-5)
EO satellite.

## Installation
```bash
pip install drb-topic-sentinel5
```

## Sentinel-5 topics
This section references topics defined in the `drb-topic-sentinel5` DRB plugin.

```mermaid
graph BT
    subgraph "drb-impl-netcdf"
        A([Drb-impl-netcdf<br/>83720abe-2c0e-11ec-8d3d-0242ac130003])
    end

    subgraph "drb-topic-sentinel5"
        B([Sentinel-5P Base Class<br/>74cb1198-c0c1-11ec-9d64-0242ac120002])
        C([Sentinel-5P Product<br/>8351f100-c0c1-11ec-9d64-0242ac120002])
        AUX([Sentinel-5P Auxiliary Product<br/>de97218e-c0c1-11ec-9d64-0242ac120002])
        L1B([Sentinel-5P Level-1B Product<br/>08bbc78d-2ef4-4836-b2ad-ce4a49993791])
        L2([Sentinel-5P Level-2 Product<br/>7b277c33-8627-4d68-8e31-94339a4d37b8])
    end

    B --> A
    C & AUX --> B
    L1B & L2 --> C
```


### Sentinel-5 Level 1B topics
```mermaid
graph RL
    L1B([Sentinel-5P Level-1B Product<br/>08bbc78d-2ef4-4836-b2ad-ce4a49993791])
    L1BI_UVN([Sentinel-5P Level-1B Irradiances UVN Product<br/>b13960e8-e5f7-4200-a8b3-f0b5ed2a9845])
    L1BI_SIR([Sentinel-5P Level-1B Irradiances SIR Product<br/>1b7b5887-a7cf-4d1e-b9e3-0184485c766d])
    L1RA([Sentinel-5P Level-1B Radiances Product<br/>4f8ff745-f921-4a81-a33f-005443505760])
    L1RA_BD1([Sentinel-5P Level-1B Radiances BD1 Product<br/>af123a09-98bc-493f-b16e-eb79ddb13197])
    L1RA_BD2([Sentinel-5P Level-1B Radiances BD2 Product<br/>c67a23a7-b8b3-4d23-a3bf-9cc1e1562bd9])
    L1RA_BD3([Sentinel-5P Level-1B Radiances BD3 Product<br/>a6c1c1e7-c047-4f0c-aeb9-af0b0f72c91c])
    L1RA_BD4([Sentinel-5P Level-1B Radiances BD4 Product<br/>fc797255-7060-40bd-a28e-4052d1b5d907])
    L1RA_BD5([Sentinel-5P Level-1B Radiances BD5 Product<br/>31890d7d-22d0-498c-99a4-ec5f3bf2a461])
    L1RA_BD6([Sentinel-5P Level-1B Radiances BD6 Product<br/>9f6a0d17-3dda-48fa-8def-fee69f8dadd7])
    L1RA_BD7([Sentinel-5P Level-1B Radiances BD7 Product<br/>b04a7dc7-3a06-4f96-86c2-bc675863a8f3])
    L1RA_BD8([Sentinel-5P Level-1B Radiances BD8 Product<br/>444fea5a-8911-40e2-886e-76fc64467d60])

    L1BI_UVN & L1BI_SIR & L1RA & L1RA_BD1 & L1RA_BD2 & L1RA_BD3 & L1RA_BD4 & L1RA_BD5 & L1RA_BD6 & L1RA_BD7 & L1RA_BD8 --> L1B

```

### Sentinel-5 Level 1B topics
```mermaid
graph RL
    L2([Sentinel-5P Level-2 Product<br/>7b277c33-8627-4d68-8e31-94339a4d37b8])
    L2_O3__PR([Sentinel-5P Level-2 O3 Full Profile Product<br/>5af39ab5-5c4f-47ba-a614-46165ed9cfd8])
    L2_O3_TPR([Sentinel-5P Level-2 O3 Tropospheric Profile Product<br/>a12a66b3-1d5f-4d58-ba1d-713881d65c2c])    
    L2__NO2([Sentinel-5P Level-2 NO2 Tropospheric Column Product<br/>e9e8b2b2-dbb3-4d7d-a51f-15a49684b22c])    
    L2__CH4([Sentinel-5P Level-2 CH4 Product<br/>556981ff-34bf-472a-aa97-54b0ae98d745])
    L2__CO([Sentinel-5P Level-2 CO Total Column Product<br/>c2310871-22b6-48d1-9a25-7f8202b3e5f7])
    L2__AER_LH([Sentinel-5P Level-2 Aerosol Layer Height Product<br/>7d7ef9cf-2d26-4b61-b2f9-6c3653c33d85])
    L2__AER_AI([Sentinel-5P Level-2 Aerosol Index Product<br/>85c00dec-6950-4fd0-ac4b-21ef3f291bc8])
    L2__FRESCO([Sentinel-5P Level-2 KNMI Cloud Support Product<br/>8faf129d-fdde-4784-87c7-275f2615791c])
    L2__CLOUD([Sentinel-5P Level-2 Cloud Product<br/>3d2d7821-68d4-4232-804d-9d4b5fdeeab4])
    L2__HCHO([Sentinel-5P Level-2 Formaldehyde Product<br/>44368488-356d-424e-a7c1-286c3bfa3f0e])
    L2__SO2([Sentinel-5P Level-2 Sulphur Dioxide Product<br/>49084f7f-a690-4936-96df-9688228518d4])
    L2__O3([Sentinel-5P Level-2 Ozone Total Column Product<br/>178f2f18-44e5-4e9e-a833-535716e4a5ce])
    L2__O3_TCL([Sentinel-5P Level-2 Ozone Tropospheric Column Product<br/>178f2f18-44e5-4e9e-a833-535716e4a5ce])


    L2_O3__PR & L2_O3_TPR & L2__NO2 & L2__CH4 & L2__CO & L2__AER_LH & L2__AER_AI & L2__FRESCO & L2__CLOUD & L2__HCHO & L2__SO2 & L2__O3 & L2__O3_TCL --> L2
```


### Sentinel-5P Auxiliary Product topics
```mermaid
graph BT
    HDFEOS([HDFEOS<br/>b47a2cba-26e9-4e7e-8205-8f34299bdc0d])

    AUX_NISE([Sentinel-5P Auxiliary Product NISE snow and ice<br/>99ed650b-b9af-452e-a50d-bd8e738d58f0])
    AUX_NISE --> HDFEOS
```    
```mermaid
graph RL

    AUX([Sentinel-5P Auxiliary Product<br/>de97218e-c0c1-11ec-9d64-0242ac120002])
    AUX_MET([Sentinel-5P Auxiliary Product Meteo<br/>47790711-2c9a-4d90-9f6a-f583d36e3948])
    AUX_MET_TP([SSentinel-5P Auxiliary Product ECMWF temperature profiles<br/>44da1d728-983d-48c9-952d-888636348601])
    AUX_MET_QP([SSentinel-5P Auxiliary Product ECMWF specific humidity profiles<br/>4f8dfdaf-461a-437b-aadf-350e48e3c023])
    AUX_MET_2D([Sentinel-5P Auxiliary Product ECMWF 2D surface fields<br/>cce861dc-1643-4d42-9323-2c87a761ed82])

    AUX_CTMFCT([Sentinel-5P Auxiliary Product: NO2 profile data forecast mode<br/>ec73946b-349b-4566-8d73-6aac680e88a2])
    AUX_CTMANA([Sentinel-5P Auxiliary Product: NO2 profile data assimilation mode<br/>94d74b06-1e0d-4c84-857d-1b52832f1c92])
    AUX_CTM_CO([Sentinel-5P Auxiliary Product: CO a priori profiles<br/>e1b03f83-68a8-4539-8890-7a0187a1606a])
    AUX_BGSO2([Sentinel-5P Auxiliary Product: BGSO2 Background Correction<br/>58305c95-9448-4eb7-bfc9-138e988c43d1])
    AUX_BGHCHO([Sentinel-5P Auxiliary Product: BGHCHO Background Correction<br/>fdcd6866-a28c-48a7-8cc6-45adde846290])



    AUX_MET  & AUX_CTMFCT & AUX_CTMANA & AUX_CTM_CO & AUX_BGSO2 & AUX_BGHCHO --> AUX
    AUX_MET_TP & AUX_MET_QP & AUX_MET_2D --> AUX_MET
```