import codecs

from hashlib import sha256 as hasher
from tvm_valuetypes.cell import deserialize_boc

def empty_extractor(result, data):
    pass

def seqno_extractor(result, data):
    data_cell = deserialize_boc(codecs.decode(codecs.encode(data["data"], 'utf-8'), 'base64'))
    seqno = int.from_bytes(data_cell.data.data[0:32].tobytes(), 'big')
    result['seqno'] = seqno


def v3_extractor(result, data):
    seqno_extractor(result, data)
    data_cell = deserialize_boc(codecs.decode(codecs.encode(data["data"], 'utf-8'), 'base64'))
    wallet_id = int.from_bytes(data_cell.data.data[32:64].tobytes(), 'big')
    result['wallet_id'] = wallet_id


def sha256(x):
    if not isinstance(x, bytes):
        x = codecs.encode(x, 'utf-8')
    h = hasher()
    h.update(x)
    return h.digest()


wallet_v1_r1 = "te6cckEBAQEARAAAhP8AIN2k8mCBAgDXGCDXCx/tRNDTH9P/0VESuvKhIvkBVBBE+RDyovgAAdMfMSDXSpbTB9QC+wDe0aTIyx/L/8ntVEH98Ik="
wallet_v1_r2 = "te6cckEBAQEAUwAAov8AIN0gggFMl7qXMO1E0NcLH+Ck8mCBAgDXGCDXCx/tRNDTH9P/0VESuvKhIvkBVBBE+RDyovgAAdMfMSDXSpbTB9QC+wDe0aTIyx/L/8ntVNDieG8="
wallet_v1_r3 = "te6cckEBAQEAXwAAuv8AIN0gggFMl7ohggEznLqxnHGw7UTQ0x/XC//jBOCk8mCBAgDXGCDXCx/tRNDTH9P/0VESuvKhIvkBVBBE+RDyovgAAdMfMSDXSpbTB9QC+wDe0aTIyx/L/8ntVLW4bkI="
wallet_v2_r1 = "te6cckEBAQEAVwAAqv8AIN0gggFMl7qXMO1E0NcLH+Ck8mCDCNcYINMf0x8B+CO78mPtRNDTH9P/0VExuvKhA/kBVBBC+RDyovgAApMg10qW0wfUAvsA6NGkyMsfy//J7VShNwu2"
wallet_v2_r2 = "te6cckEBAQEAYwAAwv8AIN0gggFMl7ohggEznLqxnHGw7UTQ0x/XC//jBOCk8mCDCNcYINMf0x8B+CO78mPtRNDTH9P/0VExuvKhA/kBVBBC+RDyovgAApMg10qW0wfUAvsA6NGkyMsfy//J7VQETNeh"
wallet_v3_r1 = "te6cckEBAQEAYgAAwP8AIN0gggFMl7qXMO1E0NcLH+Ck8mCDCNcYINMf0x/TH/gjE7vyY+1E0NMf0x/T/9FRMrryoVFEuvKiBPkBVBBV+RDyo/gAkyDXSpbTB9QC+wDo0QGkyMsfyx/L/8ntVD++buA="
wallet_v3_r2 = "te6cckEBAQEAcQAA3v8AIN0gggFMl7ohggEznLqxn3Gw7UTQ0x/THzHXC//jBOCk8mCDCNcYINMf0x/TH/gjE7vyY+1E0NMf0x/T/9FRMrryoVFEuvKiBPkBVBBV+RDyo/gAkyDXSpbTB9QC+wDo0QGkyMsfyx/L/8ntVBC9ba0="
wallet_v4_r1 ="te6cckECFQEAAvUAART/APSkE/S88sgLAQIBIAIDAgFIBAUE+PKDCNcYINMf0x/THwL4I7vyY+1E0NMf0x/T//QE0VFDuvKhUVG68qIF+QFUEGT5EPKj+AAkpMjLH1JAyx9SMMv/UhD0AMntVPgPAdMHIcAAn2xRkyDXSpbTB9QC+wDoMOAhwAHjACHAAuMAAcADkTDjDQOkyMsfEssfy/8REhMUA+7QAdDTAwFxsJFb4CHXScEgkVvgAdMfIYIQcGx1Z70ighBibG5jvbAighBkc3RyvbCSXwPgAvpAMCD6RAHIygfL/8nQ7UTQgQFA1yH0BDBcgQEI9ApvoTGzkl8F4ATTP8glghBwbHVnupEx4w0kghBibG5juuMABAYHCAIBIAkKAFAB+gD0BDCCEHBsdWeDHrFwgBhQBcsFJ88WUAP6AvQAEstpyx9SEMs/AFL4J28ighBibG5jgx6xcIAYUAXLBSfPFiT6AhTLahPLH1Iwyz8B+gL0AACSghBkc3Ryuo41BIEBCPRZMO1E0IEBQNcgyAHPFvQAye1UghBkc3Rygx6xcIAYUATLBVjPFiL6AhLLassfyz+UEDRfBOLJgED7AAIBIAsMAFm9JCtvaiaECAoGuQ+gIYRw1AgIR6STfSmRDOaQPp/5g3gSgBt4EBSJhxWfMYQCAVgNDgARuMl+1E0NcLH4AD2ynftRNCBAUDXIfQEMALIygfL/8nQAYEBCPQKb6ExgAgEgDxAAGa3OdqJoQCBrkOuF/8AAGa8d9qJoQBBrkOuFj8AAbtIH+gDU1CL5AAXIygcVy//J0Hd0gBjIywXLAiLPFlAF+gIUy2sSzMzJcfsAyEAUgQEI9FHypwIAbIEBCNcYyFQgJYEBCPRR8qeCEG5vdGVwdIAYyMsFywJQBM8WghAF9eEA+gITy2oSyx/JcfsAAgBygQEI1xgwUgKBAQj0WfKn+CWCEGRzdHJwdIAYyMsFywJQBc8WghAF9eEA+gIUy2oTyx8Syz/Jc/sAAAr0AMntVEap808="
wallet_v4_r2 = "te6cckECFAEAAtQAART/APSkE/S88sgLAQIBIAIDAgFIBAUE+PKDCNcYINMf0x/THwL4I7vyZO1E0NMf0x/T//QE0VFDuvKhUVG68qIF+QFUEGT5EPKj+AAkpMjLH1JAyx9SMMv/UhD0AMntVPgPAdMHIcAAn2xRkyDXSpbTB9QC+wDoMOAhwAHjACHAAuMAAcADkTDjDQOkyMsfEssfy/8QERITAubQAdDTAyFxsJJfBOAi10nBIJJfBOAC0x8hghBwbHVnvSKCEGRzdHK9sJJfBeAD+kAwIPpEAcjKB8v/ydDtRNCBAUDXIfQEMFyBAQj0Cm+hMbOSXwfgBdM/yCWCEHBsdWe6kjgw4w0DghBkc3RyupJfBuMNBgcCASAICQB4AfoA9AQw+CdvIjBQCqEhvvLgUIIQcGx1Z4MesXCAGFAEywUmzxZY+gIZ9ADLaRfLH1Jgyz8gyYBA+wAGAIpQBIEBCPRZMO1E0IEBQNcgyAHPFvQAye1UAXKwjiOCEGRzdHKDHrFwgBhQBcsFUAPPFiP6AhPLassfyz/JgED7AJJfA+ICASAKCwBZvSQrb2omhAgKBrkPoCGEcNQICEekk30pkQzmkD6f+YN4EoAbeBAUiYcVnzGEAgFYDA0AEbjJftRNDXCx+AA9sp37UTQgQFA1yH0BDACyMoHy//J0AGBAQj0Cm+hMYAIBIA4PABmtznaiaEAga5Drhf/AABmvHfaiaEAQa5DrhY/AAG7SB/oA1NQi+QAFyMoHFcv/ydB3dIAYyMsFywIizxZQBfoCFMtrEszMyXP7AMhAFIEBCPRR8qcCAHCBAQjXGPoA0z/IVCBHgQEI9FHyp4IQbm90ZXB0gBjIywXLAlAGzxZQBPoCFMtqEssfyz/Jc/sAAgBsgQEI1xj6ANM/MFIkgQEI9Fnyp4IQZHN0cnB0gBjIywXLAlAFzxZQA/oCE8tqyx8Syz/Jc/sAAAr0AMntVGliJeU="
nominator_pool_v1 = "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"

wallets = {sha256(wallet_v1_r1): {'type': 'wallet v1 r1', 'data_extractor': seqno_extractor},
           sha256(wallet_v1_r2): {'type': 'wallet v1 r2', 'data_extractor': seqno_extractor},
           sha256(wallet_v1_r3): {'type': 'wallet v1 r3', 'data_extractor': seqno_extractor},
           sha256(wallet_v2_r1): {'type': 'wallet v2 r1', 'data_extractor': seqno_extractor},
           sha256(wallet_v2_r2): {'type': 'wallet v2 r2', 'data_extractor': seqno_extractor},
           sha256(wallet_v3_r1): {'type': 'wallet v3 r1', 'data_extractor': v3_extractor},
           sha256(wallet_v3_r2): {'type': 'wallet v3 r2', 'data_extractor': v3_extractor},
           sha256(wallet_v4_r1): {'type': 'wallet v4 r1', 'data_extractor': v3_extractor},
           sha256(wallet_v4_r2): {'type': 'wallet v4 r2', 'data_extractor': v3_extractor},
           sha256(nominator_pool_v1): {'type': 'nominator pool v1', 'data_extractor': empty_extractor}
           }
