# coding: utf-8

"""
    Kimai 2 - API Docs

    JSON API for the Kimai 2 time-tracking software. Read more about its usage in the [API documentation](https://www.kimai.org/documentation/rest-api.html) and then download a [Swagger file](doc.json) for import e.g. in Postman. Be aware: it is not yet considered stable and BC breaks might happen, but we try to avoid them.   # noqa: E501

    OpenAPI spec version: 0.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from kimai_python.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_activities_get(self, **kwargs):  # noqa: E501
        """Returns a collection of activities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Project ID to filter activities. If none is provided, all activities will be returned.
        :param str visible: Visibility status to filter activities. Allowed values: 1=visible, 2=hidden, 3=all (default: 1)
        :param str globals: Use if you want to fetch only global activities. Allowed values: true (default: false)
        :param str globals_first: Deprecated parameter, value is not used any more
        :param str order_by: The field by which results will be ordered. Allowed values: id, name, project (default: name)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str term: Free search term
        :return: list[ActivityCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_activities_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_activities_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_activities_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a collection of activities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Project ID to filter activities. If none is provided, all activities will be returned.
        :param str visible: Visibility status to filter activities. Allowed values: 1=visible, 2=hidden, 3=all (default: 1)
        :param str globals: Use if you want to fetch only global activities. Allowed values: true (default: false)
        :param str globals_first: Deprecated parameter, value is not used any more
        :param str order_by: The field by which results will be ordered. Allowed values: id, name, project (default: name)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str term: Free search term
        :return: list[ActivityCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'visible', 'globals', 'globals_first', 'order_by', 'order', 'term']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_activities_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'project' in params and not re.search(r'\\d+', params['project']):  # noqa: E501
            raise ValueError("Invalid value for parameter `project` when calling `api_activities_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'visible' in params and not re.search(r'1|2|3', params['visible']):  # noqa: E501
            raise ValueError("Invalid value for parameter `visible` when calling `api_activities_get`, must conform to the pattern `/1|2|3/`")  # noqa: E501
        if 'globals' in params and not re.search(r'true', params['globals']):  # noqa: E501
            raise ValueError("Invalid value for parameter `globals` when calling `api_activities_get`, must conform to the pattern `/true/`")  # noqa: E501
        if 'globals_first' in params and not re.search(r'true|false', params['globals_first']):  # noqa: E501
            raise ValueError("Invalid value for parameter `globals_first` when calling `api_activities_get`, must conform to the pattern `/true|false/`")  # noqa: E501
        if 'order_by' in params and not re.search(r'id|name|project', params['order_by']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order_by` when calling `api_activities_get`, must conform to the pattern `/id|name|project/`")  # noqa: E501
        if 'order' in params and not re.search(r'ASC|DESC', params['order']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order` when calling `api_activities_get`, must conform to the pattern `/ASC|DESC/`")  # noqa: E501
        if 'term' in params and not re.search(r'[a-zA-Z0-9 \\-,:]+', params['term']):  # noqa: E501
            raise ValueError("Invalid value for parameter `term` when calling `api_activities_get`, must conform to the pattern `/[a-zA-Z0-9 \\-,:]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501
        if 'visible' in params:
            query_params.append(('visible', params['visible']))  # noqa: E501
        if 'globals' in params:
            query_params.append(('globals', params['globals']))  # noqa: E501
        if 'globals_first' in params:
            query_params.append(('globalsFirst', params['globals_first']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/activities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ActivityCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_activities_id_get(self, id, **kwargs):  # noqa: E501
        """Returns one activity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Activity ID to fetch (required)
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_activities_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_activities_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_activities_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns one activity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Activity ID to fetch (required)
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_activities_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_activities_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/activities/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_activities_id_meta_patch(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_id_meta_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Activity record ID to set the meta-field value for (required)
        :param Body body:
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_activities_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_activities_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_activities_id_meta_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing activity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_id_meta_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Activity record ID to set the meta-field value for (required)
        :param Body body:
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_activities_id_meta_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_activities_id_meta_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/activities/{id}/meta', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_activities_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update an existing activity  # noqa: E501

        Update an existing activity, you can pass all or just a subset of all attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEditForm body: (required)
        :param int id: Activity ID to update (required)
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_activities_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_activities_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def api_activities_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an existing activity  # noqa: E501

        Update an existing activity, you can pass all or just a subset of all attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEditForm body: (required)
        :param int id: Activity ID to update (required)
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_activities_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_activities_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_activities_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/activities/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_activities_post(self, body, **kwargs):  # noqa: E501
        """Creates a new activity  # noqa: E501

        Creates a new activity and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEditForm body: (required)
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_activities_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_activities_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_activities_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new activity  # noqa: E501

        Creates a new activity and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_activities_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEditForm body: (required)
        :return: ActivityEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_activities_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_activities_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/activities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_config_i18n_get(self, **kwargs):  # noqa: E501
        """Returns the user specific locale configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_config_i18n_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: I18nConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_config_i18n_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_config_i18n_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_config_i18n_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the user specific locale configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_config_i18n_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: I18nConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_config_i18n_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/config/i18n', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='I18nConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_config_timesheet_get(self, **kwargs):  # noqa: E501
        """Returns the instance specific timesheet configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_config_timesheet_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TimesheetConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_config_timesheet_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_config_timesheet_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_config_timesheet_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the instance specific timesheet configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_config_timesheet_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TimesheetConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_config_timesheet_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/config/timesheet', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_customers_get(self, **kwargs):  # noqa: E501
        """Returns a collection of customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str visible: Visibility status to filter activities (1=visible, 2=hidden, 3=both)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str order_by: The field by which results will be ordered. Allowed values: id, name (default: name)
        :param str term: Free search term
        :return: list[CustomerCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_customers_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_customers_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_customers_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a collection of customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str visible: Visibility status to filter activities (1=visible, 2=hidden, 3=both)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str order_by: The field by which results will be ordered. Allowed values: id, name (default: name)
        :param str term: Free search term
        :return: list[CustomerCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['visible', 'order', 'order_by', 'term']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_customers_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'visible' in params and not re.search(r'\\d+', params['visible']):  # noqa: E501
            raise ValueError("Invalid value for parameter `visible` when calling `api_customers_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'order' in params and not re.search(r'ASC|DESC', params['order']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order` when calling `api_customers_get`, must conform to the pattern `/ASC|DESC/`")  # noqa: E501
        if 'order_by' in params and not re.search(r'id|name', params['order_by']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order_by` when calling `api_customers_get`, must conform to the pattern `/id|name/`")  # noqa: E501
        if 'term' in params and not re.search(r'[a-zA-Z0-9 \\-,:]+', params['term']):  # noqa: E501
            raise ValueError("Invalid value for parameter `term` when calling `api_customers_get`, must conform to the pattern `/[a-zA-Z0-9 \\-,:]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'visible' in params:
            query_params.append(('visible', params['visible']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomerCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_customers_id_get(self, id, **kwargs):  # noqa: E501
        """Returns one customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_customers_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_customers_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_customers_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns one customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_customers_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_customers_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/customers/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_customers_id_meta_patch(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_id_meta_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Customer record ID to set the meta-field value for (required)
        :param Body1 body:
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_customers_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_customers_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_customers_id_meta_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing customer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_id_meta_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Customer record ID to set the meta-field value for (required)
        :param Body1 body:
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_customers_id_meta_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_customers_id_meta_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/customers/{id}/meta', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_customers_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update an existing customer  # noqa: E501

        Update an existing customer, you can pass all or just a subset of all attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerEditForm body: (required)
        :param int id: Customer ID to update (required)
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_customers_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_customers_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def api_customers_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an existing customer  # noqa: E501

        Update an existing customer, you can pass all or just a subset of all attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerEditForm body: (required)
        :param int id: Customer ID to update (required)
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_customers_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_customers_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_customers_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/customers/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_customers_post(self, body, **kwargs):  # noqa: E501
        """Creates a new customer  # noqa: E501

        Creates a new customer and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerEditForm body: (required)
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_customers_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_customers_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_customers_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new customer  # noqa: E501

        Creates a new customer and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_customers_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerEditForm body: (required)
        :return: CustomerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_customers_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_customers_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/customers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_ping_get(self, **kwargs):  # noqa: E501
        """A testing route for the API  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_ping_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_ping_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_ping_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_ping_get_with_http_info(self, **kwargs):  # noqa: E501
        """A testing route for the API  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_ping_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_ping_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/ping', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_projects_get(self, **kwargs):  # noqa: E501
        """Returns a collection of projects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer: Customer ID to filter projects
        :param str visible: Visibility status to filter projects. Allowed values: 1=visible, 2=hidden, 3=both (default; 1)
        :param str start: Only projects that started before this date will be included. Allowed format: HTML5 (default: now, if end is also empty)
        :param str end: Only projects that ended after this date will be included. Allowed format: HTML5 (default: now, if start is also empty)
        :param str ignore_dates: If set, start and end are completely ignored. Allowed values: 1 (default: off)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str order_by: The field by which results will be ordered. Allowed values: id, name, customer (default: name)
        :param str term: Free search term
        :return: list[ProjectCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_projects_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_projects_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_projects_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a collection of projects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer: Customer ID to filter projects
        :param str visible: Visibility status to filter projects. Allowed values: 1=visible, 2=hidden, 3=both (default; 1)
        :param str start: Only projects that started before this date will be included. Allowed format: HTML5 (default: now, if end is also empty)
        :param str end: Only projects that ended after this date will be included. Allowed format: HTML5 (default: now, if start is also empty)
        :param str ignore_dates: If set, start and end are completely ignored. Allowed values: 1 (default: off)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str order_by: The field by which results will be ordered. Allowed values: id, name, customer (default: name)
        :param str term: Free search term
        :return: list[ProjectCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer', 'visible', 'start', 'end', 'ignore_dates', 'order', 'order_by', 'term']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_projects_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'customer' in params and not re.search(r'\\d+', params['customer']):  # noqa: E501
            raise ValueError("Invalid value for parameter `customer` when calling `api_projects_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'visible' in params and not re.search(r'\\d+', params['visible']):  # noqa: E501
            raise ValueError("Invalid value for parameter `visible` when calling `api_projects_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'ignore_dates' in params and not re.search(r'1', params['ignore_dates']):  # noqa: E501
            raise ValueError("Invalid value for parameter `ignore_dates` when calling `api_projects_get`, must conform to the pattern `/1/`")  # noqa: E501
        if 'order' in params and not re.search(r'ASC|DESC', params['order']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order` when calling `api_projects_get`, must conform to the pattern `/ASC|DESC/`")  # noqa: E501
        if 'order_by' in params and not re.search(r'id|name|customer', params['order_by']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order_by` when calling `api_projects_get`, must conform to the pattern `/id|name|customer/`")  # noqa: E501
        if 'term' in params and not re.search(r'[a-zA-Z0-9 \\-,:]+', params['term']):  # noqa: E501
            raise ValueError("Invalid value for parameter `term` when calling `api_projects_get`, must conform to the pattern `/[a-zA-Z0-9 \\-,:]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'customer' in params:
            query_params.append(('customer', params['customer']))  # noqa: E501
        if 'visible' in params:
            query_params.append(('visible', params['visible']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'ignore_dates' in params:
            query_params.append(('ignoreDates', params['ignore_dates']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProjectCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_projects_id_get(self, id, **kwargs):  # noqa: E501
        """Returns one project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_projects_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_projects_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_projects_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns one project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_projects_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_projects_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/projects/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_projects_id_meta_patch(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_id_meta_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Project record ID to set the meta-field value for (required)
        :param Body2 body:
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_projects_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_projects_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_projects_id_meta_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_id_meta_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Project record ID to set the meta-field value for (required)
        :param Body2 body:
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_projects_id_meta_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_projects_id_meta_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/projects/{id}/meta', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_projects_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update an existing project  # noqa: E501

        Update an existing project, you can pass all or just a subset of all attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectEditForm body: (required)
        :param int id: Project ID to update (required)
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_projects_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_projects_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def api_projects_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an existing project  # noqa: E501

        Update an existing project, you can pass all or just a subset of all attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectEditForm body: (required)
        :param int id: Project ID to update (required)
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_projects_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_projects_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_projects_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/projects/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_projects_post(self, body, **kwargs):  # noqa: E501
        """Creates a new project  # noqa: E501

        Creates a new project and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectEditForm body: (required)
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_projects_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_projects_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_projects_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new project  # noqa: E501

        Creates a new project and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_projects_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectEditForm body: (required)
        :return: ProjectEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_projects_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_projects_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_tags_get(self, **kwargs):  # noqa: E501
        """Fetch all existing tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_tags_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Search term to filter tag list
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_tags_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_tags_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_tags_get_with_http_info(self, **kwargs):  # noqa: E501
        """Fetch all existing tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_tags_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Search term to filter tag list
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_tags_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_tags_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete a tag  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_tags_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Tag ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_tags_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_tags_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_tags_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a tag  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_tags_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Tag ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_tags_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_tags_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/tags/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_tags_post(self, body, **kwargs):  # noqa: E501
        """Creates a new tag  # noqa: E501

        Creates a new tag and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_tags_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagEditForm body: (required)
        :return: TagEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_tags_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_tags_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_tags_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new tag  # noqa: E501

        Creates a new tag and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_tags_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagEditForm body: (required)
        :return: TagEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_tags_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_tags_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TagEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_get(self, **kwargs):  # noqa: E501
        """Fetch all existing teams  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TeamCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_teams_get_with_http_info(self, **kwargs):  # noqa: E501
        """Fetch all existing teams  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TeamCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TeamCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_customers_customer_id_delete(self, id, customer_id, **kwargs):  # noqa: E501
        """Revokes access for a customer from a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_customers_customer_id_delete(id, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team whose permission will be revoked (required)
        :param int customer_id: The customer to remove (Customer ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_customers_customer_id_delete_with_http_info(id, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_customers_customer_id_delete_with_http_info(id, customer_id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_customers_customer_id_delete_with_http_info(self, id, customer_id, **kwargs):  # noqa: E501
        """Revokes access for a customer from a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_customers_customer_id_delete_with_http_info(id, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team whose permission will be revoked (required)
        :param int customer_id: The customer to remove (Customer ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_customers_customer_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_customers_customer_id_delete`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `api_teams_id_customers_customer_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}/customers/{customerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_customers_customer_id_post(self, id, customer_id, **kwargs):  # noqa: E501
        """Grant the team access to a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_customers_customer_id_post(id, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team that is granted access (required)
        :param int customer_id: The customer to grant acecess to (Customer ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_customers_customer_id_post_with_http_info(id, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_customers_customer_id_post_with_http_info(id, customer_id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_customers_customer_id_post_with_http_info(self, id, customer_id, **kwargs):  # noqa: E501
        """Grant the team access to a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_customers_customer_id_post_with_http_info(id, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team that is granted access (required)
        :param int customer_id: The customer to grant acecess to (Customer ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_customers_customer_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_customers_customer_id_post`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `api_teams_id_customers_customer_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}/customers/{customerId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Team ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Team ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_get(self, id, **kwargs):  # noqa: E501
        """Returns one team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns one team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_members_user_id_delete(self, id, user_id, **kwargs):  # noqa: E501
        """Removes a member from the team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_members_user_id_delete(id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team from which the member will be removed (required)
        :param int user_id: The team member to remove (User ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_members_user_id_delete_with_http_info(id, user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_members_user_id_delete_with_http_info(id, user_id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_members_user_id_delete_with_http_info(self, id, user_id, **kwargs):  # noqa: E501
        """Removes a member from the team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_members_user_id_delete_with_http_info(id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team from which the member will be removed (required)
        :param int user_id: The team member to remove (User ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_members_user_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_members_user_id_delete`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `api_teams_id_members_user_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}/members/{userId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_members_user_id_post(self, id, user_id, **kwargs):  # noqa: E501
        """Add a new member to a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_members_user_id_post(id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team which will receive the new member (required)
        :param int user_id: The team member to add (User ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_members_user_id_post_with_http_info(id, user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_members_user_id_post_with_http_info(id, user_id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_members_user_id_post_with_http_info(self, id, user_id, **kwargs):  # noqa: E501
        """Add a new member to a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_members_user_id_post_with_http_info(id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team which will receive the new member (required)
        :param int user_id: The team member to add (User ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_members_user_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_members_user_id_post`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `api_teams_id_members_user_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}/members/{userId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update an existing team  # noqa: E501

        Update an existing team, you can pass all or just a subset of all attributes (passing users will replace all existing ones)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TeamEditForm body: (required)
        :param int id: Team ID to update (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an existing team  # noqa: E501

        Update an existing team, you can pass all or just a subset of all attributes (passing users will replace all existing ones)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TeamEditForm body: (required)
        :param int id: Team ID to update (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_teams_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_projects_project_id_delete(self, id, project_id, **kwargs):  # noqa: E501
        """Revokes access for a project from a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_projects_project_id_delete(id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team whose permission will be revoked (required)
        :param int project_id: The project to remove (Project ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_projects_project_id_delete_with_http_info(id, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_projects_project_id_delete_with_http_info(id, project_id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_projects_project_id_delete_with_http_info(self, id, project_id, **kwargs):  # noqa: E501
        """Revokes access for a project from a team  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_projects_project_id_delete_with_http_info(id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team whose permission will be revoked (required)
        :param int project_id: The project to remove (Project ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_projects_project_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_projects_project_id_delete`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `api_teams_id_projects_project_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}/projects/{projectId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_id_projects_project_id_post(self, id, project_id, **kwargs):  # noqa: E501
        """Grant the team access to a project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_projects_project_id_post(id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team that is granted access (required)
        :param int project_id: The project to grant acecess to (Project ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_id_projects_project_id_post_with_http_info(id, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_id_projects_project_id_post_with_http_info(id, project_id, **kwargs)  # noqa: E501
            return data

    def api_teams_id_projects_project_id_post_with_http_info(self, id, project_id, **kwargs):  # noqa: E501
        """Grant the team access to a project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_id_projects_project_id_post_with_http_info(id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The team that is granted access (required)
        :param int project_id: The project to grant acecess to (Project ID) (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_id_projects_project_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_teams_id_projects_project_id_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `api_teams_id_projects_project_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams/{id}/projects/{projectId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_teams_post(self, body, **kwargs):  # noqa: E501
        """Creates a new team  # noqa: E501

        Creates a new team and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TeamEditForm body: (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_teams_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_teams_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_teams_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new team  # noqa: E501

        Creates a new team and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_teams_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TeamEditForm body: (required)
        :return: TeamEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_teams_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_teams_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/teams', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TeamEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_active_get(self, **kwargs):  # noqa: E501
        """Returns the collection of active timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_active_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_active_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_active_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_timesheets_active_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the collection of active timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_active_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_active_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/active', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimesheetSubCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_get(self, **kwargs):  # noqa: E501
        """Returns a collection of timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str customer: Customer ID to filter timesheets
        :param str project: Project ID to filter timesheets
        :param str activity: Activity ID to filter timesheets
        :param str page: The page to display, renders a 404 if not found (default: 1)
        :param str size: The amount of entries for each page (default: 50)
        :param str tags: The name of tags which are in the datasets
        :param str order_by: The field by which results will be ordered. Allowed values: id, begin, end, rate (default: begin)
        :param str order: The result order. Allowed values: ASC, DESC (default: DESC)
        :param str begin: Only records after this date will be included (format: HTML5)
        :param str end: Only records before this date will be included (format: HTML5)
        :param str exported: Use this flag if you want to filter for export state. Allowed values: 0=not exported, 1=exported (default: all)
        :param str active: Filter for running/active records. Allowed values: 0=stopped, 1=active (default: all)
        :param str full: Allows to fetch fully serialized objects including subresources (TimesheetSubCollection). Allowed values: true (default: false)
        :param str term: Free search term
        :return: list[TimesheetCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_timesheets_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a collection of timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str customer: Customer ID to filter timesheets
        :param str project: Project ID to filter timesheets
        :param str activity: Activity ID to filter timesheets
        :param str page: The page to display, renders a 404 if not found (default: 1)
        :param str size: The amount of entries for each page (default: 50)
        :param str tags: The name of tags which are in the datasets
        :param str order_by: The field by which results will be ordered. Allowed values: id, begin, end, rate (default: begin)
        :param str order: The result order. Allowed values: ASC, DESC (default: DESC)
        :param str begin: Only records after this date will be included (format: HTML5)
        :param str end: Only records before this date will be included (format: HTML5)
        :param str exported: Use this flag if you want to filter for export state. Allowed values: 0=not exported, 1=exported (default: all)
        :param str active: Filter for running/active records. Allowed values: 0=stopped, 1=active (default: all)
        :param str full: Allows to fetch fully serialized objects including subresources (TimesheetSubCollection). Allowed values: true (default: false)
        :param str term: Free search term
        :return: list[TimesheetCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user', 'customer', 'project', 'activity', 'page', 'size', 'tags', 'order_by', 'order', 'begin', 'end', 'exported', 'active', 'full', 'term']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'user' in params and not re.search(r'\\d+|all', params['user']):  # noqa: E501
            raise ValueError("Invalid value for parameter `user` when calling `api_timesheets_get`, must conform to the pattern `/\\d+|all/`")  # noqa: E501
        if 'customer' in params and not re.search(r'\\d+', params['customer']):  # noqa: E501
            raise ValueError("Invalid value for parameter `customer` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'project' in params and not re.search(r'\\d+', params['project']):  # noqa: E501
            raise ValueError("Invalid value for parameter `project` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'activity' in params and not re.search(r'\\d+', params['activity']):  # noqa: E501
            raise ValueError("Invalid value for parameter `activity` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'page' in params and not re.search(r'\\d+', params['page']):  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'size' in params and not re.search(r'\\d+', params['size']):  # noqa: E501
            raise ValueError("Invalid value for parameter `size` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'order_by' in params and not re.search(r'id|begin|end|rate', params['order_by']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order_by` when calling `api_timesheets_get`, must conform to the pattern `/id|begin|end|rate/`")  # noqa: E501
        if 'order' in params and not re.search(r'ASC|DESC', params['order']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order` when calling `api_timesheets_get`, must conform to the pattern `/ASC|DESC/`")  # noqa: E501
        if 'exported' in params and not re.search(r'0|1', params['exported']):  # noqa: E501
            raise ValueError("Invalid value for parameter `exported` when calling `api_timesheets_get`, must conform to the pattern `/0|1/`")  # noqa: E501
        if 'active' in params and not re.search(r'0|1', params['active']):  # noqa: E501
            raise ValueError("Invalid value for parameter `active` when calling `api_timesheets_get`, must conform to the pattern `/0|1/`")  # noqa: E501
        if 'full' in params and not re.search(r'true', params['full']):  # noqa: E501
            raise ValueError("Invalid value for parameter `full` when calling `api_timesheets_get`, must conform to the pattern `/true/`")  # noqa: E501
        if 'term' in params and not re.search(r'[a-zA-Z0-9 \\-,:]+', params['term']):  # noqa: E501
            raise ValueError("Invalid value for parameter `term` when calling `api_timesheets_get`, must conform to the pattern `/[a-zA-Z0-9 \\-,:]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
        if 'customer' in params:
            query_params.append(('customer', params['customer']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501
        if 'activity' in params:
            query_params.append(('activity', params['activity']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'tags' in params:
            query_params.append(('tags', params['tags']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'exported' in params:
            query_params.append(('exported', params['exported']))  # noqa: E501
        if 'active' in params:
            query_params.append(('active', params['active']))  # noqa: E501
        if 'full' in params:
            query_params.append(('full', params['full']))  # noqa: E501
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimesheetCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete an existing timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an existing timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_export_patch(self, id, **kwargs):  # noqa: E501
        """Switch the export state of a timesheet record to (un-)lock it  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_export_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to switch export state (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_export_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_export_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_export_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Switch the export state of a timesheet record to (un-)lock it  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_export_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to switch export state (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_export_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_export_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/export', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_get(self, id, **kwargs):  # noqa: E501
        """Returns one timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to fetch (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns one timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to fetch (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_meta_patch(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing timesheet.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_meta_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to set the meta-field value for (required)
        :param Body4 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_meta_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing timesheet.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_meta_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to set the meta-field value for (required)
        :param Body4 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_meta_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_meta_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/meta', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update an existing timesheet record  # noqa: E501

        Update an existing timesheet record, you can pass all or just a subset of the attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :param int id: Timesheet record ID to update (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an existing timesheet record  # noqa: E501

        Update an existing timesheet record, you can pass all or just a subset of the attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :param int id: Timesheet record ID to update (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_timesheets_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_restart_patch(self, id, **kwargs):  # noqa: E501
        """Restarts a previously stopped timesheet record for the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_restart_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to restart (required)
        :param Body3 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_restart_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_restart_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_restart_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Restarts a previously stopped timesheet record for the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_restart_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to restart (required)
        :param Body3 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_restart_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_restart_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/restart', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_stop_patch(self, id, **kwargs):  # noqa: E501
        """Stops an active timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_stop_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to stop (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_stop_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_stop_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_stop_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Stops an active timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_stop_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to stop (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_stop_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_stop_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/stop', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_post(self, body, **kwargs):  # noqa: E501
        """Creates a new timesheet record  # noqa: E501

        Creates a new timesheet record for the current user and returns it afterwards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_timesheets_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new timesheet record  # noqa: E501

        Creates a new timesheet record for the current user and returns it afterwards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_timesheets_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_recent_get(self, **kwargs):  # noqa: E501
        """Returns the collection of recent user activities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_recent_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str begin: Only records after this date will be included. Default: today - 1 year (format: HTML5)
        :param str size: The amount of entries (default: 10)
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_recent_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_recent_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_timesheets_recent_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the collection of recent user activities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_recent_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str begin: Only records after this date will be included. Default: today - 1 year (format: HTML5)
        :param str size: The amount of entries (default: 10)
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user', 'begin', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_recent_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'user' in params and not re.search(r'\\d+|all', params['user']):  # noqa: E501
            raise ValueError("Invalid value for parameter `user` when calling `api_timesheets_recent_get`, must conform to the pattern `/\\d+|all/`")  # noqa: E501
        if 'size' in params and not re.search(r'\\d+', params['size']):  # noqa: E501
            raise ValueError("Invalid value for parameter `size` when calling `api_timesheets_recent_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/recent', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimesheetSubCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_users_get(self, **kwargs):  # noqa: E501
        """Returns the collection of all registered users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str visible: Visibility status to filter users. Allowed values: 1=visible, 2=hidden, 3=all (default: 1)
        :param str order_by: The field by which results will be ordered. Allowed values: id, username, alias, email (default: username)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str term: Free search term
        :return: list[UserCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_users_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_users_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_users_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the collection of all registered users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str visible: Visibility status to filter users. Allowed values: 1=visible, 2=hidden, 3=all (default: 1)
        :param str order_by: The field by which results will be ordered. Allowed values: id, username, alias, email (default: username)
        :param str order: The result order. Allowed values: ASC, DESC (default: ASC)
        :param str term: Free search term
        :return: list[UserCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['visible', 'order_by', 'order', 'term']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_users_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'visible' in params and not re.search(r'1|2|3', params['visible']):  # noqa: E501
            raise ValueError("Invalid value for parameter `visible` when calling `api_users_get`, must conform to the pattern `/1|2|3/`")  # noqa: E501
        if 'order_by' in params and not re.search(r'id|username|alias|email', params['order_by']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order_by` when calling `api_users_get`, must conform to the pattern `/id|username|alias|email/`")  # noqa: E501
        if 'order' in params and not re.search(r'ASC|DESC', params['order']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order` when calling `api_users_get`, must conform to the pattern `/ASC|DESC/`")  # noqa: E501
        if 'term' in params and not re.search(r'[a-zA-Z0-9 \\-,:]+', params['term']):  # noqa: E501
            raise ValueError("Invalid value for parameter `term` when calling `api_users_get`, must conform to the pattern `/[a-zA-Z0-9 \\-,:]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'visible' in params:
            query_params.append(('visible', params['visible']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UserCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_users_id_get(self, id, **kwargs):  # noqa: E501
        """Return one user entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: User ID to fetch (required)
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_users_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_users_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_users_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Return one user entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: User ID to fetch (required)
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_users_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_users_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/users/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_users_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update an existing user  # noqa: E501

        Update an existing user, you can pass all or just a subset of all attributes (passing roles will replace all existing ones)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserEditForm body: (required)
        :param int id: User ID to update (required)
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_users_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_users_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def api_users_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an existing user  # noqa: E501

        Update an existing user, you can pass all or just a subset of all attributes (passing roles will replace all existing ones)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserEditForm body: (required)
        :param int id: User ID to update (required)
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_users_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_users_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_users_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/users/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_users_me_get(self, **kwargs):  # noqa: E501
        """Return the current user entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_me_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_users_me_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_users_me_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_users_me_get_with_http_info(self, **kwargs):  # noqa: E501
        """Return the current user entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_me_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_users_me_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/users/me', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_users_post(self, body, **kwargs):  # noqa: E501
        """Creates a new user  # noqa: E501

        Creates a new user and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserCreateForm body: (required)
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_users_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_users_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_users_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new user  # noqa: E501

        Creates a new user and returns it afterwards  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_users_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserCreateForm body: (required)
        :return: UserEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_users_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_users_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_version_get(self, **kwargs):  # noqa: E501
        """Returns information about the Kimai release  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_version_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_version_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_version_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_version_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns information about the Kimai release  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_version_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_version_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/version', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
