import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "monocdk.experiment",
    "version": "1.50.0",
    "description": "An experiment to bundle the entire CDK into a single module",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "monocdk_experiment",
        "monocdk_experiment._jsii",
        "monocdk_experiment.alexa_ask",
        "monocdk_experiment.app_delivery",
        "monocdk_experiment.assets",
        "monocdk_experiment.aws_accessanalyzer",
        "monocdk_experiment.aws_acmpca",
        "monocdk_experiment.aws_amazonmq",
        "monocdk_experiment.aws_amplify",
        "monocdk_experiment.aws_apigateway",
        "monocdk_experiment.aws_apigatewayv2",
        "monocdk_experiment.aws_appconfig",
        "monocdk_experiment.aws_applicationautoscaling",
        "monocdk_experiment.aws_appmesh",
        "monocdk_experiment.aws_appstream",
        "monocdk_experiment.aws_appsync",
        "monocdk_experiment.aws_athena",
        "monocdk_experiment.aws_autoscaling",
        "monocdk_experiment.aws_autoscaling_common",
        "monocdk_experiment.aws_autoscaling_hooktargets",
        "monocdk_experiment.aws_autoscalingplans",
        "monocdk_experiment.aws_backup",
        "monocdk_experiment.aws_batch",
        "monocdk_experiment.aws_budgets",
        "monocdk_experiment.aws_cassandra",
        "monocdk_experiment.aws_ce",
        "monocdk_experiment.aws_certificatemanager",
        "monocdk_experiment.aws_chatbot",
        "monocdk_experiment.aws_cloud9",
        "monocdk_experiment.aws_cloudformation",
        "monocdk_experiment.aws_cloudfront",
        "monocdk_experiment.aws_cloudtrail",
        "monocdk_experiment.aws_cloudwatch",
        "monocdk_experiment.aws_cloudwatch_actions",
        "monocdk_experiment.aws_codebuild",
        "monocdk_experiment.aws_codecommit",
        "monocdk_experiment.aws_codedeploy",
        "monocdk_experiment.aws_codeguruprofiler",
        "monocdk_experiment.aws_codepipeline",
        "monocdk_experiment.aws_codepipeline_actions",
        "monocdk_experiment.aws_codestar",
        "monocdk_experiment.aws_codestarconnections",
        "monocdk_experiment.aws_codestarnotifications",
        "monocdk_experiment.aws_cognito",
        "monocdk_experiment.aws_config",
        "monocdk_experiment.aws_datapipeline",
        "monocdk_experiment.aws_dax",
        "monocdk_experiment.aws_detective",
        "monocdk_experiment.aws_directoryservice",
        "monocdk_experiment.aws_dlm",
        "monocdk_experiment.aws_dms",
        "monocdk_experiment.aws_docdb",
        "monocdk_experiment.aws_dynamodb",
        "monocdk_experiment.aws_ec2",
        "monocdk_experiment.aws_ecr",
        "monocdk_experiment.aws_ecr_assets",
        "monocdk_experiment.aws_ecs",
        "monocdk_experiment.aws_ecs_patterns",
        "monocdk_experiment.aws_efs",
        "monocdk_experiment.aws_eks",
        "monocdk_experiment.aws_eks_legacy",
        "monocdk_experiment.aws_elasticache",
        "monocdk_experiment.aws_elasticbeanstalk",
        "monocdk_experiment.aws_elasticloadbalancing",
        "monocdk_experiment.aws_elasticloadbalancingv2",
        "monocdk_experiment.aws_elasticloadbalancingv2_actions",
        "monocdk_experiment.aws_elasticloadbalancingv2_targets",
        "monocdk_experiment.aws_elasticsearch",
        "monocdk_experiment.aws_emr",
        "monocdk_experiment.aws_events",
        "monocdk_experiment.aws_events_targets",
        "monocdk_experiment.aws_eventschemas",
        "monocdk_experiment.aws_fms",
        "monocdk_experiment.aws_fsx",
        "monocdk_experiment.aws_gamelift",
        "monocdk_experiment.aws_globalaccelerator",
        "monocdk_experiment.aws_glue",
        "monocdk_experiment.aws_greengrass",
        "monocdk_experiment.aws_guardduty",
        "monocdk_experiment.aws_iam",
        "monocdk_experiment.aws_imagebuilder",
        "monocdk_experiment.aws_inspector",
        "monocdk_experiment.aws_iot",
        "monocdk_experiment.aws_iot1click",
        "monocdk_experiment.aws_iotanalytics",
        "monocdk_experiment.aws_iotevents",
        "monocdk_experiment.aws_iotthingsgraph",
        "monocdk_experiment.aws_kinesis",
        "monocdk_experiment.aws_kinesisanalytics",
        "monocdk_experiment.aws_kinesisfirehose",
        "monocdk_experiment.aws_kms",
        "monocdk_experiment.aws_lakeformation",
        "monocdk_experiment.aws_lambda",
        "monocdk_experiment.aws_lambda_destinations",
        "monocdk_experiment.aws_lambda_event_sources",
        "monocdk_experiment.aws_lambda_nodejs",
        "monocdk_experiment.aws_logs",
        "monocdk_experiment.aws_logs_destinations",
        "monocdk_experiment.aws_macie",
        "monocdk_experiment.aws_managedblockchain",
        "monocdk_experiment.aws_mediaconvert",
        "monocdk_experiment.aws_medialive",
        "monocdk_experiment.aws_mediastore",
        "monocdk_experiment.aws_msk",
        "monocdk_experiment.aws_neptune",
        "monocdk_experiment.aws_networkmanager",
        "monocdk_experiment.aws_opsworks",
        "monocdk_experiment.aws_opsworkscm",
        "monocdk_experiment.aws_pinpoint",
        "monocdk_experiment.aws_pinpointemail",
        "monocdk_experiment.aws_qldb",
        "monocdk_experiment.aws_ram",
        "monocdk_experiment.aws_rds",
        "monocdk_experiment.aws_redshift",
        "monocdk_experiment.aws_resourcegroups",
        "monocdk_experiment.aws_robomaker",
        "monocdk_experiment.aws_route53",
        "monocdk_experiment.aws_route53_patterns",
        "monocdk_experiment.aws_route53_targets",
        "monocdk_experiment.aws_route53resolver",
        "monocdk_experiment.aws_s3",
        "monocdk_experiment.aws_s3_assets",
        "monocdk_experiment.aws_s3_deployment",
        "monocdk_experiment.aws_s3_notifications",
        "monocdk_experiment.aws_sagemaker",
        "monocdk_experiment.aws_sam",
        "monocdk_experiment.aws_sdb",
        "monocdk_experiment.aws_secretsmanager",
        "monocdk_experiment.aws_securityhub",
        "monocdk_experiment.aws_servicecatalog",
        "monocdk_experiment.aws_servicediscovery",
        "monocdk_experiment.aws_ses",
        "monocdk_experiment.aws_ses_actions",
        "monocdk_experiment.aws_sns",
        "monocdk_experiment.aws_sns_subscriptions",
        "monocdk_experiment.aws_sqs",
        "monocdk_experiment.aws_ssm",
        "monocdk_experiment.aws_stepfunctions",
        "monocdk_experiment.aws_stepfunctions_tasks",
        "monocdk_experiment.aws_synthetics",
        "monocdk_experiment.aws_transfer",
        "monocdk_experiment.aws_waf",
        "monocdk_experiment.aws_wafregional",
        "monocdk_experiment.aws_wafv2",
        "monocdk_experiment.aws_workspaces",
        "monocdk_experiment.cloud_assembly_schema",
        "monocdk_experiment.cloudformation_include",
        "monocdk_experiment.custom_resources",
        "monocdk_experiment.cx_api",
        "monocdk_experiment.region_info"
    ],
    "package_data": {
        "monocdk_experiment._jsii": [
            "monocdk-experiment@1.50.0.jsii.tgz"
        ],
        "monocdk_experiment": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii>=1.8.0, <2.0.0",
        "publication>=0.0.3",
        "constructs>=3.0.2, <4.0.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "Development Status :: 4 - Beta",
        "License :: OSI Approved"
    ]
}
"""
)

with open("README.md") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
