import * as cxschema from "../../../cloud-assembly-schema";
import { CloudArtifact } from '../cloud-artifact';
import { CloudAssembly } from '../cloud-assembly';
import { Environment } from '../environment';
export declare class CloudFormationStackArtifact extends CloudArtifact {
    /**
     * The file name of the template.
     */
    readonly templateFile: string;
    /**
     * The original name as defined in the CDK app.
     */
    readonly originalName: string;
    /**
     * Any assets associated with this stack.
     */
    readonly assets: cxschema.AssetMetadataEntry[];
    /**
     * CloudFormation parameters to pass to the stack.
     */
    readonly parameters: {
        [id: string]: string;
    };
    /**
     * The physical name of this stack.
     */
    readonly stackName: string;
    /**
     * A string that represents this stack. Should only be used in user interfaces.
     * If the stackName and artifactId are the same, it will just return that. Otherwise,
     * it will return something like "<artifactId> (<stackName>)"
     */
    readonly displayName: string;
    /**
     * The physical name of this stack.
     * @deprecated renamed to `stackName`
     */
    readonly name: string;
    /**
     * The environment into which to deploy this artifact.
     */
    readonly environment: Environment;
    /**
     * The role that needs to be assumed to deploy the stack
     *
     * @default - No role is assumed (current credentials are used)
     */
    readonly assumeRoleArn?: string;
    /**
     * The role that is passed to CloudFormation to execute the change set
     *
     * @default - No role is passed (currently assumed role/credentials are used)
     */
    readonly cloudFormationExecutionRoleArn?: string;
    /**
     * If the stack template has already been included in the asset manifest, its asset URL
     *
     * @default - Not uploaded yet, upload just before deploying
     */
    readonly stackTemplateAssetObjectUrl?: string;
    /**
     * Version of bootstrap stack required to deploy this stack
     *
     * @default - No bootstrap stack required
     */
    readonly requiresBootstrapStackVersion?: number;
    /**
     * Whether termination protection is enabled for this stack.
     */
    readonly terminationProtection?: boolean;
    private _template;
    constructor(assembly: CloudAssembly, artifactId: string, artifact: cxschema.ArtifactManifest);
    /**
     * The CloudFormation template for this stack.
     */
    get template(): any;
}
