"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const s3 = require("../../aws-s3"); // Automatically re-written from '@aws-cdk/aws-s3'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Use a Lambda function as a bucket notification destination
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    bind(_scope, bucket) {
        const permissionId = `AllowBucketNotificationsFrom${bucket.node.uniqueId}`;
        if (this.fn.permissionsNode.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = this.fn.permissionsNode.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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