"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SfnStateMachine = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 */
class SfnStateMachine {
    constructor(machine, props = {}) {
        this.machine = machine;
        this.props = props;
    }
    /**
     * Returns a properties that are used in an Rule to trigger this State Machine
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.machine.stateMachineArn,
            role: util_1.singletonEventRole(this.machine, [new iam.PolicyStatement({
                    actions: ['states:StartExecution'],
                    resources: [this.machine.stateMachineArn],
                })]),
            input: this.props.input,
            targetResource: this.machine,
        };
    }
}
exports.SfnStateMachine = SfnStateMachine;
//# sourceMappingURL=data:application/json;base64,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