"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleLabel = exports.renderBottlerocketUserData = exports.renderAmazonLinuxUserData = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// tslint:disable-next-line:max-line-length
function renderAmazonLinuxUserData(clusterName, autoScalingGroup, options = {}) {
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge true');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
function renderBottlerocketUserData(cluster) {
    return [
        '[settings.kubernetes]',
        `api-server="${cluster.clusterEndpoint}"`,
        `cluster-certificate="${cluster.clusterCertificateAuthorityData}"`,
        `cluster-name="${cluster.clusterName}"`,
    ];
}
exports.renderBottlerocketUserData = renderBottlerocketUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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