"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.joinWithCommas = exports.renderCommonLogDriverOptions = exports.stringifyOptions = exports.ensureInRange = exports.ensurePositiveInteger = exports.removeEmpty = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Remove undefined values from a dictionary
 */
function removeEmpty(x) {
    for (const key of Object.keys(x)) {
        if (x[key] === undefined) {
            delete x[key];
        }
    }
    return x;
}
exports.removeEmpty = removeEmpty;
/**
 * Checks that a value is a positive integer
 */
function ensurePositiveInteger(val) {
    if (!core_1.Token.isUnresolved(val) && Number.isInteger(val) && val < 0) {
        throw new Error(`\`${val}\` must be a positive integer.`);
    }
}
exports.ensurePositiveInteger = ensurePositiveInteger;
/**
 * Checks that a value is contained in a range of two other values
 */
function ensureInRange(val, start, end) {
    if (!core_1.Token.isUnresolved(val) && !(val >= start && val <= end)) {
        throw new Error(`\`${val}\` must be within range ${start}:${end}`);
    }
}
exports.ensureInRange = ensureInRange;
function stringifyOptions(options) {
    const _options = {};
    const filteredOptions = removeEmpty(options);
    for (const key of Object.keys(filteredOptions)) {
        // Convert value to string
        _options[key] = `${filteredOptions[key]}`;
    }
    return _options;
}
exports.stringifyOptions = stringifyOptions;
function renderCommonLogDriverOptions(opts) {
    return {
        'tag': opts.tag,
        'labels': joinWithCommas(opts.labels),
        'env': joinWithCommas(opts.env),
        'env-regex': opts.envRegex,
    };
}
exports.renderCommonLogDriverOptions = renderCommonLogDriverOptions;
function joinWithCommas(xs) {
    return xs && xs.join(',');
}
exports.joinWithCommas = joinWithCommas;
//# sourceMappingURL=data:application/json;base64,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