"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpStage = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const api_mapping_1 = require("./api-mapping");
const DEFAULT_STAGE_NAME = '$default';
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class HttpStage extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName ? props.stageName : DEFAULT_STAGE_NAME,
        });
        new apigatewayv2_generated_1.CfnStage(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        this.stageName = this.physicalName;
        this.httpApi = props.httpApi;
        if (props.domainMapping) {
            new api_mapping_1.HttpApiMapping(this, `${props.domainMapping.domainName}${props.domainMapping.mappingKey}`, {
                api: props.httpApi,
                domainName: props.domainMapping.domainName,
                stage: this,
                apiMappingKey: props.domainMapping.mappingKey,
            });
        }
    }
    /**
     * Import an existing stage into this CDK app.
     */
    static fromStageName(scope, id, stageName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.stageName = stageName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * The URL to this stage.
     */
    get url() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName === DEFAULT_STAGE_NAME ? '' : this.stageName;
        return `https://${this.httpApi.httpApiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
}
exports.HttpStage = HttpStage;
//# sourceMappingURL=data:application/json;base64,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