"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegration = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_1 = require("../integration");
const util_1 = require("../util");
/**
 * This type of integration lets an API expose AWS service actions. It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
class AwsIntegration extends integration_1.Integration {
    constructor(props) {
        const backend = props.subdomain ? `${props.subdomain}.${props.service}` : props.service;
        const type = props.proxy ? integration_1.IntegrationType.AWS_PROXY : integration_1.IntegrationType.AWS;
        const { apiType, apiValue } = util_1.parseAwsApiCall(props.path, props.action, props.actionParameters);
        super({
            type,
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            uri: cdk.Lazy.stringValue({ produce: () => {
                    if (!this.scope) {
                        throw new Error('AwsIntegration must be used in API');
                    }
                    return cdk.Stack.of(this.scope).formatArn({
                        service: 'apigateway',
                        account: backend,
                        resource: apiType,
                        sep: '/',
                        resourceName: apiValue,
                    });
                } }),
            options: props.options,
        });
    }
    bind(method) {
        const bindResult = super.bind(method);
        this.scope = method;
        return bindResult;
    }
}
exports.AwsIntegration = AwsIntegration;
//# sourceMappingURL=data:application/json;base64,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