"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RollbackEvent = exports.EcsDeploymentGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codedeploy_1 = require("aws-cdk-lib/aws-codedeploy");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const ecs_deployment_config_1 = require("./ecs-deployment-config");
class EcsDeploymentGroup extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.tags = new aws_cdk_lib_1.TagManager(aws_cdk_lib_1.TagType.KEY_VALUE, 'TagManager');
        const { application, deploymentGroupName, deploymentConfig, ecsServices, targetGroups, prodTrafficListener, testTrafficListener, terminationWaitTime = aws_cdk_lib_1.Duration.minutes(60), autoRollbackOnEvents, } = props;
        if (terminationWaitTime.toMinutes() > 2880) {
            throw new Error('Invalid TerminationWaitTimeInMinutes: The maximum setting is 2880 minutes (2 days).');
        }
        const codeDeployEcsRole = new aws_iam_1.Role(this, 'Role', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AWSCodeDeployRoleForECS')],
        });
        if (application) {
            this.application = application;
        }
        else {
            this.application = new aws_codedeploy_1.EcsApplication(this, 'EcsApplication', {
                applicationName: props.applicationName,
            });
        }
        const serviceToken = new aws_lambda_1.Function(this, 'Function', {
            runtime: aws_lambda_1.Runtime.NODEJS_14_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'ecs-deployment-group')),
            handler: 'index.handler',
            timeout: aws_cdk_lib_1.Duration.minutes(15),
        });
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                'codeDeploy:CreateDeploymentGroup',
                'codeDeploy:UpdateDeploymentGroup',
                'codeDeploy:DeleteDeploymentGroup',
                'codeDeploy:TagResource',
                'codeDeploy:UntagResource',
            ],
            resources: ['*'],
        }));
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['iam:PassRole'],
            resources: [codeDeployEcsRole.roleArn],
        }));
        this.deploymentConfig = deploymentConfig || ecs_deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE;
        if (constructs_1.Construct.isConstruct(props.deploymentConfig)) {
            this.node.addDependency(props.deploymentConfig);
        }
        this.node.addDependency(...ecsServices);
        const ecsDeploymentGroup = new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: serviceToken.functionArn,
            resourceType: 'Custom::EcsDeploymentGroup',
            properties: {
                ApplicationName: this.application.applicationName,
                DeploymentGroupName: deploymentGroupName,
                ServiceRoleArn: codeDeployEcsRole.roleArn,
                TargetGroupNames: targetGroups.map((tg) => tg.targetGroupName),
                EcsServices: ecsServices.map((service) => ({
                    ClusterName: service.clusterName,
                    ServiceName: service.serviceName,
                })),
                ProdTrafficListenerArn: prodTrafficListener.listenerArn,
                TestTrafficListenerArn: testTrafficListener.listenerArn,
                TerminationWaitTimeInMinutes: terminationWaitTime.toMinutes(),
                AutoRollbackOnEvents: autoRollbackOnEvents,
                DeploymentConfigName: this.deploymentConfig.deploymentConfigName,
                Tags: aws_cdk_lib_1.Lazy.any({ produce: () => this.tags.renderTags() }),
            },
        });
        this.deploymentGroupName = ecsDeploymentGroup.ref;
        this.deploymentGroupArn = ecsDeploymentGroup.getAttString('Arn');
    }
}
exports.EcsDeploymentGroup = EcsDeploymentGroup;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentGroup[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsDeploymentGroup", version: "2.1.0" };
var RollbackEvent;
(function (RollbackEvent) {
    RollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    RollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    RollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(RollbackEvent = exports.RollbackEvent || (exports.RollbackEvent = {}));
//# sourceMappingURL=data:application/json;base64,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