R = {
'static/js/notes.js': b"Notes = window.Notes || {};\n\n(function(exports, $) {\n  function Editor() {\n    this.form = $('form#note-form');\n    this.editor = $('textarea#content');\n    this.container = $('ul.notes');\n    this.initialize();\n  }\n\n  Editor.prototype.initialize = function() {\n    this.setupMasonry();\n    this.setupNotes();\n    this.setupForm();\n    this.editor.focus();\n  }\n\n  Editor.prototype.setupMasonry = function() {\n    var self = this;\n    imagesLoaded(this.container, function() {\n      self.container.masonry({'itemSelector': '.note'});\n    });\n  }\n\n  Editor.prototype.setupNotes = function() {\n    var self = this;\n    $('a.archive-note').on('click', this.archiveNote);\n  }\n\n  Editor.prototype.archiveNote = function(e) {\n    e.preventDefault();\n    var elem = $(this);\n    var panel = elem.parents('.panel');\n    var self = this;\n    $.post(elem.attr('href'), function(data) {\n      if (data.success) {\n        panel.remove();\n        $('ul.notes').masonry();\n      }\n    });\n  }\n\n  Editor.prototype.setupForm = function() {\n    var self = this;\n    this.editor.on('keydown', function(e) {\n      if (e.ctrlKey && e.keyCode == 13) {\n        self.form.submit();\n      }\n    });\n    this.form.submit(function(e) {\n      e.preventDefault();\n      self.addNote();\n    });\n    this.addMarkdownHelpers();\n  }\n\n  Editor.prototype.addNote = function() {\n    var self = this;\n    this.editor.css('color', '#464545');\n    $.post(this.form.attr('target'), this.form.serialize(), function(data) {\n      if (data.success) {\n        self.editor.val('').focus();\n        listElem = $(data.note);\n        listElem.find('a.archive-note').on('click', self.archiveNote);\n        self.container.prepend(listElem);\n        self.container.masonry('prepended', listElem);\n      } else {\n        self.editor.css('color', '#dd1111');\n      }\n    });\n  }\n\n  Editor.prototype.addMarkdownHelpers = function() {\n    var self = this;\n    this.addHelper('indent-left', function(line) {\n      return '    ' + line;\n    });\n    this.addHelper('indent-right', function(line) {\n      return line.substring(4);\n    });\n    this.addHelper('list', function(line) {\n      return '* ' + line;\n    });\n    this.addHelper('bold', function(line) {\n      return '**' + line + '**';\n    });\n    this.addHelper('italic', function(line) {\n      return '*' + line + '*';\n    });\n    this.addHelper('font', null, function() {\n      self.focus().select();\n    });\n  }\n\n  Editor.prototype.addHelper = function(iconClass, lineHandler, callBack) {\n    var link = $('<a>', {'class': 'btn btn-xs'}),\n        icon = $('<span>', {'class': 'glyphicon glyphicon-' + iconClass}),\n        self = this;\n\n    if (!callBack) {\n      callBack = function() {\n        self.modifySelection(lineHandler);\n      }\n    }\n\n    link.on('click', function(e) {\n      e.preventDefault();\n      callBack();\n    });\n    link.append(icon);\n    this.editor.before(link);\n  }\n\n  Editor.prototype.modifySelection = function(lineHandler) {\n    var selection = this.getSelectedText();\n    if (!selection) return;\n\n    var lines = selection.split('\\n'),\n        result = [];\n    for (var i = 0; i < lines.length; i++) {\n      result.push(lineHandler(lines[i]));\n    }\n\n    this.editor.val(\n      this.editor.val().split(selection).join(result.join('\\n'))\n    );\n  }\n\n  Editor.prototype.getSelectedText = function() {\n    var textAreaDOM = this.editor[0];\n    return this.editor.val().substring(\n      textAreaDOM.selectionStart,\n      textAreaDOM.selectionEnd);\n  }\n\n  exports.Editor = Editor;\n})(Notes, jQuery);",
}
