"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const cognito_generated_1 = require("./cognito.generated");
/**
 * Types of authentication flow
 */
var AuthFlow;
(function (AuthFlow) {
    /**
     * Enable flow for server-side or admin authentication (no client app)
     */
    AuthFlow["ADMIN_NO_SRP"] = "ADMIN_NO_SRP_AUTH";
    /**
     * Enable custom authentication flow
     */
    AuthFlow["CUSTOM_FLOW_ONLY"] = "CUSTOM_AUTH_FLOW_ONLY";
    /**
     * Enable auth using username & password
     */
    AuthFlow["USER_PASSWORD"] = "USER_PASSWORD_AUTH";
})(AuthFlow = exports.AuthFlow || (exports.AuthFlow = {}));
/**
 * Define a UserPool App Client
 */
class UserPoolClient extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.userPoolClientName,
        });
        const resource = new cognito_generated_1.CfnUserPoolClient(this, 'Resource', {
            clientName: this.physicalName,
            generateSecret: props.generateSecret,
            userPoolId: props.userPool.userPoolId,
            explicitAuthFlows: props.enabledAuthFlows
        });
        this.userPoolClientId = resource.ref;
        this.userPoolClientClientSecret = resource.attrClientSecret;
        this.userPoolClientName = resource.attrName;
    }
}
exports.UserPoolClient = UserPoolClient;
//# sourceMappingURL=data:application/json;base64,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