# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'DatasetCsvOptionsArgs',
    'DatasetDataCatalogInputDefinitionArgs',
    'DatasetDatabaseInputDefinitionArgs',
    'DatasetDatetimeOptionsArgs',
    'DatasetExcelOptionsArgs',
    'DatasetFilesLimitArgs',
    'DatasetFilterExpressionArgs',
    'DatasetFilterValueArgs',
    'DatasetFormatOptionsArgs',
    'DatasetInputArgs',
    'DatasetJsonOptionsArgs',
    'DatasetParameterArgs',
    'DatasetPathOptionsArgs',
    'DatasetPathParameterArgs',
    'DatasetS3LocationArgs',
    'DatasetTagArgs',
    'JobColumnSelectorArgs',
    'JobColumnStatisticsConfigurationArgs',
    'JobCsvOutputOptionsArgs',
    'JobDataCatalogOutputArgs',
    'JobDatabaseOutputArgs',
    'JobDatabaseTableOutputOptionsArgs',
    'JobOutputFormatOptionsArgs',
    'JobOutputLocationArgs',
    'JobOutputArgs',
    'JobParameterMapArgs',
    'JobProfileConfigurationArgs',
    'JobRecipeArgs',
    'JobS3LocationArgs',
    'JobS3TableOutputOptionsArgs',
    'JobSampleArgs',
    'JobStatisticOverrideArgs',
    'JobStatisticsConfigurationArgs',
    'JobTagArgs',
    'JobValidationConfigurationArgs',
    'ProjectSampleArgs',
    'ProjectTagArgs',
    'RecipeActionArgs',
    'RecipeConditionExpressionArgs',
    'RecipeDataCatalogInputDefinitionArgs',
    'RecipeParameterMapArgs',
    'RecipeParametersInputPropertiesArgs',
    'RecipeParametersArgs',
    'RecipeS3LocationArgs',
    'RecipeSecondaryInputArgs',
    'RecipeStepArgs',
    'RecipeTagArgs',
    'ScheduleTagArgs',
]

@pulumi.input_type
class DatasetCsvOptionsArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 header_row: Optional[pulumi.Input[bool]] = None):
        """
        Csv options
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if header_row is not None:
            pulumi.set(__self__, "header_row", header_row)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="headerRow")
    def header_row(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "header_row")

    @header_row.setter
    def header_row(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "header_row", value)


@pulumi.input_type
class DatasetDataCatalogInputDefinitionArgs:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 temp_directory: Optional[pulumi.Input['DatasetS3LocationArgs']] = None):
        """
        :param pulumi.Input[str] catalog_id: Catalog id
        :param pulumi.Input[str] database_name: Database name
        :param pulumi.Input[str] table_name: Table name
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog id
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Table name
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['DatasetS3LocationArgs']]:
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['DatasetS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


@pulumi.input_type
class DatasetDatabaseInputDefinitionArgs:
    def __init__(__self__, *,
                 database_table_name: Optional[pulumi.Input[str]] = None,
                 glue_connection_name: Optional[pulumi.Input[str]] = None,
                 temp_directory: Optional[pulumi.Input['DatasetS3LocationArgs']] = None):
        """
        :param pulumi.Input[str] database_table_name: Database table name
        :param pulumi.Input[str] glue_connection_name: Glue connection name
        """
        if database_table_name is not None:
            pulumi.set(__self__, "database_table_name", database_table_name)
        if glue_connection_name is not None:
            pulumi.set(__self__, "glue_connection_name", glue_connection_name)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="databaseTableName")
    def database_table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database table name
        """
        return pulumi.get(self, "database_table_name")

    @database_table_name.setter
    def database_table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_table_name", value)

    @property
    @pulumi.getter(name="glueConnectionName")
    def glue_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Glue connection name
        """
        return pulumi.get(self, "glue_connection_name")

    @glue_connection_name.setter
    def glue_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glue_connection_name", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['DatasetS3LocationArgs']]:
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['DatasetS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


@pulumi.input_type
class DatasetDatetimeOptionsArgs:
    def __init__(__self__, *,
                 format: pulumi.Input[str],
                 locale_code: Optional[pulumi.Input[str]] = None,
                 timezone_offset: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] format: Date/time format of a date parameter
        :param pulumi.Input[str] locale_code: Locale code for a date parameter
        :param pulumi.Input[str] timezone_offset: Timezone offset
        """
        pulumi.set(__self__, "format", format)
        if locale_code is not None:
            pulumi.set(__self__, "locale_code", locale_code)
        if timezone_offset is not None:
            pulumi.set(__self__, "timezone_offset", timezone_offset)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[str]:
        """
        Date/time format of a date parameter
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="localeCode")
    def locale_code(self) -> Optional[pulumi.Input[str]]:
        """
        Locale code for a date parameter
        """
        return pulumi.get(self, "locale_code")

    @locale_code.setter
    def locale_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale_code", value)

    @property
    @pulumi.getter(name="timezoneOffset")
    def timezone_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Timezone offset
        """
        return pulumi.get(self, "timezone_offset")

    @timezone_offset.setter
    def timezone_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone_offset", value)


@pulumi.input_type
class DatasetExcelOptionsArgs:
    def __init__(__self__, *,
                 header_row: Optional[pulumi.Input[bool]] = None,
                 sheet_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 sheet_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if header_row is not None:
            pulumi.set(__self__, "header_row", header_row)
        if sheet_indexes is not None:
            pulumi.set(__self__, "sheet_indexes", sheet_indexes)
        if sheet_names is not None:
            pulumi.set(__self__, "sheet_names", sheet_names)

    @property
    @pulumi.getter(name="headerRow")
    def header_row(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "header_row")

    @header_row.setter
    def header_row(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "header_row", value)

    @property
    @pulumi.getter(name="sheetIndexes")
    def sheet_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        return pulumi.get(self, "sheet_indexes")

    @sheet_indexes.setter
    def sheet_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "sheet_indexes", value)

    @property
    @pulumi.getter(name="sheetNames")
    def sheet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "sheet_names")

    @sheet_names.setter
    def sheet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sheet_names", value)


@pulumi.input_type
class DatasetFilesLimitArgs:
    def __init__(__self__, *,
                 max_files: pulumi.Input[int],
                 order: Optional[pulumi.Input['DatasetFilesLimitOrder']] = None,
                 ordered_by: Optional[pulumi.Input['DatasetFilesLimitOrderedBy']] = None):
        """
        :param pulumi.Input[int] max_files: Maximum number of files
        :param pulumi.Input['DatasetFilesLimitOrder'] order: Order
        :param pulumi.Input['DatasetFilesLimitOrderedBy'] ordered_by: Ordered by
        """
        pulumi.set(__self__, "max_files", max_files)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if ordered_by is not None:
            pulumi.set(__self__, "ordered_by", ordered_by)

    @property
    @pulumi.getter(name="maxFiles")
    def max_files(self) -> pulumi.Input[int]:
        """
        Maximum number of files
        """
        return pulumi.get(self, "max_files")

    @max_files.setter
    def max_files(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_files", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input['DatasetFilesLimitOrder']]:
        """
        Order
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input['DatasetFilesLimitOrder']]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="orderedBy")
    def ordered_by(self) -> Optional[pulumi.Input['DatasetFilesLimitOrderedBy']]:
        """
        Ordered by
        """
        return pulumi.get(self, "ordered_by")

    @ordered_by.setter
    def ordered_by(self, value: Optional[pulumi.Input['DatasetFilesLimitOrderedBy']]):
        pulumi.set(self, "ordered_by", value)


@pulumi.input_type
class DatasetFilterExpressionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 values_map: pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgs']]]):
        """
        :param pulumi.Input[str] expression: Filtering expression for a parameter
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "values_map", values_map)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        Filtering expression for a parameter
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="valuesMap")
    def values_map(self) -> pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgs']]]:
        return pulumi.get(self, "values_map")

    @values_map.setter
    def values_map(self, value: pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgs']]]):
        pulumi.set(self, "values_map", value)


@pulumi.input_type
class DatasetFilterValueArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 value_reference: pulumi.Input[str]):
        """
        A key-value pair to associate expression variable names with their values
        :param pulumi.Input[str] value_reference: Variable name
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_reference", value_reference)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueReference")
    def value_reference(self) -> pulumi.Input[str]:
        """
        Variable name
        """
        return pulumi.get(self, "value_reference")

    @value_reference.setter
    def value_reference(self, value: pulumi.Input[str]):
        pulumi.set(self, "value_reference", value)


@pulumi.input_type
class DatasetFormatOptionsArgs:
    def __init__(__self__, *,
                 csv: Optional[pulumi.Input['DatasetCsvOptionsArgs']] = None,
                 excel: Optional[pulumi.Input['DatasetExcelOptionsArgs']] = None,
                 json: Optional[pulumi.Input['DatasetJsonOptionsArgs']] = None):
        """
        Format options for dataset
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if excel is not None:
            pulumi.set(__self__, "excel", excel)
        if json is not None:
            pulumi.set(__self__, "json", json)

    @property
    @pulumi.getter
    def csv(self) -> Optional[pulumi.Input['DatasetCsvOptionsArgs']]:
        return pulumi.get(self, "csv")

    @csv.setter
    def csv(self, value: Optional[pulumi.Input['DatasetCsvOptionsArgs']]):
        pulumi.set(self, "csv", value)

    @property
    @pulumi.getter
    def excel(self) -> Optional[pulumi.Input['DatasetExcelOptionsArgs']]:
        return pulumi.get(self, "excel")

    @excel.setter
    def excel(self, value: Optional[pulumi.Input['DatasetExcelOptionsArgs']]):
        pulumi.set(self, "excel", value)

    @property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input['DatasetJsonOptionsArgs']]:
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input['DatasetJsonOptionsArgs']]):
        pulumi.set(self, "json", value)


@pulumi.input_type
class DatasetInputArgs:
    def __init__(__self__, *,
                 data_catalog_input_definition: Optional[pulumi.Input['DatasetDataCatalogInputDefinitionArgs']] = None,
                 database_input_definition: Optional[pulumi.Input['DatasetDatabaseInputDefinitionArgs']] = None,
                 s3_input_definition: Optional[pulumi.Input['DatasetS3LocationArgs']] = None):
        """
        Input
        """
        if data_catalog_input_definition is not None:
            pulumi.set(__self__, "data_catalog_input_definition", data_catalog_input_definition)
        if database_input_definition is not None:
            pulumi.set(__self__, "database_input_definition", database_input_definition)
        if s3_input_definition is not None:
            pulumi.set(__self__, "s3_input_definition", s3_input_definition)

    @property
    @pulumi.getter(name="dataCatalogInputDefinition")
    def data_catalog_input_definition(self) -> Optional[pulumi.Input['DatasetDataCatalogInputDefinitionArgs']]:
        return pulumi.get(self, "data_catalog_input_definition")

    @data_catalog_input_definition.setter
    def data_catalog_input_definition(self, value: Optional[pulumi.Input['DatasetDataCatalogInputDefinitionArgs']]):
        pulumi.set(self, "data_catalog_input_definition", value)

    @property
    @pulumi.getter(name="databaseInputDefinition")
    def database_input_definition(self) -> Optional[pulumi.Input['DatasetDatabaseInputDefinitionArgs']]:
        return pulumi.get(self, "database_input_definition")

    @database_input_definition.setter
    def database_input_definition(self, value: Optional[pulumi.Input['DatasetDatabaseInputDefinitionArgs']]):
        pulumi.set(self, "database_input_definition", value)

    @property
    @pulumi.getter(name="s3InputDefinition")
    def s3_input_definition(self) -> Optional[pulumi.Input['DatasetS3LocationArgs']]:
        return pulumi.get(self, "s3_input_definition")

    @s3_input_definition.setter
    def s3_input_definition(self, value: Optional[pulumi.Input['DatasetS3LocationArgs']]):
        pulumi.set(self, "s3_input_definition", value)


@pulumi.input_type
class DatasetJsonOptionsArgs:
    def __init__(__self__, *,
                 multi_line: Optional[pulumi.Input[bool]] = None):
        """
        Json options
        """
        if multi_line is not None:
            pulumi.set(__self__, "multi_line", multi_line)

    @property
    @pulumi.getter(name="multiLine")
    def multi_line(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multi_line")

    @multi_line.setter
    def multi_line(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_line", value)


@pulumi.input_type
class DatasetParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input['DatasetParameterType'],
                 create_column: Optional[pulumi.Input[bool]] = None,
                 datetime_options: Optional[pulumi.Input['DatasetDatetimeOptionsArgs']] = None,
                 filter: Optional[pulumi.Input['DatasetFilterExpressionArgs']] = None):
        """
        :param pulumi.Input['DatasetParameterType'] type: Parameter type
        :param pulumi.Input[bool] create_column: Add the value of this parameter as a column in a dataset.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if create_column is not None:
            pulumi.set(__self__, "create_column", create_column)
        if datetime_options is not None:
            pulumi.set(__self__, "datetime_options", datetime_options)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['DatasetParameterType']:
        """
        Parameter type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['DatasetParameterType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="createColumn")
    def create_column(self) -> Optional[pulumi.Input[bool]]:
        """
        Add the value of this parameter as a column in a dataset.
        """
        return pulumi.get(self, "create_column")

    @create_column.setter
    def create_column(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_column", value)

    @property
    @pulumi.getter(name="datetimeOptions")
    def datetime_options(self) -> Optional[pulumi.Input['DatasetDatetimeOptionsArgs']]:
        return pulumi.get(self, "datetime_options")

    @datetime_options.setter
    def datetime_options(self, value: Optional[pulumi.Input['DatasetDatetimeOptionsArgs']]):
        pulumi.set(self, "datetime_options", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['DatasetFilterExpressionArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['DatasetFilterExpressionArgs']]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class DatasetPathOptionsArgs:
    def __init__(__self__, *,
                 files_limit: Optional[pulumi.Input['DatasetFilesLimitArgs']] = None,
                 last_modified_date_condition: Optional[pulumi.Input['DatasetFilterExpressionArgs']] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgs']]]] = None):
        """
        Path options for dataset
        """
        if files_limit is not None:
            pulumi.set(__self__, "files_limit", files_limit)
        if last_modified_date_condition is not None:
            pulumi.set(__self__, "last_modified_date_condition", last_modified_date_condition)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="filesLimit")
    def files_limit(self) -> Optional[pulumi.Input['DatasetFilesLimitArgs']]:
        return pulumi.get(self, "files_limit")

    @files_limit.setter
    def files_limit(self, value: Optional[pulumi.Input['DatasetFilesLimitArgs']]):
        pulumi.set(self, "files_limit", value)

    @property
    @pulumi.getter(name="lastModifiedDateCondition")
    def last_modified_date_condition(self) -> Optional[pulumi.Input['DatasetFilterExpressionArgs']]:
        return pulumi.get(self, "last_modified_date_condition")

    @last_modified_date_condition.setter
    def last_modified_date_condition(self, value: Optional[pulumi.Input['DatasetFilterExpressionArgs']]):
        pulumi.set(self, "last_modified_date_condition", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgs']]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DatasetPathParameterArgs:
    def __init__(__self__, *,
                 dataset_parameter: pulumi.Input['DatasetParameterArgs'],
                 path_parameter_name: pulumi.Input[str]):
        """
        A key-value pair to associate dataset parameter name with its definition.
        """
        pulumi.set(__self__, "dataset_parameter", dataset_parameter)
        pulumi.set(__self__, "path_parameter_name", path_parameter_name)

    @property
    @pulumi.getter(name="datasetParameter")
    def dataset_parameter(self) -> pulumi.Input['DatasetParameterArgs']:
        return pulumi.get(self, "dataset_parameter")

    @dataset_parameter.setter
    def dataset_parameter(self, value: pulumi.Input['DatasetParameterArgs']):
        pulumi.set(self, "dataset_parameter", value)

    @property
    @pulumi.getter(name="pathParameterName")
    def path_parameter_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "path_parameter_name")

    @path_parameter_name.setter
    def path_parameter_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "path_parameter_name", value)


@pulumi.input_type
class DatasetS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        Input location
        """
        pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class DatasetTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class JobColumnSelectorArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class JobColumnStatisticsConfigurationArgs:
    def __init__(__self__, *,
                 statistics: pulumi.Input['JobStatisticsConfigurationArgs'],
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]] = None):
        pulumi.set(__self__, "statistics", statistics)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def statistics(self) -> pulumi.Input['JobStatisticsConfigurationArgs']:
        return pulumi.get(self, "statistics")

    @statistics.setter
    def statistics(self, value: pulumi.Input['JobStatisticsConfigurationArgs']):
        pulumi.set(self, "statistics", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]:
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)


@pulumi.input_type
class JobCsvOutputOptionsArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[str]] = None):
        """
        Output Csv options
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)


@pulumi.input_type
class JobDataCatalogOutputArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database_options: Optional[pulumi.Input['JobDatabaseTableOutputOptionsArgs']] = None,
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 s3_options: Optional[pulumi.Input['JobS3TableOutputOptionsArgs']] = None):
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_options is not None:
            pulumi.set(__self__, "database_options", database_options)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if s3_options is not None:
            pulumi.set(__self__, "s3_options", s3_options)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseOptions")
    def database_options(self) -> Optional[pulumi.Input['JobDatabaseTableOutputOptionsArgs']]:
        return pulumi.get(self, "database_options")

    @database_options.setter
    def database_options(self, value: Optional[pulumi.Input['JobDatabaseTableOutputOptionsArgs']]):
        pulumi.set(self, "database_options", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter(name="s3Options")
    def s3_options(self) -> Optional[pulumi.Input['JobS3TableOutputOptionsArgs']]:
        return pulumi.get(self, "s3_options")

    @s3_options.setter
    def s3_options(self, value: Optional[pulumi.Input['JobS3TableOutputOptionsArgs']]):
        pulumi.set(self, "s3_options", value)


@pulumi.input_type
class JobDatabaseOutputArgs:
    def __init__(__self__, *,
                 database_options: pulumi.Input['JobDatabaseTableOutputOptionsArgs'],
                 glue_connection_name: pulumi.Input[str],
                 database_output_mode: Optional[pulumi.Input['JobDatabaseOutputDatabaseOutputMode']] = None):
        """
        :param pulumi.Input[str] glue_connection_name: Glue connection name
        :param pulumi.Input['JobDatabaseOutputDatabaseOutputMode'] database_output_mode: Database table name
        """
        pulumi.set(__self__, "database_options", database_options)
        pulumi.set(__self__, "glue_connection_name", glue_connection_name)
        if database_output_mode is not None:
            pulumi.set(__self__, "database_output_mode", database_output_mode)

    @property
    @pulumi.getter(name="databaseOptions")
    def database_options(self) -> pulumi.Input['JobDatabaseTableOutputOptionsArgs']:
        return pulumi.get(self, "database_options")

    @database_options.setter
    def database_options(self, value: pulumi.Input['JobDatabaseTableOutputOptionsArgs']):
        pulumi.set(self, "database_options", value)

    @property
    @pulumi.getter(name="glueConnectionName")
    def glue_connection_name(self) -> pulumi.Input[str]:
        """
        Glue connection name
        """
        return pulumi.get(self, "glue_connection_name")

    @glue_connection_name.setter
    def glue_connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "glue_connection_name", value)

    @property
    @pulumi.getter(name="databaseOutputMode")
    def database_output_mode(self) -> Optional[pulumi.Input['JobDatabaseOutputDatabaseOutputMode']]:
        """
        Database table name
        """
        return pulumi.get(self, "database_output_mode")

    @database_output_mode.setter
    def database_output_mode(self, value: Optional[pulumi.Input['JobDatabaseOutputDatabaseOutputMode']]):
        pulumi.set(self, "database_output_mode", value)


@pulumi.input_type
class JobDatabaseTableOutputOptionsArgs:
    def __init__(__self__, *,
                 table_name: pulumi.Input[str],
                 temp_directory: Optional[pulumi.Input['JobS3LocationArgs']] = None):
        pulumi.set(__self__, "table_name", table_name)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['JobS3LocationArgs']]:
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['JobS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


@pulumi.input_type
class JobOutputFormatOptionsArgs:
    def __init__(__self__, *,
                 csv: Optional[pulumi.Input['JobCsvOutputOptionsArgs']] = None):
        """
        Format options for job Output
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)

    @property
    @pulumi.getter
    def csv(self) -> Optional[pulumi.Input['JobCsvOutputOptionsArgs']]:
        return pulumi.get(self, "csv")

    @csv.setter
    def csv(self, value: Optional[pulumi.Input['JobCsvOutputOptionsArgs']]):
        pulumi.set(self, "csv", value)


@pulumi.input_type
class JobOutputLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        Output location
        """
        pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class JobOutputArgs:
    def __init__(__self__, *,
                 location: pulumi.Input['JobS3LocationArgs'],
                 compression_format: Optional[pulumi.Input['JobOutputCompressionFormat']] = None,
                 format: Optional[pulumi.Input['JobOutputFormat']] = None,
                 format_options: Optional[pulumi.Input['JobOutputFormatOptionsArgs']] = None,
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 partition_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        pulumi.set(__self__, "location", location)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_options is not None:
            pulumi.set(__self__, "format_options", format_options)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if partition_columns is not None:
            pulumi.set(__self__, "partition_columns", partition_columns)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input['JobS3LocationArgs']:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input['JobS3LocationArgs']):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional[pulumi.Input['JobOutputCompressionFormat']]:
        return pulumi.get(self, "compression_format")

    @compression_format.setter
    def compression_format(self, value: Optional[pulumi.Input['JobOutputCompressionFormat']]):
        pulumi.set(self, "compression_format", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['JobOutputFormat']]:
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['JobOutputFormat']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatOptions")
    def format_options(self) -> Optional[pulumi.Input['JobOutputFormatOptionsArgs']]:
        return pulumi.get(self, "format_options")

    @format_options.setter
    def format_options(self, value: Optional[pulumi.Input['JobOutputFormatOptionsArgs']]):
        pulumi.set(self, "format_options", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter(name="partitionColumns")
    def partition_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "partition_columns")

    @partition_columns.setter
    def partition_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "partition_columns", value)


@pulumi.input_type
class JobParameterMapArgs:
    def __init__(__self__):
        pass


@pulumi.input_type
class JobProfileConfigurationArgs:
    def __init__(__self__, *,
                 column_statistics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgs']]]] = None,
                 dataset_statistics_configuration: Optional[pulumi.Input['JobStatisticsConfigurationArgs']] = None,
                 profile_columns: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]] = None):
        if column_statistics_configurations is not None:
            pulumi.set(__self__, "column_statistics_configurations", column_statistics_configurations)
        if dataset_statistics_configuration is not None:
            pulumi.set(__self__, "dataset_statistics_configuration", dataset_statistics_configuration)
        if profile_columns is not None:
            pulumi.set(__self__, "profile_columns", profile_columns)

    @property
    @pulumi.getter(name="columnStatisticsConfigurations")
    def column_statistics_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgs']]]]:
        return pulumi.get(self, "column_statistics_configurations")

    @column_statistics_configurations.setter
    def column_statistics_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgs']]]]):
        pulumi.set(self, "column_statistics_configurations", value)

    @property
    @pulumi.getter(name="datasetStatisticsConfiguration")
    def dataset_statistics_configuration(self) -> Optional[pulumi.Input['JobStatisticsConfigurationArgs']]:
        return pulumi.get(self, "dataset_statistics_configuration")

    @dataset_statistics_configuration.setter
    def dataset_statistics_configuration(self, value: Optional[pulumi.Input['JobStatisticsConfigurationArgs']]):
        pulumi.set(self, "dataset_statistics_configuration", value)

    @property
    @pulumi.getter(name="profileColumns")
    def profile_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]:
        return pulumi.get(self, "profile_columns")

    @profile_columns.setter
    def profile_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]):
        pulumi.set(self, "profile_columns", value)


@pulumi.input_type
class JobRecipeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Recipe name
        :param pulumi.Input[str] version: Recipe version
        """
        pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Recipe name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Recipe version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class JobS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        S3 Output location
        """
        pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class JobS3TableOutputOptionsArgs:
    def __init__(__self__, *,
                 location: pulumi.Input['JobS3LocationArgs']):
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input['JobS3LocationArgs']:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input['JobS3LocationArgs']):
        pulumi.set(self, "location", value)


@pulumi.input_type
class JobSampleArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input['JobSampleMode']] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        Job Sample
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['JobSampleMode']]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['JobSampleMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class JobStatisticOverrideArgs:
    def __init__(__self__, *,
                 parameters: pulumi.Input['JobParameterMapArgs'],
                 statistic: pulumi.Input[str]):
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "statistic", statistic)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['JobParameterMapArgs']:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['JobParameterMapArgs']):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input[str]:
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input[str]):
        pulumi.set(self, "statistic", value)


@pulumi.input_type
class JobStatisticsConfigurationArgs:
    def __init__(__self__, *,
                 included_statistics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgs']]]] = None):
        if included_statistics is not None:
            pulumi.set(__self__, "included_statistics", included_statistics)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter(name="includedStatistics")
    def included_statistics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "included_statistics")

    @included_statistics.setter
    def included_statistics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "included_statistics", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgs']]]]:
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)


@pulumi.input_type
class JobTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class JobValidationConfigurationArgs:
    def __init__(__self__, *,
                 ruleset_arn: pulumi.Input[str],
                 validation_mode: Optional[pulumi.Input['JobValidationMode']] = None):
        """
        Configuration to attach Rulesets to the job
        :param pulumi.Input[str] ruleset_arn: Arn of the Ruleset
        """
        pulumi.set(__self__, "ruleset_arn", ruleset_arn)
        if validation_mode is not None:
            pulumi.set(__self__, "validation_mode", validation_mode)

    @property
    @pulumi.getter(name="rulesetArn")
    def ruleset_arn(self) -> pulumi.Input[str]:
        """
        Arn of the Ruleset
        """
        return pulumi.get(self, "ruleset_arn")

    @ruleset_arn.setter
    def ruleset_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "ruleset_arn", value)

    @property
    @pulumi.getter(name="validationMode")
    def validation_mode(self) -> Optional[pulumi.Input['JobValidationMode']]:
        return pulumi.get(self, "validation_mode")

    @validation_mode.setter
    def validation_mode(self, value: Optional[pulumi.Input['JobValidationMode']]):
        pulumi.set(self, "validation_mode", value)


@pulumi.input_type
class ProjectSampleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ProjectSampleType'],
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['ProjectSampleType'] type: Sample type
        :param pulumi.Input[int] size: Sample size
        """
        pulumi.set(__self__, "type", type)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ProjectSampleType']:
        """
        Sample type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ProjectSampleType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Sample size
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class ProjectTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RecipeActionArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Union['RecipeParametersArgs', 'RecipeParameterMapArgs']]] = None):
        """
        :param pulumi.Input[str] operation: Step action operation
        """
        pulumi.set(__self__, "operation", operation)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[str]:
        """
        Step action operation
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Union['RecipeParametersArgs', 'RecipeParameterMapArgs']]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Union['RecipeParametersArgs', 'RecipeParameterMapArgs']]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class RecipeConditionExpressionArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 target_column: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        Condition expressions applied to the step action
        :param pulumi.Input[str] condition: Input condition to be applied to the target column
        :param pulumi.Input[str] target_column: Name of the target column
        :param pulumi.Input[str] value: Value of the condition
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "target_column", target_column)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        Input condition to be applied to the target column
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="targetColumn")
    def target_column(self) -> pulumi.Input[str]:
        """
        Name of the target column
        """
        return pulumi.get(self, "target_column")

    @target_column.setter
    def target_column(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_column", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the condition
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RecipeDataCatalogInputDefinitionArgs:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 temp_directory: Optional[pulumi.Input['RecipeS3LocationArgs']] = None):
        """
        :param pulumi.Input[str] catalog_id: Catalog id
        :param pulumi.Input[str] database_name: Database name
        :param pulumi.Input[str] table_name: Table name
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog id
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Table name
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['RecipeS3LocationArgs']]:
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['RecipeS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


@pulumi.input_type
class RecipeParameterMapArgs:
    def __init__(__self__):
        pass


@pulumi.input_type
class RecipeParametersInputPropertiesArgs:
    def __init__(__self__, *,
                 data_catalog_input_definition: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']] = None,
                 s3_input_definition: Optional[pulumi.Input['RecipeS3LocationArgs']] = None):
        """
        Input
        """
        if data_catalog_input_definition is not None:
            pulumi.set(__self__, "data_catalog_input_definition", data_catalog_input_definition)
        if s3_input_definition is not None:
            pulumi.set(__self__, "s3_input_definition", s3_input_definition)

    @property
    @pulumi.getter(name="dataCatalogInputDefinition")
    def data_catalog_input_definition(self) -> Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]:
        return pulumi.get(self, "data_catalog_input_definition")

    @data_catalog_input_definition.setter
    def data_catalog_input_definition(self, value: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]):
        pulumi.set(self, "data_catalog_input_definition", value)

    @property
    @pulumi.getter(name="s3InputDefinition")
    def s3_input_definition(self) -> Optional[pulumi.Input['RecipeS3LocationArgs']]:
        return pulumi.get(self, "s3_input_definition")

    @s3_input_definition.setter
    def s3_input_definition(self, value: Optional[pulumi.Input['RecipeS3LocationArgs']]):
        pulumi.set(self, "s3_input_definition", value)


@pulumi.input_type
class RecipeParametersArgs:
    def __init__(__self__, *,
                 aggregate_function: Optional[pulumi.Input[str]] = None,
                 base: Optional[pulumi.Input[str]] = None,
                 case_statement: Optional[pulumi.Input[str]] = None,
                 category_map: Optional[pulumi.Input[str]] = None,
                 chars_to_remove: Optional[pulumi.Input[str]] = None,
                 collapse_consecutive_whitespace: Optional[pulumi.Input[str]] = None,
                 column_data_type: Optional[pulumi.Input[str]] = None,
                 column_range: Optional[pulumi.Input[str]] = None,
                 count: Optional[pulumi.Input[str]] = None,
                 custom_characters: Optional[pulumi.Input[str]] = None,
                 custom_stop_words: Optional[pulumi.Input[str]] = None,
                 custom_value: Optional[pulumi.Input[str]] = None,
                 datasets_columns: Optional[pulumi.Input[str]] = None,
                 date_add_value: Optional[pulumi.Input[str]] = None,
                 date_time_format: Optional[pulumi.Input[str]] = None,
                 date_time_parameters: Optional[pulumi.Input[str]] = None,
                 delete_other_rows: Optional[pulumi.Input[str]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 end_pattern: Optional[pulumi.Input[str]] = None,
                 end_position: Optional[pulumi.Input[str]] = None,
                 end_value: Optional[pulumi.Input[str]] = None,
                 expand_contractions: Optional[pulumi.Input[str]] = None,
                 exponent: Optional[pulumi.Input[str]] = None,
                 false_string: Optional[pulumi.Input[str]] = None,
                 group_by_agg_function_options: Optional[pulumi.Input[str]] = None,
                 group_by_columns: Optional[pulumi.Input[str]] = None,
                 hidden_columns: Optional[pulumi.Input[str]] = None,
                 ignore_case: Optional[pulumi.Input[str]] = None,
                 include_in_split: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input['RecipeParametersInputPropertiesArgs']] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 is_text: Optional[pulumi.Input[str]] = None,
                 join_keys: Optional[pulumi.Input[str]] = None,
                 join_type: Optional[pulumi.Input[str]] = None,
                 left_columns: Optional[pulumi.Input[str]] = None,
                 limit: Optional[pulumi.Input[str]] = None,
                 lower_bound: Optional[pulumi.Input[str]] = None,
                 map_type: Optional[pulumi.Input[str]] = None,
                 mode_type: Optional[pulumi.Input[str]] = None,
                 multi_line: Optional[pulumi.Input[bool]] = None,
                 num_rows: Optional[pulumi.Input[str]] = None,
                 num_rows_after: Optional[pulumi.Input[str]] = None,
                 num_rows_before: Optional[pulumi.Input[str]] = None,
                 order_by_column: Optional[pulumi.Input[str]] = None,
                 order_by_columns: Optional[pulumi.Input[str]] = None,
                 other: Optional[pulumi.Input[str]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 pattern_option1: Optional[pulumi.Input[str]] = None,
                 pattern_option2: Optional[pulumi.Input[str]] = None,
                 pattern_options: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[str]] = None,
                 remove_all_punctuation: Optional[pulumi.Input[str]] = None,
                 remove_all_quotes: Optional[pulumi.Input[str]] = None,
                 remove_all_whitespace: Optional[pulumi.Input[str]] = None,
                 remove_custom_characters: Optional[pulumi.Input[str]] = None,
                 remove_custom_value: Optional[pulumi.Input[str]] = None,
                 remove_leading_and_trailing_punctuation: Optional[pulumi.Input[str]] = None,
                 remove_leading_and_trailing_quotes: Optional[pulumi.Input[str]] = None,
                 remove_leading_and_trailing_whitespace: Optional[pulumi.Input[str]] = None,
                 remove_letters: Optional[pulumi.Input[str]] = None,
                 remove_numbers: Optional[pulumi.Input[str]] = None,
                 remove_source_column: Optional[pulumi.Input[str]] = None,
                 remove_special_characters: Optional[pulumi.Input[str]] = None,
                 right_columns: Optional[pulumi.Input[str]] = None,
                 sample_size: Optional[pulumi.Input[str]] = None,
                 sample_type: Optional[pulumi.Input[str]] = None,
                 second_input: Optional[pulumi.Input[str]] = None,
                 secondary_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeSecondaryInputArgs']]]] = None,
                 sheet_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 sheet_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_column: Optional[pulumi.Input[str]] = None,
                 source_column1: Optional[pulumi.Input[str]] = None,
                 source_column2: Optional[pulumi.Input[str]] = None,
                 source_columns: Optional[pulumi.Input[str]] = None,
                 start_column_index: Optional[pulumi.Input[str]] = None,
                 start_pattern: Optional[pulumi.Input[str]] = None,
                 start_position: Optional[pulumi.Input[str]] = None,
                 start_value: Optional[pulumi.Input[str]] = None,
                 stemming_mode: Optional[pulumi.Input[str]] = None,
                 step_count: Optional[pulumi.Input[str]] = None,
                 step_index: Optional[pulumi.Input[str]] = None,
                 stop_words_mode: Optional[pulumi.Input[str]] = None,
                 strategy: Optional[pulumi.Input[str]] = None,
                 target_column: Optional[pulumi.Input[str]] = None,
                 target_column_names: Optional[pulumi.Input[str]] = None,
                 target_date_format: Optional[pulumi.Input[str]] = None,
                 target_index: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 tokenizer_pattern: Optional[pulumi.Input[str]] = None,
                 true_string: Optional[pulumi.Input[str]] = None,
                 udf_lang: Optional[pulumi.Input[str]] = None,
                 units: Optional[pulumi.Input[str]] = None,
                 unpivot_column: Optional[pulumi.Input[str]] = None,
                 upper_bound: Optional[pulumi.Input[str]] = None,
                 use_new_data_frame: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value1: Optional[pulumi.Input[str]] = None,
                 value2: Optional[pulumi.Input[str]] = None,
                 value_column: Optional[pulumi.Input[str]] = None,
                 view_frame: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['RecipeParametersInputPropertiesArgs'] input: Input
        """
        if aggregate_function is not None:
            pulumi.set(__self__, "aggregate_function", aggregate_function)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if case_statement is not None:
            pulumi.set(__self__, "case_statement", case_statement)
        if category_map is not None:
            pulumi.set(__self__, "category_map", category_map)
        if chars_to_remove is not None:
            pulumi.set(__self__, "chars_to_remove", chars_to_remove)
        if collapse_consecutive_whitespace is not None:
            pulumi.set(__self__, "collapse_consecutive_whitespace", collapse_consecutive_whitespace)
        if column_data_type is not None:
            pulumi.set(__self__, "column_data_type", column_data_type)
        if column_range is not None:
            pulumi.set(__self__, "column_range", column_range)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if custom_characters is not None:
            pulumi.set(__self__, "custom_characters", custom_characters)
        if custom_stop_words is not None:
            pulumi.set(__self__, "custom_stop_words", custom_stop_words)
        if custom_value is not None:
            pulumi.set(__self__, "custom_value", custom_value)
        if datasets_columns is not None:
            pulumi.set(__self__, "datasets_columns", datasets_columns)
        if date_add_value is not None:
            pulumi.set(__self__, "date_add_value", date_add_value)
        if date_time_format is not None:
            pulumi.set(__self__, "date_time_format", date_time_format)
        if date_time_parameters is not None:
            pulumi.set(__self__, "date_time_parameters", date_time_parameters)
        if delete_other_rows is not None:
            pulumi.set(__self__, "delete_other_rows", delete_other_rows)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if end_pattern is not None:
            pulumi.set(__self__, "end_pattern", end_pattern)
        if end_position is not None:
            pulumi.set(__self__, "end_position", end_position)
        if end_value is not None:
            pulumi.set(__self__, "end_value", end_value)
        if expand_contractions is not None:
            pulumi.set(__self__, "expand_contractions", expand_contractions)
        if exponent is not None:
            pulumi.set(__self__, "exponent", exponent)
        if false_string is not None:
            pulumi.set(__self__, "false_string", false_string)
        if group_by_agg_function_options is not None:
            pulumi.set(__self__, "group_by_agg_function_options", group_by_agg_function_options)
        if group_by_columns is not None:
            pulumi.set(__self__, "group_by_columns", group_by_columns)
        if hidden_columns is not None:
            pulumi.set(__self__, "hidden_columns", hidden_columns)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if include_in_split is not None:
            pulumi.set(__self__, "include_in_split", include_in_split)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if is_text is not None:
            pulumi.set(__self__, "is_text", is_text)
        if join_keys is not None:
            pulumi.set(__self__, "join_keys", join_keys)
        if join_type is not None:
            pulumi.set(__self__, "join_type", join_type)
        if left_columns is not None:
            pulumi.set(__self__, "left_columns", left_columns)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if lower_bound is not None:
            pulumi.set(__self__, "lower_bound", lower_bound)
        if map_type is not None:
            pulumi.set(__self__, "map_type", map_type)
        if mode_type is not None:
            pulumi.set(__self__, "mode_type", mode_type)
        if multi_line is not None:
            pulumi.set(__self__, "multi_line", multi_line)
        if num_rows is not None:
            pulumi.set(__self__, "num_rows", num_rows)
        if num_rows_after is not None:
            pulumi.set(__self__, "num_rows_after", num_rows_after)
        if num_rows_before is not None:
            pulumi.set(__self__, "num_rows_before", num_rows_before)
        if order_by_column is not None:
            pulumi.set(__self__, "order_by_column", order_by_column)
        if order_by_columns is not None:
            pulumi.set(__self__, "order_by_columns", order_by_columns)
        if other is not None:
            pulumi.set(__self__, "other", other)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_option1 is not None:
            pulumi.set(__self__, "pattern_option1", pattern_option1)
        if pattern_option2 is not None:
            pulumi.set(__self__, "pattern_option2", pattern_option2)
        if pattern_options is not None:
            pulumi.set(__self__, "pattern_options", pattern_options)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if remove_all_punctuation is not None:
            pulumi.set(__self__, "remove_all_punctuation", remove_all_punctuation)
        if remove_all_quotes is not None:
            pulumi.set(__self__, "remove_all_quotes", remove_all_quotes)
        if remove_all_whitespace is not None:
            pulumi.set(__self__, "remove_all_whitespace", remove_all_whitespace)
        if remove_custom_characters is not None:
            pulumi.set(__self__, "remove_custom_characters", remove_custom_characters)
        if remove_custom_value is not None:
            pulumi.set(__self__, "remove_custom_value", remove_custom_value)
        if remove_leading_and_trailing_punctuation is not None:
            pulumi.set(__self__, "remove_leading_and_trailing_punctuation", remove_leading_and_trailing_punctuation)
        if remove_leading_and_trailing_quotes is not None:
            pulumi.set(__self__, "remove_leading_and_trailing_quotes", remove_leading_and_trailing_quotes)
        if remove_leading_and_trailing_whitespace is not None:
            pulumi.set(__self__, "remove_leading_and_trailing_whitespace", remove_leading_and_trailing_whitespace)
        if remove_letters is not None:
            pulumi.set(__self__, "remove_letters", remove_letters)
        if remove_numbers is not None:
            pulumi.set(__self__, "remove_numbers", remove_numbers)
        if remove_source_column is not None:
            pulumi.set(__self__, "remove_source_column", remove_source_column)
        if remove_special_characters is not None:
            pulumi.set(__self__, "remove_special_characters", remove_special_characters)
        if right_columns is not None:
            pulumi.set(__self__, "right_columns", right_columns)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if sample_type is not None:
            pulumi.set(__self__, "sample_type", sample_type)
        if second_input is not None:
            pulumi.set(__self__, "second_input", second_input)
        if secondary_inputs is not None:
            pulumi.set(__self__, "secondary_inputs", secondary_inputs)
        if sheet_indexes is not None:
            pulumi.set(__self__, "sheet_indexes", sheet_indexes)
        if sheet_names is not None:
            pulumi.set(__self__, "sheet_names", sheet_names)
        if source_column is not None:
            pulumi.set(__self__, "source_column", source_column)
        if source_column1 is not None:
            pulumi.set(__self__, "source_column1", source_column1)
        if source_column2 is not None:
            pulumi.set(__self__, "source_column2", source_column2)
        if source_columns is not None:
            pulumi.set(__self__, "source_columns", source_columns)
        if start_column_index is not None:
            pulumi.set(__self__, "start_column_index", start_column_index)
        if start_pattern is not None:
            pulumi.set(__self__, "start_pattern", start_pattern)
        if start_position is not None:
            pulumi.set(__self__, "start_position", start_position)
        if start_value is not None:
            pulumi.set(__self__, "start_value", start_value)
        if stemming_mode is not None:
            pulumi.set(__self__, "stemming_mode", stemming_mode)
        if step_count is not None:
            pulumi.set(__self__, "step_count", step_count)
        if step_index is not None:
            pulumi.set(__self__, "step_index", step_index)
        if stop_words_mode is not None:
            pulumi.set(__self__, "stop_words_mode", stop_words_mode)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if target_column is not None:
            pulumi.set(__self__, "target_column", target_column)
        if target_column_names is not None:
            pulumi.set(__self__, "target_column_names", target_column_names)
        if target_date_format is not None:
            pulumi.set(__self__, "target_date_format", target_date_format)
        if target_index is not None:
            pulumi.set(__self__, "target_index", target_index)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if tokenizer_pattern is not None:
            pulumi.set(__self__, "tokenizer_pattern", tokenizer_pattern)
        if true_string is not None:
            pulumi.set(__self__, "true_string", true_string)
        if udf_lang is not None:
            pulumi.set(__self__, "udf_lang", udf_lang)
        if units is not None:
            pulumi.set(__self__, "units", units)
        if unpivot_column is not None:
            pulumi.set(__self__, "unpivot_column", unpivot_column)
        if upper_bound is not None:
            pulumi.set(__self__, "upper_bound", upper_bound)
        if use_new_data_frame is not None:
            pulumi.set(__self__, "use_new_data_frame", use_new_data_frame)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value1 is not None:
            pulumi.set(__self__, "value1", value1)
        if value2 is not None:
            pulumi.set(__self__, "value2", value2)
        if value_column is not None:
            pulumi.set(__self__, "value_column", value_column)
        if view_frame is not None:
            pulumi.set(__self__, "view_frame", view_frame)

    @property
    @pulumi.getter(name="aggregateFunction")
    def aggregate_function(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "aggregate_function")

    @aggregate_function.setter
    def aggregate_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aggregate_function", value)

    @property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base", value)

    @property
    @pulumi.getter(name="caseStatement")
    def case_statement(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "case_statement")

    @case_statement.setter
    def case_statement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "case_statement", value)

    @property
    @pulumi.getter(name="categoryMap")
    def category_map(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "category_map")

    @category_map.setter
    def category_map(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category_map", value)

    @property
    @pulumi.getter(name="charsToRemove")
    def chars_to_remove(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "chars_to_remove")

    @chars_to_remove.setter
    def chars_to_remove(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chars_to_remove", value)

    @property
    @pulumi.getter(name="collapseConsecutiveWhitespace")
    def collapse_consecutive_whitespace(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "collapse_consecutive_whitespace")

    @collapse_consecutive_whitespace.setter
    def collapse_consecutive_whitespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collapse_consecutive_whitespace", value)

    @property
    @pulumi.getter(name="columnDataType")
    def column_data_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "column_data_type")

    @column_data_type.setter
    def column_data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_data_type", value)

    @property
    @pulumi.getter(name="columnRange")
    def column_range(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "column_range")

    @column_range.setter
    def column_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_range", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="customCharacters")
    def custom_characters(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "custom_characters")

    @custom_characters.setter
    def custom_characters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_characters", value)

    @property
    @pulumi.getter(name="customStopWords")
    def custom_stop_words(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "custom_stop_words")

    @custom_stop_words.setter
    def custom_stop_words(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_stop_words", value)

    @property
    @pulumi.getter(name="customValue")
    def custom_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "custom_value")

    @custom_value.setter
    def custom_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_value", value)

    @property
    @pulumi.getter(name="datasetsColumns")
    def datasets_columns(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "datasets_columns")

    @datasets_columns.setter
    def datasets_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datasets_columns", value)

    @property
    @pulumi.getter(name="dateAddValue")
    def date_add_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "date_add_value")

    @date_add_value.setter
    def date_add_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_add_value", value)

    @property
    @pulumi.getter(name="dateTimeFormat")
    def date_time_format(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "date_time_format")

    @date_time_format.setter
    def date_time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_time_format", value)

    @property
    @pulumi.getter(name="dateTimeParameters")
    def date_time_parameters(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "date_time_parameters")

    @date_time_parameters.setter
    def date_time_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_time_parameters", value)

    @property
    @pulumi.getter(name="deleteOtherRows")
    def delete_other_rows(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "delete_other_rows")

    @delete_other_rows.setter
    def delete_other_rows(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_other_rows", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="endPattern")
    def end_pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "end_pattern")

    @end_pattern.setter
    def end_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_pattern", value)

    @property
    @pulumi.getter(name="endPosition")
    def end_position(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "end_position")

    @end_position.setter
    def end_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_position", value)

    @property
    @pulumi.getter(name="endValue")
    def end_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "end_value")

    @end_value.setter
    def end_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_value", value)

    @property
    @pulumi.getter(name="expandContractions")
    def expand_contractions(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "expand_contractions")

    @expand_contractions.setter
    def expand_contractions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expand_contractions", value)

    @property
    @pulumi.getter
    def exponent(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "exponent")

    @exponent.setter
    def exponent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exponent", value)

    @property
    @pulumi.getter(name="falseString")
    def false_string(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "false_string")

    @false_string.setter
    def false_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "false_string", value)

    @property
    @pulumi.getter(name="groupByAggFunctionOptions")
    def group_by_agg_function_options(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "group_by_agg_function_options")

    @group_by_agg_function_options.setter
    def group_by_agg_function_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_by_agg_function_options", value)

    @property
    @pulumi.getter(name="groupByColumns")
    def group_by_columns(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "group_by_columns")

    @group_by_columns.setter
    def group_by_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_by_columns", value)

    @property
    @pulumi.getter(name="hiddenColumns")
    def hidden_columns(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hidden_columns")

    @hidden_columns.setter
    def hidden_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hidden_columns", value)

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ignore_case")

    @ignore_case.setter
    def ignore_case(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ignore_case", value)

    @property
    @pulumi.getter(name="includeInSplit")
    def include_in_split(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "include_in_split")

    @include_in_split.setter
    def include_in_split(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "include_in_split", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['RecipeParametersInputPropertiesArgs']]:
        """
        Input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['RecipeParametersInputPropertiesArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="isText")
    def is_text(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "is_text")

    @is_text.setter
    def is_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "is_text", value)

    @property
    @pulumi.getter(name="joinKeys")
    def join_keys(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "join_keys")

    @join_keys.setter
    def join_keys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "join_keys", value)

    @property
    @pulumi.getter(name="joinType")
    def join_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "join_type")

    @join_type.setter
    def join_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "join_type", value)

    @property
    @pulumi.getter(name="leftColumns")
    def left_columns(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "left_columns")

    @left_columns.setter
    def left_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "left_columns", value)

    @property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "lower_bound")

    @lower_bound.setter
    def lower_bound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lower_bound", value)

    @property
    @pulumi.getter(name="mapType")
    def map_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "map_type")

    @map_type.setter
    def map_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "map_type", value)

    @property
    @pulumi.getter(name="modeType")
    def mode_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mode_type")

    @mode_type.setter
    def mode_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode_type", value)

    @property
    @pulumi.getter(name="multiLine")
    def multi_line(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multi_line")

    @multi_line.setter
    def multi_line(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_line", value)

    @property
    @pulumi.getter(name="numRows")
    def num_rows(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "num_rows")

    @num_rows.setter
    def num_rows(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "num_rows", value)

    @property
    @pulumi.getter(name="numRowsAfter")
    def num_rows_after(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "num_rows_after")

    @num_rows_after.setter
    def num_rows_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "num_rows_after", value)

    @property
    @pulumi.getter(name="numRowsBefore")
    def num_rows_before(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "num_rows_before")

    @num_rows_before.setter
    def num_rows_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "num_rows_before", value)

    @property
    @pulumi.getter(name="orderByColumn")
    def order_by_column(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "order_by_column")

    @order_by_column.setter
    def order_by_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_by_column", value)

    @property
    @pulumi.getter(name="orderByColumns")
    def order_by_columns(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "order_by_columns")

    @order_by_columns.setter
    def order_by_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_by_columns", value)

    @property
    @pulumi.getter
    def other(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "other")

    @other.setter
    def other(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "other", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="patternOption1")
    def pattern_option1(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pattern_option1")

    @pattern_option1.setter
    def pattern_option1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern_option1", value)

    @property
    @pulumi.getter(name="patternOption2")
    def pattern_option2(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pattern_option2")

    @pattern_option2.setter
    def pattern_option2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern_option2", value)

    @property
    @pulumi.getter(name="patternOptions")
    def pattern_options(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pattern_options")

    @pattern_options.setter
    def pattern_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern_options", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="removeAllPunctuation")
    def remove_all_punctuation(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_all_punctuation")

    @remove_all_punctuation.setter
    def remove_all_punctuation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_all_punctuation", value)

    @property
    @pulumi.getter(name="removeAllQuotes")
    def remove_all_quotes(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_all_quotes")

    @remove_all_quotes.setter
    def remove_all_quotes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_all_quotes", value)

    @property
    @pulumi.getter(name="removeAllWhitespace")
    def remove_all_whitespace(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_all_whitespace")

    @remove_all_whitespace.setter
    def remove_all_whitespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_all_whitespace", value)

    @property
    @pulumi.getter(name="removeCustomCharacters")
    def remove_custom_characters(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_custom_characters")

    @remove_custom_characters.setter
    def remove_custom_characters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_custom_characters", value)

    @property
    @pulumi.getter(name="removeCustomValue")
    def remove_custom_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_custom_value")

    @remove_custom_value.setter
    def remove_custom_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_custom_value", value)

    @property
    @pulumi.getter(name="removeLeadingAndTrailingPunctuation")
    def remove_leading_and_trailing_punctuation(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_leading_and_trailing_punctuation")

    @remove_leading_and_trailing_punctuation.setter
    def remove_leading_and_trailing_punctuation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_leading_and_trailing_punctuation", value)

    @property
    @pulumi.getter(name="removeLeadingAndTrailingQuotes")
    def remove_leading_and_trailing_quotes(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_leading_and_trailing_quotes")

    @remove_leading_and_trailing_quotes.setter
    def remove_leading_and_trailing_quotes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_leading_and_trailing_quotes", value)

    @property
    @pulumi.getter(name="removeLeadingAndTrailingWhitespace")
    def remove_leading_and_trailing_whitespace(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_leading_and_trailing_whitespace")

    @remove_leading_and_trailing_whitespace.setter
    def remove_leading_and_trailing_whitespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_leading_and_trailing_whitespace", value)

    @property
    @pulumi.getter(name="removeLetters")
    def remove_letters(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_letters")

    @remove_letters.setter
    def remove_letters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_letters", value)

    @property
    @pulumi.getter(name="removeNumbers")
    def remove_numbers(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_numbers")

    @remove_numbers.setter
    def remove_numbers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_numbers", value)

    @property
    @pulumi.getter(name="removeSourceColumn")
    def remove_source_column(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_source_column")

    @remove_source_column.setter
    def remove_source_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_source_column", value)

    @property
    @pulumi.getter(name="removeSpecialCharacters")
    def remove_special_characters(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "remove_special_characters")

    @remove_special_characters.setter
    def remove_special_characters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remove_special_characters", value)

    @property
    @pulumi.getter(name="rightColumns")
    def right_columns(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "right_columns")

    @right_columns.setter
    def right_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "right_columns", value)

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sample_size")

    @sample_size.setter
    def sample_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_size", value)

    @property
    @pulumi.getter(name="sampleType")
    def sample_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sample_type")

    @sample_type.setter
    def sample_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_type", value)

    @property
    @pulumi.getter(name="secondInput")
    def second_input(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "second_input")

    @second_input.setter
    def second_input(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "second_input", value)

    @property
    @pulumi.getter(name="secondaryInputs")
    def secondary_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipeSecondaryInputArgs']]]]:
        return pulumi.get(self, "secondary_inputs")

    @secondary_inputs.setter
    def secondary_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeSecondaryInputArgs']]]]):
        pulumi.set(self, "secondary_inputs", value)

    @property
    @pulumi.getter(name="sheetIndexes")
    def sheet_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        return pulumi.get(self, "sheet_indexes")

    @sheet_indexes.setter
    def sheet_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "sheet_indexes", value)

    @property
    @pulumi.getter(name="sheetNames")
    def sheet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "sheet_names")

    @sheet_names.setter
    def sheet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sheet_names", value)

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_column")

    @source_column.setter
    def source_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_column", value)

    @property
    @pulumi.getter(name="sourceColumn1")
    def source_column1(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_column1")

    @source_column1.setter
    def source_column1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_column1", value)

    @property
    @pulumi.getter(name="sourceColumn2")
    def source_column2(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_column2")

    @source_column2.setter
    def source_column2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_column2", value)

    @property
    @pulumi.getter(name="sourceColumns")
    def source_columns(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_columns")

    @source_columns.setter
    def source_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_columns", value)

    @property
    @pulumi.getter(name="startColumnIndex")
    def start_column_index(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "start_column_index")

    @start_column_index.setter
    def start_column_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_column_index", value)

    @property
    @pulumi.getter(name="startPattern")
    def start_pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "start_pattern")

    @start_pattern.setter
    def start_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_pattern", value)

    @property
    @pulumi.getter(name="startPosition")
    def start_position(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "start_position")

    @start_position.setter
    def start_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_position", value)

    @property
    @pulumi.getter(name="startValue")
    def start_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "start_value")

    @start_value.setter
    def start_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_value", value)

    @property
    @pulumi.getter(name="stemmingMode")
    def stemming_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stemming_mode")

    @stemming_mode.setter
    def stemming_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stemming_mode", value)

    @property
    @pulumi.getter(name="stepCount")
    def step_count(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "step_count")

    @step_count.setter
    def step_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_count", value)

    @property
    @pulumi.getter(name="stepIndex")
    def step_index(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "step_index")

    @step_index.setter
    def step_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_index", value)

    @property
    @pulumi.getter(name="stopWordsMode")
    def stop_words_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stop_words_mode")

    @stop_words_mode.setter
    def stop_words_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stop_words_mode", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter(name="targetColumn")
    def target_column(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target_column")

    @target_column.setter
    def target_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column", value)

    @property
    @pulumi.getter(name="targetColumnNames")
    def target_column_names(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target_column_names")

    @target_column_names.setter
    def target_column_names(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_names", value)

    @property
    @pulumi.getter(name="targetDateFormat")
    def target_date_format(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target_date_format")

    @target_date_format.setter
    def target_date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_date_format", value)

    @property
    @pulumi.getter(name="targetIndex")
    def target_index(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target_index")

    @target_index.setter
    def target_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_index", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="tokenizerPattern")
    def tokenizer_pattern(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tokenizer_pattern")

    @tokenizer_pattern.setter
    def tokenizer_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tokenizer_pattern", value)

    @property
    @pulumi.getter(name="trueString")
    def true_string(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "true_string")

    @true_string.setter
    def true_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "true_string", value)

    @property
    @pulumi.getter(name="udfLang")
    def udf_lang(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "udf_lang")

    @udf_lang.setter
    def udf_lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "udf_lang", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "units", value)

    @property
    @pulumi.getter(name="unpivotColumn")
    def unpivot_column(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "unpivot_column")

    @unpivot_column.setter
    def unpivot_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unpivot_column", value)

    @property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "upper_bound")

    @upper_bound.setter
    def upper_bound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upper_bound", value)

    @property
    @pulumi.getter(name="useNewDataFrame")
    def use_new_data_frame(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "use_new_data_frame")

    @use_new_data_frame.setter
    def use_new_data_frame(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_new_data_frame", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def value1(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value1")

    @value1.setter
    def value1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value1", value)

    @property
    @pulumi.getter
    def value2(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value2")

    @value2.setter
    def value2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value2", value)

    @property
    @pulumi.getter(name="valueColumn")
    def value_column(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value_column")

    @value_column.setter
    def value_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_column", value)

    @property
    @pulumi.getter(name="viewFrame")
    def view_frame(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "view_frame")

    @view_frame.setter
    def view_frame(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "view_frame", value)


@pulumi.input_type
class RecipeS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        Input location
        """
        pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class RecipeSecondaryInputArgs:
    def __init__(__self__, *,
                 data_catalog_input_definition: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']] = None,
                 s3_input_definition: Optional[pulumi.Input['RecipeS3LocationArgs']] = None):
        """
        Secondary input
        """
        if data_catalog_input_definition is not None:
            pulumi.set(__self__, "data_catalog_input_definition", data_catalog_input_definition)
        if s3_input_definition is not None:
            pulumi.set(__self__, "s3_input_definition", s3_input_definition)

    @property
    @pulumi.getter(name="dataCatalogInputDefinition")
    def data_catalog_input_definition(self) -> Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]:
        return pulumi.get(self, "data_catalog_input_definition")

    @data_catalog_input_definition.setter
    def data_catalog_input_definition(self, value: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]):
        pulumi.set(self, "data_catalog_input_definition", value)

    @property
    @pulumi.getter(name="s3InputDefinition")
    def s3_input_definition(self) -> Optional[pulumi.Input['RecipeS3LocationArgs']]:
        return pulumi.get(self, "s3_input_definition")

    @s3_input_definition.setter
    def s3_input_definition(self, value: Optional[pulumi.Input['RecipeS3LocationArgs']]):
        pulumi.set(self, "s3_input_definition", value)


@pulumi.input_type
class RecipeStepArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['RecipeActionArgs'],
                 condition_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]] condition_expressions: Condition expressions applied to the step action
        """
        pulumi.set(__self__, "action", action)
        if condition_expressions is not None:
            pulumi.set(__self__, "condition_expressions", condition_expressions)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['RecipeActionArgs']:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['RecipeActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="conditionExpressions")
    def condition_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]]]:
        """
        Condition expressions applied to the step action
        """
        return pulumi.get(self, "condition_expressions")

    @condition_expressions.setter
    def condition_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]]]):
        pulumi.set(self, "condition_expressions", value)


@pulumi.input_type
class RecipeTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScheduleTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


