"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TryTask = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
class TryTask extends sfn.Parallel {
    constructor(scope, id, props) {
        const parallelProps = {
            comment: props.comment,
            inputPath: props.inputPath,
            outputPath: "$[0]",
            resultPath: props.resultPath
        };
        super(scope, id, parallelProps);
        let process = props.tryProcess;
        if (props.catchProcess) {
            process = new sfn.Parallel(this, this.createStateName('TryCatch'), {
                outputPath: "$[0]" // unwrap result from the first (and only) branch
            })
                .branch(process)
                .addCatch(props.catchProcess, props.catchProps);
        }
        if (props.finallyProcess) {
            process = new sfn.Parallel(this, this.createStateName('TryFinally'), {
                outputPath: "$[0]" // unwrap result from the first (and only) branch
            })
                .branch(process)
                .addCatch(props.finallyProcess, {
                resultPath: props.catchErrorPath
            })
                .next(props.finallyProcess);
        }
        this.branch(process);
    }
    createStateName(name) {
        return `${name}_${this.node.uniqueId}`;
    }
}
exports.TryTask = TryTask;
//# sourceMappingURL=data:application/json;base64,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