/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.spi;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public interface OracleConfigurationProvider {
    public String getType();

    public Properties getConnectionProperties(String var1) throws SQLException;

    public static OracleConfigurationProvider find(String providerType) {
        for (OracleConfigurationProvider provider : ServiceLoader.load(OracleConfigurationProvider.class)) {
            if (!provider.getType().equals(providerType)) continue;
            return provider;
        }
        throw new IllegalStateException("Cannot find the provider type: " + providerType);
    }

    public static Map<String, String> mapOptions(String urlOptions) {
        if (urlOptions != null && !urlOptions.isEmpty()) {
            return Arrays.stream(urlOptions.split("&")).map(kv -> kv.split("=")).collect(Collectors.toMap(kvArray -> kvArray[0], kvArray -> kvArray[1]));
        }
        return Collections.emptyMap();
    }
}

