/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Map;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsResultSetMetaData;
import oracle.pgql.lang.PgqlException;

public class PgqlJdbcRdbmsResultSet
implements ResultSet {
    private PgqlResultSet pgqlResultSet;
    private PgqlJdbcRdbmsResultSetMetaData meta;
    private boolean wasNullFlag = false;

    public PgqlJdbcRdbmsResultSet(PgqlResultSet pgqlResultSet) throws SQLException {
        this.pgqlResultSet = pgqlResultSet;
        try {
            if (this.pgqlResultSet != null) {
                this.meta = new PgqlJdbcRdbmsResultSetMetaData(this.pgqlResultSet);
            }
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is already closed");
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        try {
            return this.pgqlResultSet.next();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.pgqlResultSet != null) {
                this.pgqlResultSet.close();
            }
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
        finally {
            this.pgqlResultSet = null;
            this.meta = null;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)this.getObject(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        try {
            Boolean booleanValue = this.pgqlResultSet.getBoolean(columnIndex);
            this.wasNullFlag = booleanValue == null;
            return this.wasNullFlag ? false : booleanValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        try {
            Integer intValue = this.pgqlResultSet.getInteger(columnIndex);
            this.wasNullFlag = intValue == null;
            return this.wasNullFlag ? 0 : intValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        try {
            Long longValue = this.pgqlResultSet.getLong(columnIndex);
            this.wasNullFlag = longValue == null;
            return this.wasNullFlag ? 0L : longValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        try {
            Float floatValue = this.pgqlResultSet.getFloat(columnIndex);
            this.wasNullFlag = floatValue == null;
            return this.wasNullFlag ? 0.0f : floatValue.floatValue();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        try {
            Double doubleValue = this.pgqlResultSet.getDouble(columnIndex);
            this.wasNullFlag = doubleValue == null;
            return this.wasNullFlag ? 0.0 : doubleValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        try {
            LocalDateTime localDateTimeValue = this.pgqlResultSet.getTimestamp(columnIndex);
            this.wasNullFlag = localDateTimeValue == null;
            return this.wasNullFlag ? null : Timestamp.valueOf(localDateTimeValue);
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        try {
            Object returnObject = this.pgqlResultSet.getObject(columnIndex);
            this.wasNullFlag = returnObject == null;
            return returnObject;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            String stringValue = this.pgqlResultSet.getString(columnLabel);
            this.wasNullFlag = stringValue == null;
            return stringValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            Boolean booleanValue = this.pgqlResultSet.getBoolean(columnLabel);
            this.wasNullFlag = booleanValue == null;
            return this.wasNullFlag ? false : booleanValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            Integer intValue = this.pgqlResultSet.getInteger(columnLabel);
            this.wasNullFlag = intValue == null;
            return this.wasNullFlag ? 0 : intValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            Long longValue = this.pgqlResultSet.getLong(columnLabel);
            this.wasNullFlag = longValue == null;
            return this.wasNullFlag ? 0L : longValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            Float floatValue = this.pgqlResultSet.getFloat(columnLabel);
            this.wasNullFlag = floatValue == null;
            return this.wasNullFlag ? 0.0f : floatValue.floatValue();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            Double doubleValue = this.pgqlResultSet.getDouble(columnLabel);
            this.wasNullFlag = doubleValue == null;
            return this.wasNullFlag ? 0.0 : doubleValue;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            LocalDateTime localDateTimeValue = this.pgqlResultSet.getTimestamp(columnLabel);
            this.wasNullFlag = localDateTimeValue == null;
            return this.wasNullFlag ? null : Timestamp.valueOf(localDateTimeValue);
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            Object returnObject = this.pgqlResultSet.getObject(columnLabel);
            this.wasNullFlag = returnObject == null;
            return returnObject;
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.meta;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        try {
            this.pgqlResultSet.beforeFirst();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        try {
            this.pgqlResultSet.afterLast();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        try {
            return this.pgqlResultSet.first();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        try {
            return this.pgqlResultSet.last();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        try {
            return this.pgqlResultSet.absolute((long)row);
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        try {
            return this.pgqlResultSet.relative((long)rows);
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        try {
            return this.pgqlResultSet.previous();
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.pgqlResultSet == null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        String columnName = this.meta.getColumnName(columnIndex);
        return this.fetchObject(columnName, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkClosed();
        return this.fetchObject(columnLabel, type);
    }

    private <T> T fetchObject(String columnName, Class<T> type) throws SQLException {
        this.checkClosed();
        try {
            switch (type.getName()) {
                case "java.time.LocalDate": {
                    LocalDate localDateValue = this.pgqlResultSet.getDate(columnName);
                    this.wasNullFlag = localDateValue == null;
                    return (T)(this.wasNullFlag ? null : localDateValue);
                }
                case "java.time.LocalTime": {
                    LocalTime localTimeValue = this.pgqlResultSet.getTime(columnName);
                    this.wasNullFlag = localTimeValue == null;
                    return (T)(this.wasNullFlag ? null : localTimeValue);
                }
                case "java.time.LocalDateTime": {
                    LocalDateTime localDateTimeValue = this.pgqlResultSet.getTimestamp(columnName);
                    this.wasNullFlag = localDateTimeValue == null;
                    return (T)(this.wasNullFlag ? null : localDateTimeValue);
                }
                case "java.time.OffsetTime": {
                    OffsetTime offsetTimeValue = this.pgqlResultSet.getTimeWithTimezone(columnName);
                    this.wasNullFlag = offsetTimeValue == null;
                    return (T)(this.wasNullFlag ? null : offsetTimeValue);
                }
                case "java.time.OffsetDateTime": {
                    OffsetDateTime offsetDateTimeValue = this.pgqlResultSet.getTimestampWithTimezone(columnName);
                    this.wasNullFlag = offsetDateTimeValue == null;
                    return (T)(this.wasNullFlag ? null : offsetDateTimeValue);
                }
            }
            Object obj = this.getObject(columnName);
            this.wasNullFlag = obj == null;
            return (T)(this.wasNullFlag ? null : obj);
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("byte getByte(int columnIndex) not yet supported.");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("short getShort(int columnIndex) not yet supported.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException("BigDecimal getBigDecimal(int columnIndex, int scale) not yet supported");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Date getDate(int columnIndex) not yet supported");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Time getTime(int columnIndex) not yet supported");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("byte[] getBytes(int columnIndex) not yet supported");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("InputStream getAsciiStream(int columnIndex) not yet supported");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("InputStream getUnicodeStream(int columnIndex) not yet supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("InputStream getBinaryStream(int columnIndex) not yet supported");
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("byte getByte(String columnLabel) not yet supported");
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("short getShort(String columnLabel) not yet supported");
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Date getDate(String columnLabel)");
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Time getTime(String columnLabel)");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new UnsupportedOperationException("BigDecimal getBigDecimal(String columnLabel, int scale) not yet supported");
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("byte[] getBytes(String columnLabel) not yet supported");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("InputStream getAsciiStream(String columnLabel) not yet supported");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("InputStream getUnicodeStream(String columnLabel) not yet supported");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("InputStream getBinaryStream(String columnLabel) not yet supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("SQLWarning getWarnings() not yet supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("void clearWarnings() not yet supported");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("String getCursorName() not yet supported");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("int findColumn(String columnLabel) not yet supported");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Reader getCharacterStream(int columnIndex) not yet supported");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Reader getCharacterStream(String columnLabel) not yet supported");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("BigDecimal getBigDecimal(int columnIndex) not yet supported");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("BigDecimal getBigDecimal(String columnLabel) not yet supported");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException("boolean isBeforeFirst() not yet supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException("boolean isAfterLast() not yet supported");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException("boolean isFirst() not yet supported");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException("boolean isLast() not yet supported");
    }

    @Override
    public int getRow() throws SQLException {
        throw new UnsupportedOperationException("int getRow() not yet supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("void setFetchDirection(int direction) not yet supported");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("void setFetchSize(int rows) not yet supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("int getFetchSize() not yet supported");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException("int getConcurrency() not yet supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException("boolean rowUpdated() not yet supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException("boolean rowInserted() not yet supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException("boolean rowDeleted() not yet supported");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("void updateNull(int columnIndex) not yet supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException("void updateBoolean(int columnIndex, boolean x) not yet supported");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("void updateByte(int columnIndex, byte x) not yet supported");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException("void updateShort(int columnIndex, short x) not yet supported");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException("void updateInt(int columnIndex, int x) not yet supported");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException("void updateLong(int columnIndex, long x) not yet supported");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException("void updateFloat(int columnIndex, float x) not yet supported");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException("void updateDouble(int columnIndex, double x) not yet supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("void updateBigDecimal(int columnIndex, BigDecimal x) not yet supported");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException("void updateString(int columnIndex, String x) not yet supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("void updateBytes(int columnIndex, byte[] x) not yet supported");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException("void updateDate(int columnIndex, Date x) not yet supported");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException("void updateTime(int columnIndex, Time x) not yet supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("void updateTimestamp(int columnIndex, Timestamp x) not yet supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("void updateAsciiStream(int columnIndex, InputStream x, int length) not yet supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("void updateBinaryStream(int columnIndex, InputStream x, int length) not yet supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("void updateCharacterStream(int columnIndex, Reader x, int length) not yet supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("void updateObject(int columnIndex, Object x, int scaleOrLength) not yet supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException("void updateObject(int columnIndex, Object x) not yet supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("void updateNull(String columnLabel) not yet supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new UnsupportedOperationException("void updateBoolean(String columnLabel, boolean x) not yet supported");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new UnsupportedOperationException("void updateByte(String columnLabel, byte x) not yet supported");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new UnsupportedOperationException("void updateShort(String columnLabel, short x) not yet supported");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new UnsupportedOperationException("void updateInt(String columnLabel, int x) not yet supported");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new UnsupportedOperationException("void updateLong(String columnLabel, long x) not yet supported");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new UnsupportedOperationException("void updateFloat(String columnLabel, float x) not yet supported");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new UnsupportedOperationException("void updateDouble(String columnLabel, double x) not yet supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("void updateBigDecimal(String columnLabel, BigDecimal x) not yet supported");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new UnsupportedOperationException("void updateString(String columnLabel, String x) not yet supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("void updateBytes(String columnLabel, byte[] x) not yet supported");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new UnsupportedOperationException("void updateDate(String columnLabel, Date x) not yet supported");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new UnsupportedOperationException("void updateTime(String columnLabel, Time x) not yet supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("void updateTimestamp(String columnLabel, Timestamp x) not yet supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("void updateAsciiStream(String columnLabel, InputStream x, int length) not yet supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("void updateBinaryStream(String columnLabel, InputStream x, int length) not yet supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("void updateCharacterStream(String columnLabel, Reader reader, int length) not yet supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("void updateObject(String columnLabel, Object x, int scaleOrLength) not yet supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new UnsupportedOperationException("void updateObject(String columnLabel, Object x) not yet supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("void insertRow() not yet supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("void updateRow() not yet supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("void deleteRow() not yet supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("void refreshRow() not yet supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("void cancelRowUpdates() not yet supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("void moveToInsertRow() not yet supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("void moveToCurrentRow() not yet supported");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("Statement getStatement() not yet supported");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Object getObject(int columnIndex, Map<String, Class<?>> map) not yet supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Ref getRef(int columnIndex) not yet supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Blob getBlob(int columnIndex) not yet supported");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Clob getClob(int columnIndex) not yet supported");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Array getArray(int columnIndex) not yet supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Object getObject(String columnLabel, Map<String, Class<?>> map) not yet supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Ref getRef(String columnLabel) not yet supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Blob getBlob(String columnLabel) not yet supported");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Clob getClob(String columnLabel) not yet supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Array getArray(String columnLabel) not yet supported");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Date getDate(int columnIndex, Calendar cal) not yet supported");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Date getDate(String columnLabel, Calendar cal) not yet supported");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Time getTime(int columnIndex, Calendar cal) not yet supported");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Time getTime(String columnLabel, Calendar cal) not yet supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Timestamp getTimestamp(int columnIndex, Calendar cal) not yet supported");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Timestamp getTimestamp(String columnLabel, Calendar cal) not yet supported");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("URL getURL(int columnIndex) not yet supported");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("URL getURL(String columnLabel) not yet supported");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("void updateRef(int columnIndex, Ref x) not yet supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new UnsupportedOperationException("void updateRef(String columnLabel, Ref x) not yet supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("void updateBlob(int columnIndex, Blob x) not yet supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new UnsupportedOperationException("void updateBlob(String columnLabel, Blob x) not yet supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("void updateClob(int columnIndex, Clob x) not yet supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new UnsupportedOperationException("void updateClob(String columnLabel, Clob x) not yet supported");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("void updateArray(int columnIndex, Array x) not yet supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new UnsupportedOperationException("void updateArray(String columnLabel, Array x) not yet supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("RowId getRowId(int columnIndex) not yet supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("RowId getRowId(String columnLabel) not yet supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("void updateRowId(int columnIndex, RowId x) not yet supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException("void updateRowId(String columnLabel, RowId x) not yet supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("int getHoldability() not yet supported");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException("void updateNString(int columnIndex, String nString) not yet supported");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException("void updateNString(String columnLabel, String nString) not yet supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("void updateNClob(int columnIndex, NClob nClob) not yet supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("void updateNClob(String columnLabel, NClob nClob) not yet supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("NClob getNClob(int columnIndex) not yet supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("NClob getNClob(String columnLabel) not yet supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("SQLXML getSQLXML(int columnIndex) not yet supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("SQLXML getSQLXML(String columnLabel) not yet supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("void updateSQLXML(int columnIndex, SQLXML xmlObject) not yet supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("void updateSQLXML(String columnLabel, SQLXML xmlObject) not yet supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("String getNString(int columnIndex) not yet supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("String getNString(String columnLabel) not yet supported");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Reader getNCharacterStream(int columnIndex) not yet supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Reader getNCharacterStream(String columnLabel) not yet supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("not yet supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateNCharacterStream(String columnLabel, Reader reader, long length) not yet supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateAsciiStream(int columnIndex, InputStream x, long length) not yet supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateBinaryStream(int columnIndex, InputStream x, long length) not yet supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateCharacterStream(int columnIndex, Reader x, long length) not yet supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateAsciiStream(String columnLabel, InputStream x, long length) not yet supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateBinaryStream(String columnLabel, InputStream x, long length) not yet supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateCharacterStream(String columnLabel, Reader reader, long length) not yet supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateBlob(int columnIndex, InputStream inputStream, long length) not yet supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateBlob(String columnLabel, InputStream inputStream, long length) not yet supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateClob(int columnIndex, Reader reader, long length) not yet supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateClob(String columnLabel, Reader reader, long length) not yet supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateNClob(int columnIndex, Reader reader, long length) not yet supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void updateNClob(String columnLabel, Reader reader, long length) not yet supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("void updateNCharacterStream(int columnIndex, Reader x) not yet supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void updateNCharacterStream(String columnLabel, Reader reader) not yet supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("void updateAsciiStream(int columnIndex, InputStream x) not yet supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("void updateBinaryStream(int columnIndex, InputStream x) not yet supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("void updateCharacterStream(int columnIndex, Reader x) not yet supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("void updateAsciiStream(String columnLabel, InputStream x) not yet supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("void updateBinaryStream(String columnLabel, InputStream x) not yet supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void updateCharacterStream(String columnLabel, Reader reader) not yet supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("void updateBlob(int columnIndex, InputStream inputStream) not yet supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("void updateBlob(String columnLabel, InputStream inputStream) not yet supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void updateClob(int columnIndex, Reader reader) not yet supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void updateClob(String columnLabel, Reader reader) not yet supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void updateNClob(int columnIndex, Reader reader) not yet supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void updateNClob(String columnLabel, Reader reader) not yet supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("<T> T unwrap(Class<T> iface) not yet supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("boolean isWrapperFor(Class<?> iface) not yet supported");
    }
}

