/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class ImList<E>
implements List<E>,
Serializable {
    private static final long serialVersionUID = 1L;

    public static <E> Collector<E, Mutable<E>, Immutable<E>> toImmutableList() {
        return new Collector<E, Mutable<E>, Immutable<E>>(){

            @Override
            public Supplier<Mutable<E>> supplier() {
                return () -> Mutable.of(new Object[0]);
            }

            @Override
            public BiConsumer<Mutable<E>, E> accumulator() {
                return Mutable::add;
            }

            @Override
            public BinaryOperator<Mutable<E>> combiner() {
                return (l, r) -> {
                    l.addAll(r);
                    return l;
                };
            }

            @Override
            public Function<Mutable<E>, Immutable<E>> finisher() {
                return Mutable::freeze;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.emptySet();
            }
        };
    }

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof List)) {
            return false;
        }
        Iterator<E> thisIter = this.iterator();
        Iterator thatIter = ((List)that).iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            Object thatElem;
            E thisElem = thisIter.next();
            if (thisElem == (thatElem = thatIter.next()) || thisElem != null && thisElem.equals(thatElem)) continue;
            return false;
        }
        return !thisIter.hasNext() && !thatIter.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E elem : this) {
            hashCode = 31 * hashCode + (elem == null ? 0 : elem.hashCode());
        }
        return hashCode;
    }

    @Override
    public abstract <T> T[] toArray(T[] var1);

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean containsAll(Collection<?> var1);

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract int indexOf(Object var1);

    @Override
    public abstract int lastIndexOf(Object var1);

    @Override
    public abstract ListIterator<E> listIterator();

    @Override
    public abstract ListIterator<E> listIterator(int var1);

    @Override
    public abstract List<E> subList(int var1, int var2);

    public static class Immutable<E>
    extends ImList<E> {
        private static final long serialVersionUID = 1L;
        private final E[] array;
        private final int size;

        Immutable(E[] array, int size) {
            this.array = array;
            this.size = size;
        }

        @SafeVarargs
        public static <E> Immutable<E> of(E ... elems) {
            return new Immutable<E>(Arrays.copyOf(elems, elems.length), elems.length);
        }

        public static <E> Immutable<E> sortedCopyOf(Collection<E> collection, Comparator<? super E> comparator) {
            Objects.requireNonNull(comparator);
            Object[] newArray = collection.toArray(new Object[0]);
            Arrays.sort(newArray, comparator);
            return new Immutable<Object>(newArray, newArray.length);
        }

        public static <E> Immutable<E> copyOf(Iterable<? extends E> iterable) {
            if (iterable instanceof Immutable) {
                return (Immutable)iterable;
            }
            int size = 4;
            if (iterable instanceof Collection) {
                size = ((Collection)iterable).size();
            }
            Mutable<E> copy = new Mutable<E>(size);
            for (E e : iterable) {
                copy.add(e);
            }
            return copy.freeze();
        }

        public static <E> Immutable<E> copyOf(E[] array) {
            Mutable<E> copy = new Mutable<E>(array.length);
            E[] EArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                E e = EArray[n2];
                copy.add(e);
                ++n2;
            }
            return copy.freeze();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            Objects.requireNonNull(o);
            return this.indexOf(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iter(null, null);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                return Arrays.copyOf(this.array, size, a.getClass());
            }
            System.arraycopy(this.array, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return c.stream().allMatch(this::contains);
        }

        @Override
        public E get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.array[index];
        }

        @Override
        public int indexOf(Object o) {
            return IntStream.range(0, this.array.length).filter(i -> Objects.equals(o, this.array[i])).findFirst().orElse(-1);
        }

        @Override
        public int lastIndexOf(Object o) {
            return IntStream.iterate(this.array.length - 1, i -> i - 1).limit(this.array.length).filter(i -> Objects.equals(o, this.array[i])).findFirst().orElse(-1);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            return new Immutable<E>(Arrays.copyOfRange(this.array, fromIndex, toIndex), toIndex - fromIndex);
        }

        public Mutable<E> mutableCopy() {
            return new Mutable<Object>(this.toArray());
        }

        public String toString() {
            return "ImList.Immutable[" + this.stream().map(Objects::toString).collect(Collectors.joining(", ")) + ']';
        }

        private class Iter
        implements Iterator<E> {
            int cursor = 0;

            private Iter() {
            }

            @Override
            public boolean hasNext() {
                return this.cursor < Immutable.this.size;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object e = Immutable.this.array[this.cursor];
                ++this.cursor;
                return e;
            }

            /* synthetic */ Iter(Iter iter, Iter iter2) {
                this();
            }
        }

        private class ListIter
        extends Iter
        implements ListIterator<E> {
            ListIter(int index) {
                this.cursor = index;
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                --this.cursor;
                return Immutable.this.array[this.cursor];
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class Mutable<E>
    extends ImList<E> {
        private static final long serialVersionUID = 1L;
        private E[] array;
        private int size = 0;
        @Nullable
        private Immutable<E> frozen = null;

        public Mutable(int initialCapacity) {
            if (initialCapacity > 0) {
                this.array = new Object[initialCapacity];
            } else if (initialCapacity == 0) {
                this.array = new Object[0];
            } else {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
        }

        Mutable(E[] array) {
            this.array = array;
            this.size = array.length;
        }

        public static <E> Mutable<E> of(E ... elements) {
            Mutable<E> result = new Mutable<E>(elements.length);
            if (elements.length == 0) {
                return result;
            }
            E[] EArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                E element = EArray[n2];
                result.add(element);
                ++n2;
            }
            return result;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            return Arrays.stream(this.array, 0, this.size).anyMatch(e -> Objects.equals(o, e));
        }

        @Override
        public Iterator<E> iterator() {
            return new Iter(null, null);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.size) {
                return Arrays.copyOf(this.array, this.size, a.getClass());
            }
            System.arraycopy(this.array, 0, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            return a;
        }

        @Override
        public boolean add(E e) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            if (this.size == this.array.length) {
                this.realloc();
            }
            this.array[this.size] = e;
            ++this.size;
            return true;
        }

        private void realloc() {
            this.realloc(this.array.length * 2);
        }

        private void realloc(int newLength) {
            int remainder = newLength % 2;
            if (remainder != 0) {
                newLength = newLength + 2 - remainder;
            }
            this.array = Arrays.copyOf(this.array, Math.max(4, newLength));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return c.stream().allMatch(this::contains);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            return c.stream().map(this::add).reduce(false, (a, b) -> a != false || b != false);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            return c.stream().map(this::remove).reduce(false, (a, b) -> a != false || b != false);
        }

        @Override
        public void clear() {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            int i = 0;
            while (i < this.size) {
                this.array[i] = null;
                ++i;
            }
            this.size = 0;
        }

        @Override
        public E get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.array[index];
        }

        @Override
        public E set(int index, E element) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            E prev = this.array[index];
            this.array[index] = element;
            return prev;
        }

        @Override
        public int indexOf(Object o) {
            return IntStream.range(0, this.array.length).filter(i -> Objects.equals(o, this.array[i])).findFirst().orElse(-1);
        }

        @Override
        public int lastIndexOf(Object o) {
            return IntStream.iterate(this.array.length - 1, i -> i - 1).limit(this.array.length).filter(i -> Objects.equals(o, this.array[i])).findFirst().orElse(-1);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            throw new UnsupportedOperationException();
        }

        public Immutable<E> freeze() {
            if (this.frozen == null) {
                this.frozen = new Immutable<E>(this.array, this.size);
            }
            return this.frozen;
        }

        public boolean isFrozen() {
            return this.frozen != null;
        }

        public String toString() {
            return "ImList.Transient[" + this.stream().map(Objects::toString).collect(Collectors.joining(", ")) + ']';
        }

        @Override
        public boolean remove(Object o) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            int index = this.indexOf(o);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            if (c.isEmpty()) {
                return false;
            }
            Object[] cArray = c.toArray();
            int cSize = cArray.length;
            if (this.size + cSize >= this.array.length) {
                this.realloc(this.size + cSize);
            }
            if (this.size != index) {
                System.arraycopy(this.array, index, this.array, index + cSize, this.size - index);
            }
            System.arraycopy(cArray, 0, this.array, index, cSize);
            this.size += cSize;
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            boolean result = false;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                if (c.contains(e)) continue;
                iterator.remove();
                result = true;
            }
            return result;
        }

        @Override
        public void add(int index, E element) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            if (this.size != index) {
                System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
            }
            this.array[index] = element;
            ++this.size;
        }

        @Override
        public E remove(int index) {
            if (this.isFrozen()) {
                throw new IllegalStateException("Transient frozen into Immutable already");
            }
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            E elem = this.array[index];
            --this.size;
            if (this.size != index) {
                System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
            }
            this.array[this.size] = null;
            return elem;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        private class Iter
        implements Iterator<E> {
            int cursor = 0;
            int lastRet = -1;

            private Iter() {
            }

            @Override
            public boolean hasNext() {
                return this.cursor < Mutable.this.size;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object e = Mutable.this.array[this.cursor];
                this.lastRet = this.cursor++;
                return e;
            }

            @Override
            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                Mutable.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
            }

            /* synthetic */ Iter(Iter iter, Iter iter2) {
                this();
            }
        }

        private class ListIter
        extends Iter
        implements ListIterator<E> {
            ListIter(int index) {
                this.cursor = index;
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                --this.cursor;
                this.lastRet = this.cursor;
                return Mutable.this.array[this.cursor];
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void set(E e) {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                Mutable.this.set(this.lastRet, e);
            }

            @Override
            public void add(E e) {
                Mutable.this.add(this.cursor, e);
                ++this.cursor;
                this.lastRet = -1;
            }
        }
    }
}

