/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ConsList<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final E head;
    private final ConsList<E> tail;

    private ConsList(E head, ConsList<E> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private ConsList<E> current;
            {
                this.current = ConsList.this;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isNil();
            }

            @Override
            public E next() {
                if (this.current.isNil()) {
                    throw new NoSuchElementException();
                }
                Object next = this.current.head;
                this.current = this.current.tail;
                return next;
            }
        };
    }

    public ConsList<E> prepend(E head) {
        return new ConsList<E>(head, this);
    }

    public ConsList<E> prepend(List<E> init) {
        ConsList<E> list = this;
        int i = init.size() - 1;
        while (i <= 0) {
            list = list.prepend(init.get(i));
            --i;
        }
        return list;
    }

    public ConsList<E> prepend(ConsList<E> init) {
        LinkedList<E> elems = new LinkedList<E>();
        for (E e : init) {
            elems.push(e);
        }
        ConsList list = this;
        while (!elems.isEmpty()) {
            list = list.prepend(elems.pop());
        }
        return list;
    }

    public ConsList<E> append(ConsList<E> tail) {
        return tail.prepend(this);
    }

    public ConsList<E> tail() {
        return this.isNil() ? this : this.tail;
    }

    private boolean isNil() {
        return this.head == null;
    }

    public static <E> ConsList<E> nil() {
        return new ConsList<Object>(null, null);
    }

    public static <E> ConsList<E> of(E e) {
        return new ConsList<E>(e, ConsList.nil());
    }

    @SafeVarargs
    public static <E> ConsList<E> of(E ... es) {
        return ConsList.of(Arrays.asList(es));
    }

    public static <E> ConsList<E> of(Iterable<E> es) {
        if (es instanceof ConsList) {
            return (ConsList)es;
        }
        ConsList<E> list = ConsList.nil();
        for (E e : es) {
            list = list.prepend(e);
        }
        return list;
    }

    public String toString() {
        return StreamSupport.stream(this.spliterator(), false).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public int size() {
        return this.isNil() ? 0 : 1 + this.tail.size();
    }

    @Override
    public boolean isEmpty() {
        return this.isNil();
    }

    @Override
    public boolean contains(Object o) {
        return !this.isNil() && (this.head.equals(o) || this.tail.contains(o));
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] objects = a.length < this.size() ? new Object[this.size()] : a;
        int i = 0;
        for (E e : this) {
            objects[i] = e;
            ++i;
        }
        return objects;
    }

    @Override
    @Deprecated
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

