/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.config.language;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import mb.nabl2.config.NaBL2Config;
import mb.nabl2.config.NaBL2DebugConfig;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;

public final class NaBL2ConfigReaderWriter {
    private static final String PROP_DEBUG = "debug";
    private static final String PROP_INCREMENTAL = "incremental";

    public static NaBL2Config read(HierarchicalConfiguration<ImmutableNode> config) {
        boolean incremental = config.getBoolean(PROP_INCREMENTAL, false);
        NaBL2DebugConfig debug = NaBL2DebugConfig.of(NaBL2ConfigReaderWriter.readFlags(config.getString(PROP_DEBUG, "")));
        return new NaBL2Config(incremental, debug);
    }

    public static void write(NaBL2Config nabl2Config, HierarchicalConfiguration<ImmutableNode> config) {
        if (nabl2Config.incremental()) {
            config.setProperty(PROP_INCREMENTAL, (Object)nabl2Config.incremental());
        }
        if (!nabl2Config.debug().flags().isEmpty()) {
            config.setProperty(PROP_DEBUG, nabl2Config.debug().flags());
        }
    }

    private static Collection<String> splitString(String string) {
        return Arrays.asList(string.trim().split("\\s+")).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static Collection<NaBL2DebugConfig.Flag> readFlags(String flagNames) {
        ArrayList<NaBL2DebugConfig.Flag> flags = new ArrayList<NaBL2DebugConfig.Flag>();
        for (String name : NaBL2ConfigReaderWriter.splitString(flagNames)) {
            try {
                flags.add(NaBL2DebugConfig.Flag.valueOf(name.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        EnumSet<NaBL2DebugConfig.Flag> set = EnumSet.noneOf(NaBL2DebugConfig.Flag.class);
        set.addAll(flags);
        return set;
    }

    public static Collection<IMessage> validate(ImmutableConfiguration config, MessageBuilder mb) {
        String allFlags = String.join((CharSequence)" ", Arrays.asList(NaBL2DebugConfig.Flag.values()).stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.toList()));
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        for (String flag : NaBL2ConfigReaderWriter.splitString(config.getString(PROP_DEBUG, ""))) {
            try {
                NaBL2DebugConfig.Flag.valueOf(flag.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                messages.add(mb.withMessage("Invalid NaBL2 debug flag: " + flag + ", must be one of: " + allFlags + ".").build());
            }
        }
        return messages;
    }
}

