/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.parsetable.LRItem;
import org.metaborg.sdf2table.parsetable.State;
import org.metaborg.util.collection.SetMultimap;

public class SymbolStatesMapping
implements Serializable {
    private static final long serialVersionUID = 1109889933255986338L;
    public SetMultimap<ISymbol, LRItem> symbolItems = new SetMultimap();
    public SetMultimap<LRItem, State> itemStates = new SetMultimap();

    public Set<State> getStatesfromSymbol(Symbol symb) {
        HashSet<State> result = new HashSet<State>();
        for (LRItem item : (Set)this.symbolItems.get(symb)) {
            result.addAll((Collection<State>)this.itemStates.get(item));
        }
        return result;
    }

    public Set<State> getStatesfromProduction(IProduction prod, SetMultimap<Priority, Integer> priorities) {
        HashSet<State> result = new HashSet<State>();
        for (LRItem item : (Set)this.symbolItems.get(prod.leftHand())) {
            if (item.isPriorityConflict(prod)) continue;
            result.addAll((Collection<State>)this.itemStates.get(item));
        }
        return result;
    }

    public Set<State> getStatesfromItem(LRItem item) {
        return (Set)this.itemStates.get(item);
    }

    public Set<LRItem> getItemsfromSymbol(Symbol symb) {
        return (Set)this.symbolItems.get(symb);
    }

    public void addLink(Symbol symb, LRItem item, State state) {
        this.symbolItems.put(symb, item);
        this.itemStates.put(item, state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolStatesMapping that = (SymbolStatesMapping)o;
        return Objects.equals(this.symbolItems, that.symbolItems) && Objects.equals(this.itemStates, that.itemStates);
    }

    public int hashCode() {
        return Objects.hash(this.symbolItems, this.itemStates);
    }
}

