/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.deepconflicts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.parsetable.ParseTable;

public class ContextualFactory
implements Serializable {
    private static final long serialVersionUID = -5796688665070378982L;
    private final Map<ContextKey, Context> contexts = new HashMap<ContextKey, Context>();
    private final Map<ContextualProductionKey, ContextualProduction> contextualProductions = new HashMap<ContextualProductionKey, ContextualProduction>();
    private final Map<ContextualSymbolKey, ContextualSymbol> contextualSymbols = new HashMap<ContextualSymbolKey, ContextualSymbol>();

    public Context createContext(int c, ContextType type, ContextPosition position, Map<Integer, Integer> leftmostContextsMapping, Map<Integer, Integer> rightmostContextsMapping) {
        ContextKey contextFields = new ContextKey(c, type, position, leftmostContextsMapping, rightmostContextsMapping);
        if (this.contexts.containsKey(contextFields)) {
            return this.contexts.get(contextFields);
        }
        Context context = new Context(c, type, position, leftmostContextsMapping, rightmostContextsMapping);
        this.contexts.put(contextFields, context);
        return context;
    }

    public ContextualProduction createContextualProduction(Production origProduction, ISymbol lhs, List<ISymbol> rhs, int origProductionLabel, ContextualFactory cf) {
        ContextualProductionKey contextualProductionFields = new ContextualProductionKey(origProduction, lhs, origProductionLabel, cf, rhs);
        if (this.contextualProductions.containsKey(contextualProductionFields)) {
            return this.contextualProductions.get(contextualProductionFields);
        }
        ContextualProduction cp = new ContextualProduction(origProduction, lhs, rhs, origProductionLabel, cf);
        this.contextualProductions.put(contextualProductionFields, cp);
        return cp;
    }

    public ContextualProduction createContextualProduction(Production origProduction, Set<Context> contexts, Set<Integer> args, int origProductionLabel, ContextualFactory cf) {
        ArrayList<ISymbol> rhs = new ArrayList<ISymbol>();
        int i = 0;
        while (i < origProduction.arity()) {
            if (args.contains(i)) {
                rhs.add(this.createContextualSymbol(origProduction.getRhs().get(i), contexts, this));
            } else {
                rhs.add(origProduction.rightHand().get(i));
            }
            ++i;
        }
        return this.createContextualProduction(origProduction, origProduction.leftHand(), rhs, origProductionLabel, cf);
    }

    public ContextualProduction createContextualProduction(Production origProduction, Set<Context> contexts, Queue<ContextualSymbol> contextualSymbols, Set<ContextualSymbol> processedSymbols, int origProductionLabel, ParseTable pt) {
        ContextualSymbol lhs = this.createContextualSymbol(origProduction.getLhs(), contexts, this);
        ArrayList<ISymbol> rhs = new ArrayList<ISymbol>(origProduction.getRhs());
        for (Context c : contexts) {
            if (c.getType() == ContextType.DEEP) {
                ISymbol nonTerminalContext = pt.productionLabels().inverse().get(c.getContext()).leftHand();
                int i = 0;
                while (i < origProduction.arity()) {
                    if (i == 0 && c.getPosition().equals((Object)ContextPosition.LEFTMOST) && ((Set)pt.normalizedGrammar().getLeftDerivable().get(origProduction.rightHand().get(i))).contains(nonTerminalContext) || i == origProduction.arity() - 1 && c.getPosition().equals((Object)ContextPosition.RIGHTMOST) && ((Set)pt.normalizedGrammar().getRightDerivable().get(origProduction.rightHand().get(i))).contains(nonTerminalContext)) {
                        ContextualSymbol newSymbol = rhs.get(i) instanceof ContextualSymbol ? ((ContextualSymbol)rhs.get(i)).addContext(c) : this.createContextualSymbol((Symbol)rhs.get(i), c, this);
                        rhs.set(i, newSymbol);
                    }
                    ++i;
                }
                continue;
            }
            if (c.getType() != ContextType.DANGLING) continue;
            int i = 0;
            while (i < origProduction.arity()) {
                if (i == 0 && i == origProduction.leftRecursivePosition() || i == origProduction.arity() - 1 && i == origProduction.rightRecursivePosition()) {
                    ContextualSymbol newSymbol = rhs.get(i) instanceof ContextualSymbol ? ((ContextualSymbol)rhs.get(i)).addContext(c) : this.createContextualSymbol((Symbol)rhs.get(i), c, this);
                    rhs.set(i, newSymbol);
                }
                ++i;
            }
        }
        for (ISymbol s : rhs) {
            if (!(s instanceof ContextualSymbol)) continue;
            ContextualSymbol new_symbol = (ContextualSymbol)s;
            if (contextualSymbols == null || processedSymbols == null || processedSymbols.contains(new_symbol) || contextualSymbols.contains(new_symbol)) continue;
            contextualSymbols.add(new_symbol);
        }
        ContextualProductionKey contextualProductionFields = new ContextualProductionKey(origProduction, lhs, origProductionLabel, this, rhs);
        if (this.contextualProductions.containsKey(contextualProductionFields)) {
            return this.contextualProductions.get(contextualProductionFields);
        }
        ContextualProduction cp = new ContextualProduction(origProduction, lhs, rhs, origProductionLabel, this);
        this.contextualProductions.put(contextualProductionFields, cp);
        return cp;
    }

    public ContextualSymbol createContextualSymbol(Symbol s, Set<Context> contexts, ContextualFactory cf) {
        ContextualSymbolKey contextualSymbolFields = new ContextualSymbolKey(Collections.singleton(s), contexts);
        if (this.contextualSymbols.containsKey(contextualSymbolFields)) {
            ContextualSymbol cs = this.contextualSymbols.get(contextualSymbolFields);
            for (Context context : contexts) {
                if (context.getType() != ContextType.DEEP && context.getType() != ContextType.DANGLING) continue;
                cs.setDeepContextBitmap(cs.deepContexts() | context.getContextBitmap());
            }
            return cs;
        }
        ContextualSymbol cs = new ContextualSymbol(s, contexts, this);
        this.contextualSymbols.put(contextualSymbolFields, cs);
        return cs;
    }

    public ContextualSymbol createContextualSymbol(Symbol s, Context context, ContextualFactory cf) {
        ContextualSymbolKey contextualSymbolFields = new ContextualSymbolKey(Collections.singleton(s), Collections.singleton(context));
        if (this.contextualSymbols.containsKey(contextualSymbolFields)) {
            ContextualSymbol cs = this.contextualSymbols.get(contextualSymbolFields);
            cs.setDeepContextBitmap(cs.deepContexts() | context.getContextBitmap());
            return this.contextualSymbols.get(contextualSymbolFields);
        }
        ContextualSymbol cs = new ContextualSymbol(s, context, this);
        this.contextualSymbols.put(contextualSymbolFields, cs);
        return cs;
    }

    public ContextualSymbol createContextualSymbol(Symbol s, Set<Context> contexts, long deepContextBitmap, ContextualFactory cf) {
        ContextualSymbolKey contextualSymbolFields = new ContextualSymbolKey(Collections.singleton(s), contexts);
        if (this.contextualSymbols.containsKey(contextualSymbolFields)) {
            ContextualSymbol cs = this.contextualSymbols.get(contextualSymbolFields);
            cs.setDeepContextBitmap(deepContextBitmap);
            return this.contextualSymbols.get(contextualSymbolFields);
        }
        ContextualSymbol cs = new ContextualSymbol(s, contexts, deepContextBitmap, this);
        this.contextualSymbols.put(contextualSymbolFields, cs);
        return cs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualFactory that = (ContextualFactory)o;
        return Objects.equals(this.contexts, that.contexts) && Objects.equals(this.contextualProductions, that.contextualProductions) && Objects.equals(this.contextualSymbols, that.contextualSymbols);
    }

    public int hashCode() {
        return Objects.hash(this.contexts, this.contextualProductions, this.contextualSymbols);
    }

    private static final class ContextKey
    implements Serializable {
        private final int c;
        private final ContextType type;
        private final ContextPosition position;
        private final Map<Integer, Integer> leftmostContextsMapping;
        private final Map<Integer, Integer> rightmostContextsMapping;

        public ContextKey(int c, ContextType type, ContextPosition position, Map<Integer, Integer> leftmostContextsMapping, Map<Integer, Integer> rightmostContextsMapping) {
            this.c = c;
            this.type = type;
            this.position = position;
            this.leftmostContextsMapping = leftmostContextsMapping;
            this.rightmostContextsMapping = rightmostContextsMapping;
        }

        public String toString() {
            return "ContextKey{c=" + this.c + ", type=" + (Object)((Object)this.type) + ", position=" + (Object)((Object)this.position) + ", leftmostContextsMapping=" + this.leftmostContextsMapping + ", rightmostContextsMapping=" + this.rightmostContextsMapping + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextKey that = (ContextKey)o;
            return this.c == that.c && this.type == that.type && this.position == that.position && Objects.equals(this.leftmostContextsMapping, that.leftmostContextsMapping) && Objects.equals(this.rightmostContextsMapping, that.rightmostContextsMapping);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.c, this.type, this.position, this.leftmostContextsMapping, this.rightmostContextsMapping});
        }
    }

    private static final class ContextualProductionKey
    implements Serializable {
        private final Production origProduction;
        private final ISymbol lhs;
        private final int origProductionLabel;
        private final ContextualFactory cf;
        private final List<ISymbol> rhs;

        public ContextualProductionKey(Production origProduction, ISymbol lhs, int origProductionLabel, ContextualFactory cf, List<ISymbol> rhs) {
            this.origProduction = origProduction;
            this.lhs = lhs;
            this.origProductionLabel = origProductionLabel;
            this.cf = cf;
            this.rhs = rhs;
        }

        public String toString() {
            return "ContextualContextKey{origProduction=" + this.origProduction + ", lhs=" + this.lhs + ", origProductionLabel=" + this.origProductionLabel + ", cf=" + this.cf + ", rhs=" + this.rhs + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextualProductionKey that = (ContextualProductionKey)o;
            return this.origProductionLabel == that.origProductionLabel && Objects.equals(this.origProduction, that.origProduction) && Objects.equals(this.lhs, that.lhs) && this.cf == that.cf && Objects.equals(this.rhs, that.rhs);
        }

        public int hashCode() {
            return Objects.hash(this.origProduction, this.lhs, this.origProductionLabel, System.identityHashCode(this.cf), this.rhs);
        }
    }

    private static final class ContextualSymbolKey
    implements Serializable {
        private final Set<Symbol> es;
        private final Set<Context> contexts;

        public ContextualSymbolKey(Set<Symbol> es, Set<Context> contexts) {
            this.es = es;
            this.contexts = contexts;
        }

        public String toString() {
            return "ContextualSymbolKey{es=" + this.es + ", contexts=" + this.contexts + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextualSymbolKey that = (ContextualSymbolKey)o;
            return Objects.equals(this.es, that.es) && Objects.equals(this.contexts, that.contexts);
        }

        public int hashCode() {
            return Objects.hash(this.es, this.contexts);
        }
    }
}

