/*
 * Decompiled with CFR 0.152.
 */
package mb.util.vfs2.resource;

import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class PatternFileSelector
implements FileSelector {
    private final Pattern pattern;

    public PatternFileSelector(Pattern pattern) {
        this.pattern = pattern;
    }

    public PatternFileSelector(String regex) {
        this(Pattern.compile(regex));
    }

    public PatternFileSelector(String regex, int flags) {
        this(Pattern.compile(regex, flags));
    }

    public boolean includeFile(FileSelectInfo fileInfo) {
        return this.pattern.matcher(fileInfo.getFile().getName().getPath()).matches();
    }

    public boolean traverseDescendents(FileSelectInfo fileInfo) {
        return true;
    }

    public String toString() {
        return this.pattern.toString();
    }
}

