/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import java.util.ArrayList;
import java.util.Objects;
import mb.statix.constraints.CTrue;
import mb.statix.solver.persistent.step.ACTrueStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CTrueStep
extends ACTrueStep {
    private final CTrue constraint;
    private final StepResult result;
    private transient int hashCode;

    private CTrueStep(CTrue constraint, StepResult result) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
    }

    private CTrueStep(CTrueStep original, CTrue constraint, StepResult result) {
        this.constraint = constraint;
        this.result = result;
    }

    @Override
    public CTrue constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    public final CTrueStep withConstraint(CTrue value) {
        if (this.constraint == value) {
            return this;
        }
        CTrue newValue = Objects.requireNonNull(value, "constraint");
        return new CTrueStep(this, newValue, this.result);
    }

    public final CTrueStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CTrueStep(this, this.constraint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CTrueStep && this.equalTo(0, (CTrueStep)another);
    }

    private boolean equalTo(int synthetic, CTrueStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "CTrueStep{constraint=" + this.constraint + ", result=" + this.result + "}";
    }

    public static CTrueStep of(CTrue constraint, StepResult result) {
        return new CTrueStep(constraint, result);
    }

    public static CTrueStep copyOf(ACTrueStep instance) {
        if (instance instanceof CTrueStep) {
            return (CTrueStep)instance;
        }
        return CTrueStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CTrueStep(CTrueStep cTrueStep, CTrue cTrue, StepResult stepResult, CTrueStep cTrueStep2) {
        this(cTrueStep, cTrue, stepResult);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CTrue constraint;
        private StepResult result;

        private Builder() {
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ACTrueStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
            if (object instanceof ACTrueStep) {
                instance = (ACTrueStep)object;
                this.constraint(((ACTrueStep)instance).constraint());
            }
        }

        public final Builder constraint(CTrue constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CTrueStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CTrueStep(null, this.constraint, this.result, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CTrueStep, some of required attributes are not set " + attributes;
        }
    }
}

