/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.statix.constraints.CInequal;
import mb.statix.solver.persistent.step.ACInequalStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CInequalStep
extends ACInequalStep {
    private final CInequal constraint;
    private final StepResult result;
    @Nullable
    private final IUnifier.Result<Optional<Diseq>> unifierResult;
    private transient int hashCode;

    private CInequalStep(CInequal constraint, StepResult result, @Nullable IUnifier.Result<Optional<Diseq>> unifierResult) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.unifierResult = unifierResult;
    }

    private CInequalStep(CInequalStep original, CInequal constraint, StepResult result, @Nullable IUnifier.Result<Optional<Diseq>> unifierResult) {
        this.constraint = constraint;
        this.result = result;
        this.unifierResult = unifierResult;
    }

    @Override
    public CInequal constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public IUnifier.Result<Optional<Diseq>> unifierResult() {
        return this.unifierResult;
    }

    public final CInequalStep withConstraint(CInequal value) {
        if (this.constraint == value) {
            return this;
        }
        CInequal newValue = Objects.requireNonNull(value, "constraint");
        return new CInequalStep(this, newValue, this.result, this.unifierResult);
    }

    public final CInequalStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CInequalStep(this, this.constraint, newValue, this.unifierResult);
    }

    public final CInequalStep withUnifierResult(@Nullable IUnifier.Result<Optional<Diseq>> value) {
        if (this.unifierResult == value) {
            return this;
        }
        return new CInequalStep(this, this.constraint, this.result, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CInequalStep && this.equalTo(0, (CInequalStep)another);
    }

    private boolean equalTo(int synthetic, CInequalStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.unifierResult, another.unifierResult);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.unifierResult);
        return h;
    }

    public String toString() {
        return "CInequalStep{constraint=" + this.constraint + ", result=" + this.result + ", unifierResult=" + this.unifierResult + "}";
    }

    public static CInequalStep of(CInequal constraint, StepResult result, @Nullable IUnifier.Result<Optional<Diseq>> unifierResult) {
        return new CInequalStep(constraint, result, unifierResult);
    }

    public static CInequalStep copyOf(ACInequalStep instance) {
        if (instance instanceof CInequalStep) {
            return (CInequalStep)instance;
        }
        return CInequalStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CInequalStep(CInequalStep cInequalStep, CInequal cInequal, StepResult stepResult, IUnifier.Result result, CInequalStep cInequalStep2) {
        this(cInequalStep, cInequal, stepResult, result);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CInequal constraint;
        private StepResult result;
        private IUnifier.Result<Optional<Diseq>> unifierResult;

        private Builder() {
        }

        public final Builder from(ACInequalStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACInequalStep) {
                instance = (ACInequalStep)object;
                IUnifier.Result<Optional<Diseq>> unifierResultValue = ((ACInequalStep)instance).unifierResult();
                if (unifierResultValue != null) {
                    this.unifierResult(unifierResultValue);
                }
                this.constraint(((ACInequalStep)instance).constraint());
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CInequal constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder unifierResult(@Nullable IUnifier.Result<Optional<Diseq>> unifierResult) {
            this.unifierResult = unifierResult;
            return this;
        }

        public CInequalStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CInequalStep(null, this.constraint, this.result, this.unifierResult, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CInequalStep, some of required attributes are not set " + attributes;
        }
    }
}

