/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.scopegraph;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Transform;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;
import mb.scopegraph.oopsla20.diff.ScopeGraphDifferOps;
import mb.statix.scopegraph.Scope;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Predicate2;

public class StatixDifferOps
implements ScopeGraphDifferOps<Scope, ITerm> {
    private static final String DIFF_OP = "Diff";
    private static final String CHANGES_OP = "Changes";
    private static final String MATCH_OP = "MatchEntry";
    private static final String SCOPE_OP = "ScopeEntry";
    private static final String EDGE_OP = "EdgeEntry";
    private final IUnifier.Immutable currentUnifier;
    private final IUnifier.Immutable previousUnifier;

    public StatixDifferOps(IUnifier.Immutable currentUnifier, IUnifier.Immutable previousUnifier) {
        this.currentUnifier = currentUnifier;
        this.previousUnifier = previousUnifier;
    }

    @Override
    public boolean isMatchAllowed(Scope current, Scope previous) {
        return current.getResource().equals(previous.getResource());
    }

    @Override
    public Set<Scope> getCurrentScopes(ITerm current) {
        return CapsuleUtil.toSet(Transform.T.collecttd(Scope.matcher()::match).apply(this.currentUnifier.findRecursive(current)));
    }

    @Override
    public Set<Scope> getPreviousScopes(ITerm previous) {
        return CapsuleUtil.toSet(Transform.T.collecttd(Scope.matcher()::match).apply(this.previousUnifier.findRecursive(previous)));
    }

    @Override
    public boolean matchDatums(ITerm current, ITerm previous, Predicate2<Scope, Scope> matchScopes) {
        return this.termMatch(this.currentUnifier.findRecursive(current), this.previousUnifier.findRecursive(previous), matchScopes);
    }

    private boolean termMatch(ITerm left, ITerm right, Predicate2<Scope, Scope> matchScopes) {
        Optional<Scope> leftScope = Scope.matcher().match(left);
        if (leftScope.isPresent()) {
            Optional<Scope> rightScope = Scope.matcher().match(right);
            if (!rightScope.isPresent()) {
                return false;
            }
            return matchScopes.test(leftScope.get(), rightScope.get());
        }
        return left.match(Terms.cases(applLeft -> right.match(Terms.cases().appl(applRight -> {
            if (applLeft.getArity() == applRight.getArity() && applLeft.getOp().equals(applRight.getOp()) && this.termsMatch(applLeft.getArgs(), applRight.getArgs(), matchScopes)) {
                return true;
            }
            return false;
        }).otherwise(t -> false)), listLeft -> right.match(Terms.cases().list(listRight -> this.listMatch((IListTerm)listLeft, (IListTerm)listRight, matchScopes)).otherwise(t -> false)), stringLeft -> right.match(Terms.cases().string(stringRight -> stringLeft.getValue().equals(stringRight.getValue())).otherwise(t -> false)), integerLeft -> right.match(Terms.cases().integer(integerRight -> {
            if (integerLeft.getValue() == integerRight.getValue()) {
                return true;
            }
            return false;
        }).otherwise(t -> false)), blobLeft -> right.match(Terms.cases().blob(blobRight -> blobLeft.getValue().equals(blobRight.getValue())).otherwise(t -> false)), varLeft -> right.match(Terms.cases().var(varRight -> varLeft.equals(varRight)).otherwise(termRight -> false))));
    }

    private boolean listMatch(IListTerm _left, IListTerm _right, Predicate2<Scope, Scope> matchScopes) {
        IListTerm left = (IListTerm)this.currentUnifier.findTerm(_left);
        IListTerm right = (IListTerm)this.currentUnifier.findTerm(_right);
        return left.match(ListTerms.cases(consLeft -> right.match(ListTerms.cases().cons(consRight -> {
            if (this.termMatch(consLeft.getHead(), consRight.getHead(), matchScopes) && this.listMatch(consLeft.getTail(), consRight.getTail(), matchScopes)) {
                return true;
            }
            return false;
        }).otherwise(l -> false)), nilLeft -> right.match(ListTerms.cases().nil(nilRight -> true).otherwise(l -> false)), varLeft -> right.match(ListTerms.cases().var(varRight -> varLeft.equals(varRight)).otherwise(termRight -> false))));
    }

    private boolean termsMatch(Iterable<ITerm> lefts, Iterable<ITerm> rights, Predicate2<Scope, Scope> matchScopes) {
        Iterator<ITerm> itLeft = lefts.iterator();
        Iterator<ITerm> itRight = rights.iterator();
        while (itLeft.hasNext()) {
            if (!itRight.hasNext()) {
                return false;
            }
            if (this.termMatch(itLeft.next(), itRight.next(), matchScopes)) continue;
            return false;
        }
        return !itRight.hasNext();
    }

    public static ITerm toTerm(ScopeGraphDiff<Scope, ITerm, ITerm> diff, IUnifier.Immutable current, IUnifier.Immutable previous) {
        List matchedScopes = diff.matchedScopes().entrySet().stream().map(e -> TermBuild.B.newAppl(MATCH_OP, (ITerm)e.getKey(), (ITerm)e.getValue())).collect(ImList.Immutable.toImmutableList());
        ITerm added = StatixDifferOps.toTerm(diff.added(), current);
        ITerm removed = StatixDifferOps.toTerm(diff.removed(), previous);
        return TermBuild.B.newAppl(DIFF_OP, TermBuild.B.newList(matchedScopes), added, removed);
    }

    public static ITerm toTerm(ScopeGraphDiff.Changes<Scope, ITerm, ITerm> changes, IUnifier.Immutable unifier) {
        List scopes = changes.scopes().entrySet().stream().map(e -> TermBuild.B.newAppl(SCOPE_OP, (ITerm)e.getKey(), unifier.findRecursive((ITerm)e.getValue()))).collect(ImList.Immutable.toImmutableList());
        List edges = changes.edges().stream().map(e -> TermBuild.B.newAppl(EDGE_OP, (ITerm)e.source, (ITerm)e.label, (ITerm)e.target)).collect(ImList.Immutable.toImmutableList());
        return TermBuild.B.newAppl(CHANGES_OP, TermBuild.B.newList(scopes), TermBuild.B.newList(edges));
    }
}

