/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp.impl;

import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.impl.AAnd;

final class And<S>
extends AAnd<S>
implements Serializable {
    private final IRegExp<S> left;
    private final IRegExp<S> right;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private And(IRegExp<S> left, IRegExp<S> right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    private And(And<S> original, IRegExp<S> left, IRegExp<S> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public IRegExp<S> getLeft() {
        return this.left;
    }

    @Override
    public IRegExp<S> getRight() {
        return this.right;
    }

    public final And<S> withLeft(IRegExp<S> value) {
        if (this.left == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "left");
        return new And<S>(this, newValue, this.right);
    }

    public final And<S> withRight(IRegExp<S> value) {
        if (this.right == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "right");
        return new And<S>(this, this.left, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof And && this.equalTo(0, (And)another);
    }

    private boolean equalTo(int synthetic, And<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.left.equals(another.left) && this.right.equals(another.right);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        return h;
    }

    public static <S> And<S> of(IRegExp<S> left, IRegExp<S> right) {
        return new And<S>(left, right);
    }

    public static <S> And<S> copyOf(AAnd<S> instance) {
        if (instance instanceof And) {
            return (And)instance;
        }
        return And.of(instance.getLeft(), instance.getRight());
    }
}

