/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms.path;

import io.usethesource.capsule.Set;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.terms.path.ANStep;
import org.metaborg.util.collection.ConsList;

final class NStep<S extends IScope, L extends ILabel, O extends IOccurrence>
extends ANStep<S, L, O>
implements Serializable {
    private final S source;
    private final L label;
    private final IResolutionPath<S, L, O> importPath;
    private final S target;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long SIZE_LAZY_INIT_BIT = 1L;
    private transient int size;
    private static final long IMPORTS_LAZY_INIT_BIT = 2L;
    private transient Set.Immutable<O> imports;
    private static final long SCOPES_LAZY_INIT_BIT = 4L;
    private transient Set.Immutable<S> scopes;
    private static final long LABELS_LAZY_INIT_BIT = 8L;
    private transient ConsList<L> labels;
    private static final long serialVersionUID = 42L;

    private NStep(S source, L label, IResolutionPath<S, L, O> importPath, S target) {
        this.source = (IScope)Objects.requireNonNull(source, "source");
        this.label = (ILabel)Objects.requireNonNull(label, "label");
        this.importPath = Objects.requireNonNull(importPath, "importPath");
        this.target = (IScope)Objects.requireNonNull(target, "target");
        this.hashCode = this.computeHashCode();
    }

    private NStep(NStep<S, L, O> original, S source, L label, IResolutionPath<S, L, O> importPath, S target) {
        this.source = source;
        this.label = label;
        this.importPath = importPath;
        this.target = target;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public L getLabel() {
        return this.label;
    }

    @Override
    public IResolutionPath<S, L, O> getImportPath() {
        return this.importPath;
    }

    @Override
    public S getTarget() {
        return this.target;
    }

    public final NStep<S, L, O> withSource(S value) {
        if (this.source == value) {
            return this;
        }
        IScope newValue = (IScope)Objects.requireNonNull(value, "source");
        return new NStep<IScope, L, O>(this, newValue, this.label, this.importPath, (IScope)this.target);
    }

    public final NStep<S, L, O> withLabel(L value) {
        if (this.label == value) {
            return this;
        }
        ILabel newValue = (ILabel)Objects.requireNonNull(value, "label");
        return new NStep<S, ILabel, O>(this, this.source, newValue, this.importPath, this.target);
    }

    public final NStep<S, L, O> withImportPath(IResolutionPath<S, L, O> value) {
        if (this.importPath == value) {
            return this;
        }
        IResolutionPath<S, L, O> newValue = Objects.requireNonNull(value, "importPath");
        return new NStep<S, L, O>(this, this.source, this.label, newValue, this.target);
    }

    public final NStep<S, L, O> withTarget(S value) {
        if (this.target == value) {
            return this;
        }
        IScope newValue = (IScope)Objects.requireNonNull(value, "target");
        return new NStep<IScope, L, O>(this, (IScope)this.source, this.label, this.importPath, newValue);
    }

    @Override
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NStep && this.equalTo(0, (NStep)another);
    }

    private boolean equalTo(int synthetic, NStep<?, ?, ?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.source.equals(another.source) && this.label.equals(another.label) && this.importPath.equals(another.importPath) && this.target.equals(another.target);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.importPath.hashCode();
        h += (h << 5) + this.target.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            NStep nStep = this;
            synchronized (nStep) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.size = super.size();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<O> getImports() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            NStep nStep = this;
            synchronized (nStep) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.imports = Objects.requireNonNull(super.getImports(), "imports");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.imports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<S> getScopes() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            NStep nStep = this;
            synchronized (nStep) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.scopes = Objects.requireNonNull(super.getScopes(), "scopes");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsList<L> getLabels() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            NStep nStep = this;
            synchronized (nStep) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.labels = Objects.requireNonNull(super.getLabels(), "labels");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.labels;
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> NStep<S, L, O> of(S source, L label, IResolutionPath<S, L, O> importPath, S target) {
        return new NStep<S, L, O>(source, label, importPath, target);
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> NStep<S, L, O> copyOf(ANStep<S, L, O> instance) {
        if (instance instanceof NStep) {
            return (NStep)instance;
        }
        return NStep.of(instance.getSource(), instance.getLabel(), instance.getImportPath(), instance.getTarget());
    }

    private Object readResolve() throws ObjectStreamException {
        return new NStep<S, L, O>(this, this.source, this.label, this.importPath, this.target);
    }
}

