/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AIntTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class IntTerm
extends AIntTerm
implements Serializable {
    private final IAttachments attachments;
    private final int value;
    private static final long serialVersionUID = 42L;

    private IntTerm(int value) {
        this.value = value;
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private IntTerm(Builder builder) {
        this.value = builder.value;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private IntTerm(IAttachments attachments, int value) {
        this.attachments = attachments;
        this.value = value;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public final IntTerm withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new IntTerm(newValue, this.value);
    }

    public final IntTerm withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new IntTerm(this.attachments, value);
    }

    public static IntTerm of(int value) {
        return new IntTerm(value);
    }

    public static IntTerm copyOf(AIntTerm instance) {
        if (instance instanceof IntTerm) {
            return (IntTerm)instance;
        }
        return IntTerm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ IntTerm(Builder builder, IntTerm intTerm) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private IAttachments attachments;
        private int value;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IIntTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AIntTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof IIntTerm) {
                instance = (IIntTerm)object;
                if ((bits & 2L) == 0L) {
                    this.value(instance.getValue());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof AIntTerm) {
                instance = (AIntTerm)object;
                if ((bits & 2L) == 0L) {
                    this.value(((AIntTerm)instance).getValue());
                    bits |= 2L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public IntTerm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new IntTerm(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build IntTerm, some of required attributes are not set " + attributes;
        }
    }
}

