/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.scopegraph;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.scopegraph.ACGExportEdge;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.Label;

public final class CGExportEdge
extends ACGExportEdge
implements Serializable {
    private final ITerm declaration;
    private final Label label;
    private final ITerm scope;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CGExportEdge(ITerm declaration, Label label, ITerm scope, IMessageInfo messageInfo) {
        this.declaration = Objects.requireNonNull(declaration, "declaration");
        this.label = Objects.requireNonNull(label, "label");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CGExportEdge(CGExportEdge original, ITerm declaration, Label label, ITerm scope, IMessageInfo messageInfo) {
        this.declaration = declaration;
        this.label = label;
        this.scope = scope;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getDeclaration() {
        return this.declaration;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public ITerm getScope() {
        return this.scope;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CGExportEdge withDeclaration(ITerm value) {
        if (this.declaration == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "declaration");
        return new CGExportEdge(this, newValue, this.label, this.scope, this.messageInfo);
    }

    public final CGExportEdge withLabel(Label value) {
        if (this.label == value) {
            return this;
        }
        Label newValue = Objects.requireNonNull(value, "label");
        return new CGExportEdge(this, this.declaration, newValue, this.scope, this.messageInfo);
    }

    public final CGExportEdge withScope(ITerm value) {
        if (this.scope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "scope");
        return new CGExportEdge(this, this.declaration, this.label, newValue, this.messageInfo);
    }

    public final CGExportEdge withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CGExportEdge(this, this.declaration, this.label, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CGExportEdge && this.equalTo(0, (CGExportEdge)another);
    }

    private boolean equalTo(int synthetic, CGExportEdge another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.declaration.equals(another.declaration) && this.label.equals(another.label) && this.scope.equals(another.scope) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.declaration.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CGExportEdge of(ITerm declaration, Label label, ITerm scope, IMessageInfo messageInfo) {
        return new CGExportEdge(declaration, label, scope, messageInfo);
    }

    public static CGExportEdge copyOf(ACGExportEdge instance) {
        if (instance instanceof CGExportEdge) {
            return (CGExportEdge)instance;
        }
        return CGExportEdge.of(instance.getDeclaration(), instance.getLabel(), instance.getScope(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CGExportEdge(this, this.declaration, this.label, this.scope, this.messageInfo);
    }
}

