/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.messages;

import java.util.List;
import java.util.function.Function;
import mb.nabl2.constraints.messages.CompoundMessage;
import mb.nabl2.constraints.messages.DefaultMessage;
import mb.nabl2.constraints.messages.IMessageContent;
import mb.nabl2.constraints.messages.TermMessage;
import mb.nabl2.constraints.messages.TextMessage;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Function1;

public abstract class MessageContent
implements IMessageContent {
    private static final String TERM = "Term";
    private static final String TEXT = "Text";
    private static final String DEFAULT = "Default";
    private static final String FORMATTED = "Formatted";

    @Override
    public abstract MessageContent apply(Function1<ITerm, ITerm> var1);

    @Override
    public IMessageContent withDefault(IMessageContent defaultContent) {
        return this;
    }

    public static TermMatch.IMatcher<IMessageContent> matcher() {
        return TermMatch.M.cases(TermMatch.M.appl0(DEFAULT, t -> DefaultMessage.of()), TermMatch.M.appl1(FORMATTED, TermMatch.M.listElems(MessageContent.partMatcher()), (t, ps) -> CompoundMessage.of(ps)), TermMatch.M.string(s -> TextMessage.of(s.getValue())), MessageContent.partMatcher(), TermMatch.M.term(t -> CompoundMessage.of(ImList.Immutable.of(new IMessageContent[]{TermMessage.of(t), TextMessage.of(" (error message was malformed)")}))));
    }

    public static TermMatch.IMatcher<IMessageContent> partMatcher() {
        return TermMatch.M.cases(TermMatch.M.appl1(TEXT, TermMatch.M.stringValue(), (t, s) -> TextMessage.of(s)), TermMatch.M.appl1(TERM, TermMatch.M.term(), (t, s) -> TermMessage.of(s)));
    }

    public static MessageContent of(String text) {
        return TextMessage.of(text);
    }

    public static MessageContent of() {
        return DefaultMessage.of();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class ACompoundMessage
    extends MessageContent {
        ACompoundMessage() {
        }

        @Value.Parameter
        abstract ImList.Immutable<IMessageContent> getParts();

        @Override
        public ACompoundMessage apply(Function1<ITerm, ITerm> f) {
            return CompoundMessage.of(this.getParts().stream().map(p -> p.apply(f)).collect(ImList.Immutable.toImmutableList()));
        }

        @Override
        public IMessageContent withDefault(IMessageContent defaultContent) {
            return CompoundMessage.of(this.getParts().stream().map(p -> p.withDefault(defaultContent)).collect(ImList.Immutable.toImmutableList()));
        }

        @Override
        public ITerm build() {
            List parts = this.getParts().stream().map(IMessageContent::build).collect(ImList.Immutable.toImmutableList());
            return TermBuild.B.newAppl(MessageContent.FORMATTED, TermBuild.B.newList(parts));
        }

        @Override
        public String toString(Function<ITerm, String> pp) {
            StringBuilder sb = new StringBuilder();
            this.getParts().stream().forEach(p -> {
                StringBuilder stringBuilder2 = sb.append(p.toString(pp));
            });
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.getParts().stream().forEach(p -> {
                StringBuilder stringBuilder2 = sb.append(p.toString());
            });
            return sb.toString();
        }
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class ADefaultMessage
    extends MessageContent {
        ADefaultMessage() {
        }

        @Override
        public ADefaultMessage apply(Function1<ITerm, ITerm> f) {
            return this;
        }

        @Override
        public IMessageContent withDefault(IMessageContent defaultContent) {
            return defaultContent;
        }

        @Override
        public ITerm build() {
            return TermBuild.B.newAppl(MessageContent.DEFAULT, new ITerm[0]);
        }

        @Override
        public String toString(Function<ITerm, String> pp) {
            return this.toString();
        }

        public String toString() {
            return "(no message)";
        }
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class ATermMessage
    extends MessageContent {
        ATermMessage() {
        }

        @Value.Parameter
        abstract ITerm getTerm();

        @Override
        public ATermMessage apply(Function1<ITerm, ITerm> f) {
            return TermMessage.of(f.apply(this.getTerm()));
        }

        @Override
        public ITerm build() {
            return TermBuild.B.newAppl(MessageContent.TERM, this.getTerm());
        }

        @Override
        public String toString(Function<ITerm, String> pp) {
            return pp.apply(this.getTerm());
        }

        public String toString() {
            return this.getTerm().toString();
        }
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class ATextMessage
    extends MessageContent {
        ATextMessage() {
        }

        @Value.Parameter
        abstract String getText();

        @Override
        public ATextMessage apply(Function1<ITerm, ITerm> f) {
            return this;
        }

        @Override
        public ITerm build() {
            return TermBuild.B.newAppl(MessageContent.TEXT, TermBuild.B.newString(this.getText()));
        }

        @Override
        public String toString(Function<ITerm, String> pp) {
            return this.getText();
        }

        public String toString() {
            return this.getText();
        }
    }

    public static class Builder {
        private final ImList.Mutable<IMessageContent> parts = ImList.Mutable.of(new IMessageContent[0]);

        private Builder() {
        }

        public Builder append(String text) {
            this.parts.add(TextMessage.of(text));
            return this;
        }

        public Builder append(ITerm term) {
            this.parts.add(TermMessage.of(term));
            return this;
        }

        public Builder append(IMessageContent content) {
            this.parts.add(content);
            return this;
        }

        public MessageContent build() {
            return CompoundMessage.of(this.parts.freeze());
        }
    }
}

