/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.filter;

import oracle.pgx.api.filter.FilterType;
import oracle.pgx.api.filter.GraphFilterWithExpression;
import oracle.pgx.api.filter.internal.ResultSetVertexFilter;
import oracle.pgx.api.filter.internal.VertexCollectionFilter;
import oracle.pgx.common.IdentifiableResultSet;
import oracle.pgx.common.IdentifiableVertexCollection;

public class VertexFilter
extends GraphFilterWithExpression {
    public static final VertexFilter ALL = new VertexFilter("true");
    public static final VertexFilter NONE = new VertexFilter("false");

    public static VertexFilter fromExpression(String filterExpression) {
        return new VertexFilter(filterExpression);
    }

    public static VertexFilter fromPgqlResultSet(IdentifiableResultSet resultSet, String columnName) {
        return new ResultSetVertexFilter(resultSet, columnName);
    }

    public static VertexFilter fromCollection(IdentifiableVertexCollection vertexCollection) {
        return new VertexCollectionFilter(vertexCollection);
    }

    public VertexFilter(String filterExpression) {
        super(FilterType.VERTEX, filterExpression);
    }

    public String toString() {
        return "VertexFilter(\"" + this.getFilterExpression() + "\")";
    }

    @Override
    public VertexFilter asVertexFilter() {
        return this;
    }
}

