/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.pgx.api.FlashbackSynchronizer;
import oracle.pgx.api.GraphDelta;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.OnInvalidChange;

public interface Synchronizer {
    public void fetch() throws SQLException;

    public PgxGraph apply();

    public GraphDelta getGraphDelta();

    default public PgxGraph sync() throws SQLException {
        this.fetch();
        return this.apply();
    }

    public static class Builder<T extends Synchronizer> {
        private Class<T> type;
        private PgxGraph graph;
        private GraphConfig graphConfig;
        private Connection connection;
        private OnInvalidChange invalidChangePolicy = OnInvalidChange.ERROR;
        private Integer parallelHintDegree;

        public Builder<T> setType(Class<T> type) {
            this.type = type;
            return this;
        }

        public Builder<T> setInvalidChangePolicy(OnInvalidChange invalidChangePolicy) {
            this.invalidChangePolicy = invalidChangePolicy;
            return this;
        }

        public Builder<T> setGraph(PgxGraph graph) {
            this.graph = graph;
            return this;
        }

        public Builder<T> setGraphConfiguration(GraphConfig graphConfig) {
            this.graphConfig = graphConfig;
            return this;
        }

        public Builder<T> setConnection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public Builder<T> setParallelHintDegree(int parallelHintDegree) {
            this.parallelHintDegree = parallelHintDegree;
            return this;
        }

        public T build() {
            if (this.graph == null) {
                throw new IllegalArgumentException("graph not provided");
            }
            if (this.parallelHintDegree != null && this.type != FlashbackSynchronizer.class) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_TYPE", (Object[])new Object[]{this.type}));
            }
            if (this.type == FlashbackSynchronizer.class) {
                if (this.connection != null) {
                    if (this.graphConfig != null) {
                        return (T)new FlashbackSynchronizer(this.graph, this.invalidChangePolicy, this.graphConfig, this.connection, this.parallelHintDegree);
                    }
                    return (T)new FlashbackSynchronizer(this.graph, this.invalidChangePolicy, this.connection, this.parallelHintDegree);
                }
                if (this.graphConfig != null) {
                    return (T)new FlashbackSynchronizer(this.graph, this.invalidChangePolicy, this.graphConfig);
                }
                return (T)new FlashbackSynchronizer(this.graph, this.invalidChangePolicy);
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_TYPE", (Object[])new Object[]{this.type}));
        }
    }
}

