/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AnalysisTaskConfig;
import oracle.pgx.config.AnalysisTaskConfigBuilder;
import oracle.pgx.config.EnterpriseSchedulerConfig;

public final class EnterpriseSchedulerConfigBuilder {
    private final Map<EnterpriseSchedulerConfig.Field, Object> values = new HashMap<EnterpriseSchedulerConfig.Field, Object>();

    public static EnterpriseSchedulerConfig buildEnterpriseSchedulerConfig(Consumer<EnterpriseSchedulerConfigBuilder> builderSetup) {
        EnterpriseSchedulerConfigBuilder builder = new EnterpriseSchedulerConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public EnterpriseSchedulerConfigBuilder() {
    }

    public EnterpriseSchedulerConfigBuilder(Map<EnterpriseSchedulerConfig.Field, Object> values) {
        this.putAll(values);
    }

    public EnterpriseSchedulerConfigBuilder(EnterpriseSchedulerConfig config) {
        this.putAll(config);
    }

    public EnterpriseSchedulerConfigBuilder(EnterpriseSchedulerConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public EnterpriseSchedulerConfigBuilder putAll(Map<EnterpriseSchedulerConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public EnterpriseSchedulerConfigBuilder putAll(EnterpriseSchedulerConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public EnterpriseSchedulerConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public EnterpriseSchedulerConfig build(String parentPath) {
        try {
            return EnterpriseSchedulerConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public EnterpriseSchedulerConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<EnterpriseSchedulerConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "EnterpriseSchedulerConfigBuilder" + this.values;
    }

    public EnterpriseSchedulerConfigBuilder setNumIoThreadsPerTask(int numIoThreadsPerTask) {
        this.values.put(EnterpriseSchedulerConfig.Field.NUM_IO_THREADS_PER_TASK, numIoThreadsPerTask);
        return this;
    }

    public EnterpriseSchedulerConfigBuilder setMaxNumConcurrentIoTasks(int maxNumConcurrentIoTasks) {
        this.values.put(EnterpriseSchedulerConfig.Field.MAX_NUM_CONCURRENT_IO_TASKS, maxNumConcurrentIoTasks);
        return this;
    }

    public EnterpriseSchedulerConfigBuilder setAnalysisTaskConfig(AnalysisTaskConfig analysisTaskConfig) {
        this.values.put(EnterpriseSchedulerConfig.Field.ANALYSIS_TASK_CONFIG, analysisTaskConfig);
        return this;
    }

    public EnterpriseSchedulerConfigBuilder setAnalysisTaskConfig(Consumer<AnalysisTaskConfigBuilder> analysisTaskConfigBuilderSetup) {
        AnalysisTaskConfigBuilder builder = new AnalysisTaskConfigBuilder();
        analysisTaskConfigBuilderSetup.accept(builder);
        this.setAnalysisTaskConfig(builder.build());
        return this;
    }

    public EnterpriseSchedulerConfigBuilder setFastAnalysisTaskConfig(AnalysisTaskConfig fastAnalysisTaskConfig) {
        this.values.put(EnterpriseSchedulerConfig.Field.FAST_ANALYSIS_TASK_CONFIG, fastAnalysisTaskConfig);
        return this;
    }

    public EnterpriseSchedulerConfigBuilder setFastAnalysisTaskConfig(Consumer<AnalysisTaskConfigBuilder> fastAnalysisTaskConfigBuilderSetup) {
        AnalysisTaskConfigBuilder builder = new AnalysisTaskConfigBuilder();
        fastAnalysisTaskConfigBuilderSetup.accept(builder);
        this.setFastAnalysisTaskConfig(builder.build());
        return this;
    }
}

