/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import oracle.pgx.common.util.ExperimentLabeler;
import oracle.pgx.config.RuntimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopWatch {
    private static final Logger LOG = LoggerFactory.getLogger(StopWatch.class);
    private static ExperimentLabeler labeler = null;
    private final String tag;
    private final TimeUnit destUnit;
    private final Queue<TimePoint> timePoints = new LinkedList<TimePoint>();
    private TimePoint startTimePoint;
    private TimePoint endTimePoint;
    private TimePoint lastTimePoint;
    private boolean giveLiveResults = true;
    private boolean printSummary = false;
    private boolean printTotal = true;
    private boolean highlight = false;

    @Inject
    public static void init(RuntimeConfig runtimeConfig) {
        labeler = ExperimentLabeler.getExperimentLabeler(runtimeConfig).orElse(null);
    }

    public StopWatch(String tag, TimeUnit destUnit) {
        this.tag = tag;
        this.destUnit = destUnit;
    }

    public StopWatch(String tag) {
        this(tag, TimeUnit.MILLISECONDS);
    }

    public StopWatch() {
        this("Anonymous timer");
    }

    public static StopWatch startLiveWatch(String tag) {
        StopWatch stopWatch = new StopWatch(tag);
        stopWatch.start();
        return stopWatch;
    }

    public static StopWatch startSummaryWatch(String tag) {
        StopWatch stopWatch = new StopWatch(tag);
        stopWatch.setGiveLiveResults(false);
        stopWatch.setPrintSummary(true);
        stopWatch.start();
        return stopWatch;
    }

    public static StopWatch startTotalWatch(String tag) {
        StopWatch stopWatch = new StopWatch(tag);
        stopWatch.setGiveLiveResults(false);
        stopWatch.setPrintSummary(false);
        stopWatch.start();
        return stopWatch;
    }

    public static StopWatch startQuietWatch(String tag) {
        StopWatch stopWatch = new StopWatch(tag);
        stopWatch.setGiveLiveResults(false);
        stopWatch.setPrintSummary(false);
        stopWatch.setPrintTotal(false);
        stopWatch.start();
        return stopWatch;
    }

    public static StopWatch startVerboseWatch(String tag) {
        StopWatch stopWatch = new StopWatch(tag);
        stopWatch.setGiveLiveResults(true);
        stopWatch.setPrintSummary(true);
        stopWatch.start();
        return stopWatch;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public boolean doesPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public boolean givesLiveResults() {
        return this.giveLiveResults;
    }

    public void setGiveLiveResults(boolean giveLiveResults) {
        this.giveLiveResults = giveLiveResults;
    }

    public boolean doesPrintTotal() {
        return this.printTotal;
    }

    public void setPrintTotal(boolean printTotal) {
        this.printTotal = printTotal;
    }

    public boolean isStarted() {
        return this.startTimePoint != null;
    }

    public boolean isStopped() {
        return this.endTimePoint != null;
    }

    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("StopWatch already started.");
        }
        this.lastTimePoint = this.startTimePoint = TimePoint.now("start");
        this.addTimePoint(this.startTimePoint);
    }

    public void splitAndStop(String tag) {
        if (this.isStopped()) {
            throw new IllegalStateException("StopWatch already stopped.");
        }
        this.endTimePoint = TimePoint.now(tag);
        this.addTimePoint(this.endTimePoint);
        long totalTime = this.startTimePoint.durationTo(this.endTimePoint);
        if (this.printSummary && this.timePoints.size() > 2) {
            TimePoint lastTimePoint = this.startTimePoint;
            for (TimePoint tp : this.timePoints) {
                this.outputTimePointDiff(tp, lastTimePoint, totalTime);
                lastTimePoint = tp;
            }
        }
        if (this.printTotal) {
            this.outputTotal();
        }
    }

    public void stop() {
        this.splitAndStop("(remaining)");
    }

    private long convertToDestUnit(long duration) {
        return this.destUnit.convert(duration, TimeUnit.NANOSECONDS);
    }

    private void addTimePoint(TimePoint tp) {
        if (labeler != null) {
            this.setErLabel(tp);
        }
        if (this.giveLiveResults) {
            this.outputTimePointDiff(tp, this.lastTimePoint);
        }
        this.lastTimePoint = tp;
        this.timePoints.add(tp);
    }

    private void setErLabel(TimePoint tp) {
        if (tp == this.startTimePoint) {
            labeler.startLabel(this.tag + "_" + this.timePoints.size());
            return;
        }
        labeler.stopLabel(this.tag + "_" + (this.timePoints.size() - 1), "Tag: " + tp.tag);
        if (tp != this.endTimePoint) {
            labeler.startLabel(this.tag + "_" + this.timePoints.size());
        }
    }

    private String getHighlightString() {
        return this.highlight ? "=========> " : "";
    }

    private void outputTimePointDiff(TimePoint timePoint, TimePoint lastTimePoint, long totalTime) {
        long duration = lastTimePoint.durationTo(timePoint);
        LOG.debug("{}{} - {} : {} ({}%)", new Object[]{this.getHighlightString(), this.tag, timePoint.tag, this.convertToDestUnit(duration), duration * 100L / totalTime});
    }

    private void outputTimePointDiff(TimePoint timePoint, TimePoint lastTimePoint) {
        long duration = lastTimePoint.durationTo(timePoint);
        LOG.debug("{}{} - {} : {}", new Object[]{this.getHighlightString(), this.tag, timePoint.tag, this.convertToDestUnit(duration)});
    }

    private void outputTotal() {
        LOG.debug("{}{} - (total) : {}", new Object[]{this.getHighlightString(), this.tag, this.convertToDestUnit(this.startTimePoint.durationTo(this.endTimePoint))});
    }

    public void split(String tag) {
        this.addTimePoint(TimePoint.now(tag));
    }

    public void split() {
        this.split("Split point " + this.timePoints.size());
    }

    public long differenceBetween(String startTag, String endTag, TimeUnit timeUnit) {
        TimePoint start = this.findTimePointByTag(startTag);
        TimePoint end = this.findTimePointByTag(endTag);
        long duration = start.durationTo(end);
        return timeUnit.convert(duration, TimeUnit.NANOSECONDS);
    }

    public long differenceBetween(String startTag, String endTag) {
        return this.differenceBetween(startTag, endTag, this.destUnit);
    }

    private long differenceBetween(TimePoint startTimePoint, TimePoint endTimePoint) {
        return this.differenceBetween(startTimePoint.tag, endTimePoint.tag, this.destUnit);
    }

    public void logDifferenceBetween(String startTag, String endTag) {
        TimePoint start = this.findTimePointByTag(startTag);
        TimePoint end = this.findTimePointByTag(endTag);
        long duration = start.durationTo(end);
        LOG.debug("{}{} - [{} - {}] : {}", new Object[]{this.getHighlightString(), this.tag, startTag, endTag, this.convertToDestUnit(duration)});
    }

    public void logDifferenceBetween(String startTag, String endTag, String messageTemplate) {
        TimePoint start = this.findTimePointByTag(startTag);
        TimePoint end = this.findTimePointByTag(endTag);
        long duration = start.durationTo(end);
        LOG.debug(messageTemplate, (Object)this.convertToDestUnit(duration));
    }

    public void printTimepointsAsTable() {
        LOG.debug("Printing \"StopWatch\" Table");
        LOG.debug("\tTag\t|\tDuration");
        TimePoint lastTimePoint = this.timePoints.element();
        for (TimePoint timePoint : this.timePoints) {
            LOG.debug("---------------------------------");
            LOG.debug("\t{}\t|\t{}", (Object)timePoint.tag, (Object)this.differenceBetween(lastTimePoint, timePoint));
            lastTimePoint = timePoint;
        }
    }

    public void exportCsv(OutputStream stream) throws IOException {
        try (PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(stream), false, StandardCharsets.UTF_8.name());){
            printStream.println("\"stopwatch tag\", \"timepoint tag\", \"duration\", \"percentage\"");
            Optional<Long> totalTime = Optional.ofNullable(this.endTimePoint).map(this.startTimePoint::durationTo);
            TimePoint lastTimePoint = this.startTimePoint;
            for (TimePoint timePoint : this.timePoints) {
                long duration = lastTimePoint.durationTo(timePoint);
                printStream.printf("\"%s\", \"%s\", %d", this.tag, timePoint.tag, this.destUnit.convert(duration, TimeUnit.NANOSECONDS));
                totalTime.ifPresent(time -> printStream.printf(", %d", duration * 100L / time));
                printStream.println();
                lastTimePoint = timePoint;
            }
            totalTime.ifPresent(time -> printStream.printf("\"%s\", \"%s\", %d, 100", this.tag, "(total)", this.destUnit.convert((long)time, TimeUnit.NANOSECONDS)));
        }
    }

    public void exportCsv(Path outputPath) throws IOException {
        try (OutputStream stream = Files.newOutputStream(outputPath, new OpenOption[0]);){
            this.exportCsv(stream);
        }
    }

    private TimePoint findTimePointByTag(String tag) {
        for (TimePoint point : this.timePoints) {
            if (!Objects.equals(point.tag, tag)) continue;
            return point;
        }
        throw new IllegalArgumentException("Tag " + tag + " not found");
    }

    private static class TimePoint {
        public final long time;
        public final String tag;

        public TimePoint(long time, String tag) {
            this.time = time;
            this.tag = tag;
        }

        public static TimePoint now(String tag) {
            return new TimePoint(System.nanoTime(), tag);
        }

        public long durationTo(TimePoint tp) {
            return tp.time - this.time;
        }
    }
}

