/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.AlgorithmIdentifierException;
import oracle.security.pki.internal.core.JCEPBE;
import oracle.security.pki.internal.core.PBEAlgorithmIdentifier;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class KeyWrapper {
    private AlgorithmIdentifier a;
    private ASN1Object b;
    private PublicKey c;
    private PrivateKey d;
    private JCEPBE e;
    private String f;
    private byte[] g;

    public void initialize(String string, Key key) throws IOException {
        this.initialize(string, key.getAlgorithm(), new ByteArrayInputStream(key.getEncoded()));
    }

    public void initialize(String string, String string2, InputStream inputStream) throws IOException {
        if (inputStream == null || string2 == null) {
            throw new IOException("Either InputStream or key algorithm is missing");
        }
        if (string != "Public" && string != "Private") {
            throw new IOException("Key type not passed - should be either Public or Private");
        }
        if (string.equals("Public")) {
            if (string2.equals("EC")) {
                this.d(inputStream);
            } else {
                this.b(inputStream);
            }
        } else if (string.equals("Private")) {
            if (string2.equals("EC")) {
                this.c(inputStream);
            } else {
                this.a(inputStream);
            }
        } else {
            throw new IOException("Failed to initialize KeyWrapper object - Key type not valid");
        }
    }

    public AlgorithmIdentifier getAlgID() {
        return this.a;
    }

    public Key getKey() {
        if (this.c != null) {
            return this.c;
        }
        return this.d;
    }

    public ASN1Object getContents() {
        return this.b;
    }

    public void setPassword(String string) {
        this.f = string;
    }

    public void initializeRSAPrivateKeyFromContents(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
        ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.a(0);
        if (!aSN1Integer.a(0)) {
            throw new IOException("Error in generation of KeyWrapper object. Version should be 0");
        }
        this.a = algorithmIdentifier;
        this.b = aSN1Object;
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.a(1)).c();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.a(3)).c();
        BigInteger bigInteger3 = ((ASN1Integer)aSN1Sequence.a(2)).c();
        BigInteger bigInteger4 = ((ASN1Integer)aSN1Sequence.a(4)).c();
        BigInteger bigInteger5 = ((ASN1Integer)aSN1Sequence.a(5)).c();
        BigInteger bigInteger6 = ((ASN1Integer)aSN1Sequence.a(6)).c();
        BigInteger bigInteger7 = ((ASN1Integer)aSN1Sequence.a(7)).c();
        BigInteger bigInteger8 = ((ASN1Integer)aSN1Sequence.a(8)).c();
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger3, bigInteger2, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            this.d = (RSAPrivateCrtKey)keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }
        catch (Exception exception) {
            throw new IOException("Failed to create RSA Private key");
        }
    }

    private void a(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence;
        try {
            aSN1Sequence = new ASN1Sequence(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException("Failed to create RSA Private key");
        }
        if (aSN1Sequence.c() == 3 || aSN1Sequence.c() == 4) {
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.a(0);
            if (!aSN1Integer.a(0)) {
                throw new IOException("Error in generation of KeyWrapper object. Version should be 0");
            }
            try {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.a(1));
                ASN1Object aSN1Object = ASN1Utils.a(((ASN1OctetString)aSN1Sequence.a(2)).b());
                this.initializeRSAPrivateKeyFromContents(algorithmIdentifier, aSN1Object);
            }
            catch (IOException iOException) {
                throw new IOException("Failed to create RSA Private key");
            }
        } else if (aSN1Sequence.c() == 9) {
            this.initializeRSAPrivateKeyFromContents(null, aSN1Sequence);
        } else {
            throw new IOException("Invalid size of arguments");
        }
    }

    public void initializeRSAPublicKeyFromContents(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws IOException {
        this.a = algorithmIdentifier;
        this.b = aSN1Object;
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.a(0)).c();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.a(1)).c();
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            this.c = KeyFactory.getInstance("RSA").generatePublic(rSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new IOException("Failed to create RSA Public key");
        }
    }

    private void b(InputStream inputStream) throws IOException {
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            if (aSN1Sequence.c() != 2) {
                throw new IOException("Sequence has wrong number of components.");
            }
            if (aSN1Sequence.a(0) instanceof ASN1Integer) {
                this.a = null;
                this.b = aSN1Sequence;
                this.initializeRSAPublicKeyFromContents(null, aSN1Sequence);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.a(0));
                ASN1Object aSN1Object = ASN1Utils.a(((ASN1BitString)aSN1Sequence.a(1)).b());
                this.a = algorithmIdentifier;
                this.b = aSN1Object;
                this.initializeRSAPublicKeyFromContents(algorithmIdentifier, aSN1Object);
            }
        }
        catch (Exception exception) {
            throw new IOException("Failed to create RSA Public key");
        }
    }

    public void initializeECPrivateKeyFromContents(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws IOException {
        try {
            this.a = algorithmIdentifier;
            this.b = aSN1Object;
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(new ASN1Integer(0L));
            aSN1Sequence.a(algorithmIdentifier);
            aSN1Sequence.a(aSN1Object);
            this.d = CryptoUtils.generateECPrivateKeyFromBytes(Utils.toBytes(aSN1Sequence));
        }
        catch (Exception exception) {
            throw new IOException("Failed to create EC Private key");
        }
    }

    private void c(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = new ASN1Sequence(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException("Failed to create EC Private key");
        }
        try {
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.a(0);
            if (!aSN1Integer.a(0)) {
                throw new IOException("Error in generation of KeyWrapper object. Version should be 0");
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.a(1));
            ASN1Object aSN1Object = aSN1Sequence.a(2);
            if (!AlgID.v.a().equals(algorithmIdentifier.a())) {
                throw new AlgorithmIdentifierException("Wrong algorithm identifier for EC key.");
            }
            this.initializeECPrivateKeyFromContents(algorithmIdentifier, aSN1Object);
        }
        catch (Exception exception) {
            throw new IOException("Failed to create EC Private key");
        }
    }

    public void initializeECPublicKeyFromContents(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws IOException {
        try {
            this.a = algorithmIdentifier;
            this.b = aSN1Object;
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.a);
            aSN1Sequence.a(this.b);
            this.c = CryptoUtils.generateECPublicKeyFromBytes(Utils.toBytes(aSN1Sequence));
        }
        catch (Exception exception) {
            throw new IOException("Failed to create EC Public key");
        }
    }

    private void d(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence;
        try {
            aSN1Sequence = new ASN1Sequence(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException("Failed to create EC Public key");
        }
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.a(0));
            ASN1Object aSN1Object = aSN1Sequence.a(1);
            if (!AlgID.v.a().equals(algorithmIdentifier.a())) {
                throw new AlgorithmIdentifierException("Wrong algorithm identifier for EC key.");
            }
            this.initializeECPublicKeyFromContents(algorithmIdentifier, aSN1Object);
        }
        catch (Exception exception) {
            throw new IOException("Failed to create EC Public key");
        }
    }

    public void initializePKCS8Key(int n, InputStream inputStream) throws IOException, AlgorithmIdentifierException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(aSN1SequenceInputStream);
        if (this.e == null) {
            this.e = new JCEPBE();
        }
        this.e.a(n, pBEAlgorithmIdentifier);
        this.g = ASN1OctetString.a(aSN1SequenceInputStream);
        aSN1SequenceInputStream.b();
        this.d = null;
        this.b = null;
    }

    public ASN1Sequence getPKCS8Contents() throws IOException {
        if (this.e == null) {
            throw new StreamableOutputException("No Password Based Encryption created");
        }
        if (this.d == null || this.f == null) {
            throw new StreamableOutputException("Private key or password is null");
        }
        byte[] byArray = null;
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(this.e.a());
        try {
            byArray = this.e.a(this.f, this.d);
        }
        catch (Exception exception) {
            throw new IOException("Failed to decrypt key");
        }
        aSN1Sequence.a(new ASN1OctetString(byArray));
        return aSN1Sequence;
    }

    public PrivateKey getDecryptedPKCS8Key() {
        PrivateKey privateKey;
        try {
            if (this.e == null) {
                this.e = new JCEPBE();
            }
            privateKey = this.e.a(this.f, this.g);
        }
        catch (Exception exception) {
            return null;
        }
        return privateKey;
    }
}

