/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.AlgorithmIdentifierException;
import oracle.security.pki.internal.core.CBCAlgorithmIdentifier;
import oracle.security.pki.util.KeyWrapper;
import oracle.security.pki.util.OIDManager;
import oracle.security.pki.util.Utils;

public class CryptoUtils {
    private static final int a = 0;
    private static final int b = 1;
    private static final int c = 2;

    public static PublicKey inputSPKI(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.a(0));
        PublicKey publicKey = null;
        KeyWrapper keyWrapper = new KeyWrapper();
        ASN1Object aSN1Object = null;
        aSN1Object = algorithmIdentifier.a().equals(AlgID.v.a()) ? aSN1Sequence.a(1) : ASN1Utils.a(new ByteArrayInputStream(((ASN1BitString)aSN1Sequence.a(1)).b()));
        if (OIDManager.getKeyAlgoFromOIDMap(algorithmIdentifier.a()).equals("RSA")) {
            keyWrapper.initializeRSAPublicKeyFromContents(algorithmIdentifier, aSN1Object);
            publicKey = (RSAPublicKey)keyWrapper.getKey();
        } else if (OIDManager.getKeyAlgoFromOIDMap(algorithmIdentifier.a()).equals("EC")) {
            keyWrapper.initializeECPublicKeyFromContents(algorithmIdentifier, aSN1Object);
            publicKey = (ECPublicKey)keyWrapper.getKey();
        } else {
            return null;
        }
        return publicKey;
    }

    public static PrivateKey inputPrivateKey(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        ASN1Sequence aSN1Sequence;
        block54: {
            aSN1Sequence = new ASN1Sequence(inputStream);
            object3 = null;
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.a(0);
            if (!aSN1Integer.a(0)) {
                throw new IOException("Error in inputPrivateKey. Version should be 0");
            }
            AlgorithmIdentifier algorithmIdentifier = null;
            if (aSN1Sequence.c() == 9) {
                algorithmIdentifier = AlgID.e;
                object3 = aSN1Sequence;
            } else if (aSN1Sequence.c() == 5) {
                algorithmIdentifier = AlgID.D;
                object3 = aSN1Sequence;
            } else {
                algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.a(1));
                object2 = aSN1Sequence.a(2);
                if (algorithmIdentifier.a().equals(AlgID.v.a())) {
                    object3 = object2;
                } else if (object2 instanceof ASN1OctetString) {
                    object3 = ASN1Utils.a(new ByteArrayInputStream(((ASN1OctetString)object2).b()));
                } else if (object2 instanceof ASN1Sequence) {
                    object3 = object2;
                } else {
                    throw new IOException("Invalid private key contents");
                }
            }
            object2 = null;
            KeyWrapper keyWrapper = new KeyWrapper();
            if (OIDManager.getKeyAlgoFromOIDMap(algorithmIdentifier.a()).equals("RSA")) {
                keyWrapper.initializeRSAPrivateKeyFromContents(algorithmIdentifier, (ASN1Object)object3);
                object2 = (RSAPrivateKey)keyWrapper.getKey();
                break block54;
            }
            if (OIDManager.getKeyAlgoFromOIDMap(algorithmIdentifier.a()).equals("EC")) {
                keyWrapper.initializeECPrivateKeyFromContents(algorithmIdentifier, (ASN1Object)object3);
                object2 = (ECPrivateKey)keyWrapper.getKey();
                break block54;
            }
            PrivateKey privateKey = null;
            if (aSN1Sequence.c() == 9) {
                ((ASN1Integer)aSN1Sequence.a(3)).b();
                ((ASN1Integer)aSN1Sequence.a(4)).b();
                ((ASN1Integer)aSN1Sequence.a(5)).b();
                ((ASN1Integer)aSN1Sequence.a(6)).b();
                ((ASN1Integer)aSN1Sequence.a(7)).b();
                ((ASN1Integer)aSN1Sequence.a(8)).b();
            } else if (aSN1Sequence.c() == 5) {
                ((ASN1Integer)aSN1Sequence.a(3)).b();
            } else {
                if (aSN1Sequence.a(2) instanceof ASN1OctetString) {
                    Utils.setArray(((ASN1OctetString)aSN1Sequence.a(2)).b(), (byte)0);
                }
                if (object3 != null) {
                    if (object3 instanceof ASN1Sequence) {
                        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)object3;
                        if (aSN1Sequence2.c() == 9) {
                            ((ASN1Integer)aSN1Sequence2.a(3)).b();
                            ((ASN1Integer)aSN1Sequence2.a(4)).b();
                            ((ASN1Integer)aSN1Sequence2.a(5)).b();
                            ((ASN1Integer)aSN1Sequence2.a(6)).b();
                            ((ASN1Integer)aSN1Sequence2.a(7)).b();
                            ((ASN1Integer)aSN1Sequence2.a(8)).b();
                        } else if (aSN1Sequence2.c() == 5) {
                            ((ASN1Integer)aSN1Sequence2.a(3)).b();
                        }
                    } else if (object3 instanceof ASN1Integer) {
                        ((ASN1Integer)object3).b();
                    }
                }
            }
            return privateKey;
        }
        try {
            object = object2;
        }
        catch (ClassCastException classCastException) {
            try {
                throw new IOException("Class does not implement PrivateKey");
            }
            catch (Throwable throwable) {
                if (aSN1Sequence.c() == 9) {
                    ((ASN1Integer)aSN1Sequence.a(3)).b();
                    ((ASN1Integer)aSN1Sequence.a(4)).b();
                    ((ASN1Integer)aSN1Sequence.a(5)).b();
                    ((ASN1Integer)aSN1Sequence.a(6)).b();
                    ((ASN1Integer)aSN1Sequence.a(7)).b();
                    ((ASN1Integer)aSN1Sequence.a(8)).b();
                } else if (aSN1Sequence.c() == 5) {
                    ((ASN1Integer)aSN1Sequence.a(3)).b();
                } else {
                    if (aSN1Sequence.a(2) instanceof ASN1OctetString) {
                        Utils.setArray(((ASN1OctetString)aSN1Sequence.a(2)).b(), (byte)0);
                    }
                    if (object3 != null) {
                        if (object3 instanceof ASN1Sequence) {
                            Object object4 = object3;
                            if (((ASN1Sequence)object4).c() == 9) {
                                ((ASN1Integer)((ASN1Sequence)object4).a(3)).b();
                                ((ASN1Integer)((ASN1Sequence)object4).a(4)).b();
                                ((ASN1Integer)((ASN1Sequence)object4).a(5)).b();
                                ((ASN1Integer)((ASN1Sequence)object4).a(6)).b();
                                ((ASN1Integer)((ASN1Sequence)object4).a(7)).b();
                                ((ASN1Integer)((ASN1Sequence)object4).a(8)).b();
                            } else if (((ASN1Sequence)object4).c() == 5) {
                                ((ASN1Integer)((ASN1Sequence)object4).a(3)).b();
                            }
                        } else if (object3 instanceof ASN1Integer) {
                            ((ASN1Integer)object3).b();
                        }
                    }
                }
                throw throwable;
            }
        }
        if (aSN1Sequence.c() == 9) {
            ((ASN1Integer)aSN1Sequence.a(3)).b();
            ((ASN1Integer)aSN1Sequence.a(4)).b();
            ((ASN1Integer)aSN1Sequence.a(5)).b();
            ((ASN1Integer)aSN1Sequence.a(6)).b();
            ((ASN1Integer)aSN1Sequence.a(7)).b();
            ((ASN1Integer)aSN1Sequence.a(8)).b();
        } else if (aSN1Sequence.c() == 5) {
            ((ASN1Integer)aSN1Sequence.a(3)).b();
        } else {
            if (aSN1Sequence.a(2) instanceof ASN1OctetString) {
                Utils.setArray(((ASN1OctetString)aSN1Sequence.a(2)).b(), (byte)0);
            }
            if (object3 != null) {
                if (object3 instanceof ASN1Sequence) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)object3;
                    if (aSN1Sequence3.c() == 9) {
                        ((ASN1Integer)aSN1Sequence3.a(3)).b();
                        ((ASN1Integer)aSN1Sequence3.a(4)).b();
                        ((ASN1Integer)aSN1Sequence3.a(5)).b();
                        ((ASN1Integer)aSN1Sequence3.a(6)).b();
                        ((ASN1Integer)aSN1Sequence3.a(7)).b();
                        ((ASN1Integer)aSN1Sequence3.a(8)).b();
                    } else if (aSN1Sequence3.c() == 5) {
                        ((ASN1Integer)aSN1Sequence3.a(3)).b();
                    }
                } else if (object3 instanceof ASN1Integer) {
                    ((ASN1Integer)object3).b();
                }
            }
        }
        return object;
    }

    public static byte[] generateKeyID(PublicKey publicKey) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(publicKey.getEncoded());
        return messageDigest.digest();
    }

    public static ASN1Sequence subjectPublicKeyInfo(KeyWrapper keyWrapper) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(keyWrapper.getAlgID());
        if (keyWrapper.getAlgID().a().equals(AlgID.v.a())) {
            aSN1Sequence.a(keyWrapper.getContents());
        } else {
            aSN1Sequence.a(new ASN1BitString(Utils.toBytes(keyWrapper.getContents())));
        }
        return aSN1Sequence;
    }

    public static byte[] getIV(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier instanceof CBCAlgorithmIdentifier) {
            return ((CBCAlgorithmIdentifier)algorithmIdentifier).c();
        }
        CBCAlgorithmIdentifier cBCAlgorithmIdentifier = new CBCAlgorithmIdentifier(algorithmIdentifier.a(), algorithmIdentifier.b());
        return cBCAlgorithmIdentifier.c();
    }

    public static Signature getSignatureInstance(String string, Key key) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (key.getClass().getName().contains("Luna")) {
            return Signature.getInstance(string, "LunaJCAProvider");
        }
        return Signature.getInstance(string);
    }

    public static Cipher getCipherInstance(Key key, String string) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        if (key.getClass().getName().contains("Luna")) {
            return Cipher.getInstance(string, "LunaJCEProvider");
        }
        return Cipher.getInstance(string);
    }

    public static AlgorithmParameterSpec getOEPAlgoSpec(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, PSource pSource, Key key) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InstantiationException, InvocationTargetException {
        if (key.getClass().getName().contains("Luna")) {
            Class<?> clazz = Class.forName("com.chrysalisits.crypto.LunaParameterSpecOAEP");
            Class[] classArray = new Class[]{String.class, Integer.TYPE, Integer.TYPE, byte[].class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            byte[] byArray = ((PSource.PSpecified)pSource).getValue() != null ? ((PSource.PSpecified)pSource).getValue() : new byte[]{};
            Object[] objectArray = new Object[]{"SHA1", clazz.getDeclaredField("mgfType_MGF1").get(null), clazz.getDeclaredField("sourceType_DATA_SPECIFIED").get(null), byArray};
            return (AlgorithmParameterSpec)constructor.newInstance(objectArray);
        }
        return new OAEPParameterSpec(string, string2, algorithmParameterSpec, pSource);
    }

    public static String searchServiceProvider(String string, String string2) {
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                if (service.getType() != string || service.getAlgorithm() != string2) continue;
                return String.valueOf(provider.getName());
            }
        }
        return null;
    }

    public static String getCipherTransformation(AlgorithmIdentifier algorithmIdentifier, boolean bl) {
        if (algorithmIdentifier != null) {
            ASN1ObjectID aSN1ObjectID = algorithmIdentifier.a();
            if (aSN1ObjectID.equals(AlgID.b.a())) {
                if (bl) {
                    return "DES/CBC/PKCS5Padding";
                }
                return "DES/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.a.a())) {
                if (bl) {
                    return "DES/ECB/PKCS5Padding";
                }
                return "DES/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.d.a())) {
                if (bl) {
                    return "DESede/CBC/PKCS5Padding";
                }
                return "DESede/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.c.a())) {
                if (bl) {
                    return "DESede/ECB/PKCS5Padding";
                }
                return "DESede/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.m.a()) || aSN1ObjectID.equals(AlgID.o.a()) || aSN1ObjectID.equals(AlgID.q.a())) {
                if (bl) {
                    return "AES/CBC/PKCS5Padding";
                }
                return "AES/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.l.a()) || aSN1ObjectID.equals(AlgID.n.a()) || aSN1ObjectID.equals(AlgID.p.a())) {
                if (bl) {
                    return "AES/ECB/PKCS5Padding";
                }
                return "AES/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.g.a())) {
                if (bl) {
                    return "RC2/CBC/PKCS5Padding";
                }
                return "RC2/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.h.a())) {
                if (bl) {
                    return "RC4/CBC/PKCS5Padding";
                }
                return "RC4/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.j.a())) {
                if (bl) {
                    return "Blowfish/ECB/PKCS5Padding";
                }
                return "Blowfish/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.k.a())) {
                if (bl) {
                    return "Blowfish/CBC/PKCS5Padding";
                }
                return "Blowfish/CBC/NoPadding";
            }
            return null;
        }
        return null;
    }

    public static String getEncryptionAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier != null) {
            ASN1ObjectID aSN1ObjectID = algorithmIdentifier.a();
            if (aSN1ObjectID.equals(AlgID.b.a()) || aSN1ObjectID.equals(AlgID.a.a())) {
                return "DES";
            }
            if (aSN1ObjectID.equals(AlgID.d.a()) || aSN1ObjectID.equals(AlgID.c.a())) {
                return "DESede";
            }
            if (aSN1ObjectID.equals(AlgID.m.a()) || aSN1ObjectID.equals(AlgID.l.a()) || aSN1ObjectID.equals(AlgID.o.a()) || aSN1ObjectID.equals(AlgID.n.a()) || aSN1ObjectID.equals(AlgID.q.a()) || aSN1ObjectID.equals(AlgID.p.a())) {
                return "AES";
            }
            if (aSN1ObjectID.equals(AlgID.h.a())) {
                return "RC4";
            }
            if (aSN1ObjectID.equals(AlgID.i.a()) || aSN1ObjectID.equals(AlgID.k.a()) || aSN1ObjectID.equals(AlgID.j.a())) {
                return "Blowfish";
            }
            if (aSN1ObjectID.equals(AlgID.g.a())) {
                return "RC2";
            }
            return algorithmIdentifier.toString();
        }
        return null;
    }

    public static String getHmacAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.P) || algorithmIdentifier.equals(AlgID.N) || algorithmIdentifier.equals(AlgID.O) || algorithmIdentifier.equals(AlgID.V) || algorithmIdentifier.equals(AlgID.W)) {
            string = "HmacSHA1";
        } else if (algorithmIdentifier.equals(AlgID.K) || algorithmIdentifier.equals(AlgID.U)) {
            string = "HmacMD5";
        } else if (algorithmIdentifier.equals(AlgID.Q) || algorithmIdentifier.equals(AlgID.X)) {
            string = "HmacSHA224";
        } else if (algorithmIdentifier.equals(AlgID.R) || algorithmIdentifier.equals(AlgID.Y)) {
            string = "HmacSHA256";
        } else if (algorithmIdentifier.equals(AlgID.S) || algorithmIdentifier.equals(AlgID.Z)) {
            string = "HmacSHA384";
        } else if (algorithmIdentifier.equals(AlgID.T) || algorithmIdentifier.equals(AlgID.aa)) {
            string = "HmacSHA512";
        }
        return string;
    }

    public static String getDigestAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.P) || algorithmIdentifier.equals(AlgID.N) || algorithmIdentifier.equals(AlgID.O) || algorithmIdentifier.equals(AlgID.V) || algorithmIdentifier.equals(AlgID.W)) {
            string = "SHA-1";
        } else if (algorithmIdentifier.equals(AlgID.K) || algorithmIdentifier.equals(AlgID.U)) {
            string = "MD5";
        } else if (algorithmIdentifier.equals(AlgID.M)) {
            string = "MD2";
        } else if (algorithmIdentifier.equals(AlgID.Q) || algorithmIdentifier.equals(AlgID.X)) {
            string = "SHA-224";
        } else if (algorithmIdentifier.equals(AlgID.R) || algorithmIdentifier.equals(AlgID.Y)) {
            string = "SHA-256";
        } else if (algorithmIdentifier.equals(AlgID.S) || algorithmIdentifier.equals(AlgID.Z)) {
            string = "SHA-384";
        } else if (algorithmIdentifier.equals(AlgID.T) || algorithmIdentifier.equals(AlgID.aa)) {
            string = "SHA-512";
        }
        return string;
    }

    public static int getHashAlgoBlockSize(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier == AlgID.N || algorithmIdentifier == AlgID.O || algorithmIdentifier == AlgID.P || algorithmIdentifier == AlgID.R) {
            return 64;
        }
        if (algorithmIdentifier == AlgID.S || algorithmIdentifier == AlgID.T) {
            return 128;
        }
        if (algorithmIdentifier == AlgID.K || algorithmIdentifier == AlgID.L || algorithmIdentifier == AlgID.M) {
            return 64;
        }
        return 0;
    }

    public static String getSignatureAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.w)) {
            string = "MD2withRSA";
        } else if (algorithmIdentifier.equals(AlgID.x)) {
            string = "MD5withRSA";
        } else if (algorithmIdentifier.equals(AlgID.y)) {
            string = "SHA1withRSA";
        } else if (algorithmIdentifier.equals(AlgID.z)) {
            string = "SHA224withRSA";
        } else if (algorithmIdentifier.equals(AlgID.A)) {
            string = "SHA256withRSA";
        } else if (algorithmIdentifier.equals(AlgID.B)) {
            string = "SHA384withRSA";
        } else if (algorithmIdentifier.equals(AlgID.C)) {
            string = "SHA512withRSA";
        } else if (algorithmIdentifier.equals(AlgID.D)) {
            string = "SHA1withDSA";
        } else if (algorithmIdentifier.equals(AlgID.G)) {
            string = "SHA1withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.H)) {
            string = "SHA256withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.I)) {
            string = "SHA384withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.J)) {
            string = "SHA512withECDSA";
        }
        return string;
    }

    public static ECPrivateKey generateECPrivateKeyFromBytes(byte[] byArray) {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    public static ECPublicKey generateECPublicKeyFromBytes(byte[] byArray) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    public static RSAPublicKey generateRSAPublicKeyFromBytes(byte[] byArray) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    public static RSAPrivateKey generateRSAPrivateKeyFromBytes(byte[] byArray) {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    public static int getPublicKeyBitLength(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            return ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof ECPublicKey) {
            return ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        }
        return 0;
    }
}

