/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.FileLocker;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleWalletImpl;
import oracle.security.pki.ReentrantReadWriteLockProvider;

class OracleFileWalletImpl
extends OracleWalletImpl {
    protected static int a = 77;

    OracleFileWalletImpl(String string) {
        super(string);
    }

    @Override
    void a(byte[] byArray, char[] cArray, int n) throws IOException {
        this.a(byArray, cArray, n, (byte)0);
    }

    @Override
    void a(byte[] byArray, char[] cArray, int n, byte by) throws IOException {
        this.a(byArray, cArray, n, by, 0, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void a(byte[] byArray, char[] cArray, int n, byte by, int n2, String string, String string2) throws IOException {
        FileLocker fileLocker;
        FileLock fileLock;
        FileChannel fileChannel;
        FileOutputStream fileOutputStream;
        FileLocker fileLocker2;
        FileLock fileLock2;
        FileChannel fileChannel2;
        FileOutputStream fileOutputStream2;
        File file;
        File file2;
        boolean bl;
        block12: {
            bl = false;
            file2 = new File(this.e());
            file = new File(this.e());
            fileOutputStream2 = null;
            fileChannel2 = null;
            fileLock2 = null;
            fileLocker2 = null;
            fileOutputStream = null;
            fileChannel = null;
            fileLock = null;
            fileLocker = null;
            if (!file2.exists() && !file2.mkdir()) {
                throw new IOException(d.getString("PKI-02009") + file2);
            }
            if (file2.isDirectory()) {
                file2 = new File(file2, "ewallet.p12");
                file = new File(file, "cwallet.sso");
            } else {
                file = new File(file.getParentFile(), "cwallet.sso");
            }
            if (!file2.exists()) {
                bl = true;
            } else if (!file2.canWrite() || file.exists() && !file.canWrite()) {
                throw new IOException(d.getString("PKI-0723"));
            }
            String string3 = this.f();
            try {
                ReentrantReadWriteLockProvider.lockForWrite(string3);
                fileLocker2 = new FileLocker(file2);
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallets:locking (exclusive) dummy p12 file..");
                if (!fileLocker2.lock(true)) break block12;
                fileOutputStream2 = new FileOutputStream(file2);
                fileChannel2 = fileOutputStream2.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallets:locking (exclusive) ewallet.p12 wallet file..");
                fileLock2 = FileLockProvider.a(file2, fileChannel2, 0L, byArray.length, false);
                if (fileLock2 == null || !fileLock2.isValid()) {
                    throw new IOException(d.getString("PKI-02012") + file2.getCanonicalPath());
                }
                fileLocker = new FileLocker(file);
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallets: locking (exclusive) dummy sso file..");
                if (fileLocker.lock(true)) {
                    fileOutputStream = new FileOutputStream(file);
                    fileChannel = fileOutputStream.getChannel();
                    OraclePKIDebug.a("OracleFileWalletImpl.saveWallets:locking (exclusive) cwallet.sso wallet file..");
                    fileLock = FileLockProvider.a(file, fileChannel, 0L, byArray.length + a, false);
                    if (fileLock == null || !fileLock.isValid()) {
                        throw new IOException(d.getString("PKI-02012") + file.getCanonicalPath());
                    }
                    OracleKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream2, cArray, by);
                    OracleSSOKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream, cArray, n, by, n2, string, string2);
                }
            }
            catch (Throwable throwable) {
                this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
                this.a(fileLock2, fileChannel2, null, fileOutputStream2, fileLocker2);
                ReentrantReadWriteLockProvider.unlockForWrite(this.f());
                throw throwable;
            }
        }
        this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
        this.a(fileLock2, fileChannel2, null, fileOutputStream2, fileLocker2);
        ReentrantReadWriteLockProvider.unlockForWrite(this.f());
        if (bl && file2 != null && file != null) {
            OracleFileWalletImpl.b(file2);
            OracleFileWalletImpl.b(file);
        }
    }

    @Override
    void a(byte[] byArray, char[] cArray) throws IOException {
        this.a(byArray, cArray, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void a(byte[] byArray, char[] cArray, byte by) throws IOException {
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        FileLocker fileLocker = null;
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel2 = null;
        FileLock fileLock2 = null;
        FileLocker fileLocker2 = null;
        boolean bl = false;
        File file = new File(this.e());
        File file2 = new File(this.e());
        if (!file.exists() && !file.mkdir()) {
            throw new IOException(d.getString("PKI-02009") + file);
        }
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
            file2 = new File(file2, "cwallet.sso");
        } else {
            file2 = new File(file2.getParentFile(), "cwallet.sso");
        }
        if (!file.exists()) {
            bl = true;
        }
        String string = this.f();
        try {
            ReentrantReadWriteLockProvider.lockForWrite(string);
            fileLocker = new FileLocker(file);
            OraclePKIDebug.a("OracleFileWalletImpl.saveWallet:locking (exclusive) dummy p12 file..");
            if (fileLocker.lock(true)) {
                fileOutputStream = new FileOutputStream(file);
                fileChannel = fileOutputStream.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallet:locking (exclusive) ewallet.p12 wallet file..");
                fileLock = FileLockProvider.a(file, fileChannel, 0L, byArray.length, false);
                if (fileLock == null || !fileLock.isValid()) {
                    throw new IOException(d.getString("PKI-02012") + file.getCanonicalPath());
                }
                if (file2.exists()) {
                    fileLocker2 = new FileLocker(file2);
                    OraclePKIDebug.a("OracleFileWalletImpl.saveWallet: locking (exclusive) dummy sso file..");
                    if (fileLocker2.lock(true)) {
                        randomAccessFile = new RandomAccessFile(file2, "rw");
                        fileChannel2 = randomAccessFile.getChannel();
                        OraclePKIDebug.a("OracleFileWalletImpl.saveWallet:locking (exclusive) cwallet.sso wallet file..");
                        fileLock2 = FileLockProvider.a(file2, fileChannel2, 0L, byArray.length + a, false);
                        if (fileLock2 == null || !fileLock2.isValid()) {
                            throw new IOException(d.getString("PKI-02012") + file2.getCanonicalPath());
                        }
                    }
                }
                OracleKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream, cArray, by);
            }
        }
        catch (Throwable throwable) {
            this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
            this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
            ReentrantReadWriteLockProvider.unlockForWrite(string);
            throw throwable;
        }
        this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
        this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
        ReentrantReadWriteLockProvider.unlockForWrite(string);
        if (bl && file != null) {
            OracleFileWalletImpl.b(file);
        }
    }

    @Override
    void b(byte[] byArray, char[] cArray, int n) throws IOException {
        this.b(byArray, cArray, n, (byte)0);
    }

    @Override
    void b(byte[] byArray, char[] cArray, int n, byte by) throws IOException {
        this.b(byArray, cArray, n, (byte)0, 0, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void b(byte[] byArray, char[] cArray, int n, byte by, int n2, String string, String string2) throws IOException {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        FileLocker fileLocker = null;
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel2 = null;
        FileLock fileLock2 = null;
        FileLocker fileLocker2 = null;
        File file = new File(this.e());
        File file2 = new File(this.e());
        OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet: enter...");
        OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet: System.getProperty(user.name)=" + System.getProperty("user.name"));
        if (!file.exists() && !file.mkdir()) {
            throw new IOException(d.getString("PKI-02009") + file);
        }
        if (file.isFile()) {
            file = file.getParentFile();
            file2 = file2.getParentFile();
        }
        file = new File(file, "cwallet.sso");
        file2 = new File(file2, "ewallet.p12");
        if (!file.exists()) {
            bl = true;
        }
        switch (n) {
            case 1: {
                OraclePKIDebug.a("OracleFileWalletImpl: Storing SSO Wallet");
                break;
            }
            case 2: {
                OraclePKIDebug.a("OracleFileWalletImpl: Storing ESSO Wallet");
                break;
            }
            case 3: {
                OraclePKIDebug.a("OracleFileWalletImpl: Storing LSSO Wallet");
                break;
            }
        }
        String string3 = this.f();
        try {
            ReentrantReadWriteLockProvider.lockForWrite(string3);
            if (file2.exists()) {
                fileLocker2 = new FileLocker(file2);
                OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet:locking (exclusive) dummy p12 file..");
                if (fileLocker2.lock(true)) {
                    randomAccessFile = new RandomAccessFile(file2, "rw");
                    fileChannel2 = randomAccessFile.getChannel();
                    OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet:locking (exclusive) ewallet.p12 wallet file..");
                    fileLock2 = FileLockProvider.a(file2, fileChannel2, 0L, byArray.length, false);
                    if (fileLock2 == null || !fileLock2.isValid()) {
                        throw new IOException(d.getString("PKI-02012") + file2.getCanonicalPath());
                    }
                }
            }
            fileLocker = new FileLocker(file);
            OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet: locking (exclusive) dummy sso file..");
            if (fileLocker.lock(true)) {
                fileOutputStream = new FileOutputStream(file);
                fileChannel = fileOutputStream.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet:locking (exclusive) cwallet.sso wallet file..");
                fileLock = FileLockProvider.a(file, fileChannel, 0L, byArray.length + a, false);
                if (fileLock == null || !fileLock.isValid()) {
                    throw new IOException(d.getString("PKI-02012") + file.getCanonicalPath());
                }
                OracleSSOKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream, cArray, n, by, n2, string, string2);
            }
        }
        catch (Throwable throwable) {
            this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
            this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
            ReentrantReadWriteLockProvider.unlockForWrite(string3);
            throw throwable;
        }
        this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
        this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
        ReentrantReadWriteLockProvider.unlockForWrite(string3);
        if (bl && file != null) {
            OracleFileWalletImpl.b(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] a() throws IOException, FileNotFoundException {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        FileLocker fileLocker = null;
        FileInputStream fileInputStream2 = null;
        FileChannel fileChannel2 = null;
        FileLock fileLock2 = null;
        FileLocker fileLocker2 = null;
        File file = new File(this.e());
        File file2 = new File(this.e());
        OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: enter...");
        OraclePKIDebug.a("OracleFileWalletImpl: System.getProperty(user.name)=" + System.getProperty("user.name"));
        OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: sso wallet file path" + file2.getAbsolutePath());
        OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: p12 wallet file path" + file.getAbsolutePath());
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
            file2 = new File(file2, "cwallet.sso");
        } else {
            file2 = new File(file2.getParentFile(), "cwallet.sso");
        }
        String string = this.f();
        try {
            OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: Using Reentrant ReadWrite Lock Provider to read wallet");
            ReentrantReadWriteLockProvider.lockForRead(string);
            fileLocker = new FileLocker(file);
            OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) dummy p12 file..");
            if (fileLocker.lock(false)) {
                fileInputStream = new FileInputStream(file);
                fileChannel = fileInputStream.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) p12 file..");
                fileLock = FileLockProvider.a(file, fileChannel, fileInputStream);
                if (file2.exists()) {
                    OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: sso wallet file exists..");
                    fileLocker2 = new FileLocker(file2);
                    OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) dummy sso file..");
                    if (fileLocker2.lock(false)) {
                        fileInputStream2 = new FileInputStream(file2);
                        fileChannel2 = fileInputStream2.getChannel();
                        OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) sso file..");
                        fileLock2 = FileLockProvider.a(file2, fileChannel2, fileInputStream2);
                    }
                }
                byArray = new byte[(int)file.length()];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                fileChannel.read(byteBuffer);
                OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: read the wallet data into buffer..");
            }
        }
        catch (Throwable throwable) {
            this.a(file2, fileLock2, fileChannel2, fileInputStream2, fileLocker2);
            this.a(file, fileLock, fileChannel, fileInputStream, fileLocker);
            ReentrantReadWriteLockProvider.unlockForRead(string);
            throw throwable;
        }
        this.a(file2, fileLock2, fileChannel2, fileInputStream2, fileLocker2);
        this.a(file, fileLock, fileChannel, fileInputStream, fileLocker);
        ReentrantReadWriteLockProvider.unlockForRead(string);
        OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: exit...");
        return byArray;
    }

    @Override
    void c() throws IOException {
        File file = new File(this.e());
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
        }
        OraclePKIDebug.a("OracleFileWalletImpl: deleting wallet, length " + file.length());
        this.a(file);
        if (!file.delete()) {
            throw new IOException(d.getString("PKI-02005") + file.getPath());
        }
    }

    void a(File file) throws IOException {
        int n;
        int n2 = -86;
        int n3 = 85;
        int n4 = (int)file.length();
        String string = file.getAbsolutePath();
        OraclePKIDebug.a("OracleFileWalletImpl: wallet is " + string);
        OraclePKIDebug.a("OracleFileWalletImpl: walletFile length is " + n4);
        OraclePKIDebug.a("Pass 1");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        for (n = 0; n < n4; ++n) {
            try {
                fileOutputStream.write(n2);
                continue;
            }
            catch (IOException iOException) {
                fileOutputStream.close();
                throw iOException;
            }
        }
        fileOutputStream.close();
        OraclePKIDebug.a("Pass 2");
        fileOutputStream = new FileOutputStream(file);
        for (n = 0; n < n4; ++n) {
            try {
                fileOutputStream.write(n3);
                continue;
            }
            catch (IOException iOException) {
                fileOutputStream.close();
                throw iOException;
            }
        }
        fileOutputStream.close();
        byte[] byArray = new byte[n4];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        OraclePKIDebug.a("Pass 3");
        fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            fileOutputStream.close();
            throw iOException;
        }
        fileOutputStream.close();
        FileInputStream fileInputStream = new FileInputStream(file);
        int n5 = 0;
        while ((long)n5 < file.length()) {
            byte by = (byte)fileInputStream.read();
            if (by != byArray[n5]) {
                OraclePKIDebug.a("Read = " + by + "Expected = " + byArray[n5]);
                fileInputStream.close();
                throw new IOException("Wipe failed");
            }
            ++n5;
        }
        fileInputStream.close();
    }

    @Override
    void d() throws IOException {
        File file = new File(this.e());
        if (file.isFile()) {
            file = file.getParentFile();
        }
        file = new File(file, "cwallet.sso");
        this.a(file);
        if (!file.delete()) {
            throw new IOException(d.getString("PKI-02005") + file.getPath());
        }
    }

    @Override
    boolean b() {
        File file = new File(this.e());
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
        }
        return file.exists();
    }

    private String g() {
        String string = "cmd /C set USERDOMAIN";
        String string2 = "";
        try {
            OraclePKIDebug.a("OracleFileWalletImpl: Exec " + string);
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                OraclePKIDebug.a("OracleFileWalletImpl: " + string3);
                if (string3.toUpperCase(Locale.ENGLISH).startsWith("USERDOMAIN=")) {
                    string2 = string3.toUpperCase().substring(11) + "\\";
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            OraclePKIDebug.a("OracleFileWalletImpl: " + exception);
            exception.printStackTrace();
        }
        OraclePKIDebug.a("OracleFileWalletImpl: returning " + string2);
        return string2;
    }

    static void b(File file) {
        OraclePKIDebug.a("OracleFileWalletImpl.setPermissions: enter");
        try {
            if (!file.exists()) {
                throw new IOException("No such file or directory: " + file.getAbsolutePath());
            }
            String string = System.getProperty("os.name", "DEFAULT");
            String string2 = file.getAbsolutePath();
            if (string.startsWith("Windows")) {
                OracleFileWalletImpl.a(string2);
            } else if (!(file.setReadable(false, false) && file.setExecutable(false, false) && file.setWritable(false, false) && file.setWritable(true, true) && file.setReadable(true, true))) {
                OraclePKIDebug.a("PKI-02011" + string2);
            }
        }
        catch (SecurityException securityException) {
            OraclePKIDebug.a("OracleFileWalletImpl.setPermissions " + securityException);
        }
        catch (IOException iOException) {
            OraclePKIDebug.a("OracleFileWalletImpl.setPermissions " + iOException);
        }
        OraclePKIDebug.a("OracleFileWalletImpl.setPermissions: exit");
    }

    private static void a(String string) {
        try {
            Path path = Paths.get(string, new String[0]);
            AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            UserPrincipalLookupService userPrincipalLookupService = path.getFileSystem().getUserPrincipalLookupService();
            UserPrincipal userPrincipal = userPrincipalLookupService.lookupPrincipalByName(aclFileAttributeView.getOwner().getName());
            AclEntry.Builder builder = AclEntry.newBuilder();
            builder.setPermissions(EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.READ_ACL, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_ACL, AclEntryPermission.DELETE, AclEntryPermission.WRITE_DATA, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.APPEND_DATA, AclEntryPermission.SYNCHRONIZE}));
            builder.setPrincipal(userPrincipal);
            builder.setType(AclEntryType.ALLOW);
            aclFileAttributeView.setAcl(Collections.singletonList(builder.build()));
            OraclePKIDebug.a("owner of file: " + aclFileAttributeView.getOwner().getName());
            OraclePKIDebug.a("permissions on the file placed at location : " + string);
            for (AclEntry aclEntry : aclFileAttributeView.getAcl()) {
                OraclePKIDebug.a(aclEntry.toString());
            }
        }
        catch (IOException iOException) {
            OraclePKIDebug.a("OracleFileWalletImpl: " + iOException);
        }
    }
}

