"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
const cdk = require("@aws-cdk/core");
const aws_codestar_1 = require("@aws-cdk/aws-codestar");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'cdk-github-import');
new lib_1.Deployment(stack, 'MyImport', {
    path: './lib',
    owner: 'pahud',
    repositoryName: 'cdk-github-import-test',
    visibility: aws_codestar_1.RepositoryVisibility.PRIVATE,
    accessToken: cdk.SecretValue.secretsManager('my-github-token', {
        jsonField: 'token',
    }),
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsZ0NBQW9DO0FBQ3BDLHFDQUFxQztBQUNyQyx3REFBNkQ7QUFFN0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUE7QUFDekIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxtQkFBbUIsQ0FBQyxDQUFBO0FBRXJELElBQUksZ0JBQVUsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFO0lBQ2hDLElBQUksRUFBRSxPQUFPO0lBQ2IsS0FBSyxFQUFFLE9BQU87SUFDZCxjQUFjLEVBQUUsd0JBQXdCO0lBQ3hDLFVBQVUsRUFBRSxtQ0FBb0IsQ0FBQyxPQUFPO0lBQ3hDLFdBQVcsRUFBRSxHQUFHLENBQUMsV0FBVyxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsRUFBRTtRQUM3RCxTQUFTLEVBQUUsT0FBTztLQUNuQixDQUFDO0NBQ0gsQ0FBQyxDQUFBIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGVwbG95bWVudCB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBSZXBvc2l0b3J5VmlzaWJpbGl0eSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2Rlc3Rhcic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKClcbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdjZGstZ2l0aHViLWltcG9ydCcpXG5cbm5ldyBEZXBsb3ltZW50KHN0YWNrLCAnTXlJbXBvcnQnLCB7XG4gIHBhdGg6ICcuL2xpYicsXG4gIG93bmVyOiAncGFodWQnLFxuICByZXBvc2l0b3J5TmFtZTogJ2Nkay1naXRodWItaW1wb3J0LXRlc3QnLFxuICB2aXNpYmlsaXR5OiBSZXBvc2l0b3J5VmlzaWJpbGl0eS5QUklWQVRFLFxuICBhY2Nlc3NUb2tlbjogY2RrLlNlY3JldFZhbHVlLnNlY3JldHNNYW5hZ2VyKCdteS1naXRodWItdG9rZW4nLCB7XG4gICAganNvbkZpZWxkOiAndG9rZW4nLFxuICB9KSxcbn0pXG4iXX0=