"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
const cdk = require("@aws-cdk/core");
require("@aws-cdk/assert/jest");
test('import', () => {
    const mockApp = new cdk.App();
    const stack = new cdk.Stack(mockApp, 'testing-stack');
    new lib_1.Deployment(stack, 'NewImport', {
        path: './lib',
        owner: 'pahud',
        repositoryName: 'cdk-github-import-test',
        accessToken: cdk.SecretValue.secretsManager('my-github-token', {
            jsonField: 'token',
        }),
    });
    expect(stack).toHaveResource('AWS::CodeStar::GitHubRepository');
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXgudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImluZGV4LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBb0M7QUFDcEMscUNBQXFDO0FBQ3JDLGdDQUE4QjtBQUU5QixJQUFJLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRTtJQUNsQixNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztJQUM5QixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0lBRXRELElBQUksZ0JBQVUsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO1FBQ2pDLElBQUksRUFBRSxPQUFPO1FBQ2IsS0FBSyxFQUFFLE9BQU87UUFDZCxjQUFjLEVBQUUsd0JBQXdCO1FBQ3hDLFdBQVcsRUFBRSxHQUFHLENBQUMsV0FBVyxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsRUFBRTtZQUM3RCxTQUFTLEVBQUUsT0FBTztTQUNuQixDQUFDO0tBQ0gsQ0FBQyxDQUFBO0lBRUYsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLGNBQWMsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0FBQ2xFLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGVwbG95bWVudCB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgJ0Bhd3MtY2RrL2Fzc2VydC9qZXN0JztcblxudGVzdCgnaW1wb3J0JywgKCkgPT4ge1xuICBjb25zdCBtb2NrQXBwID0gbmV3IGNkay5BcHAoKTtcbiAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKG1vY2tBcHAsICd0ZXN0aW5nLXN0YWNrJyk7XG5cbiAgbmV3IERlcGxveW1lbnQoc3RhY2ssICdOZXdJbXBvcnQnLCB7XG4gICAgcGF0aDogJy4vbGliJyxcbiAgICBvd25lcjogJ3BhaHVkJyxcbiAgICByZXBvc2l0b3J5TmFtZTogJ2Nkay1naXRodWItaW1wb3J0LXRlc3QnLFxuICAgIGFjY2Vzc1Rva2VuOiBjZGsuU2VjcmV0VmFsdWUuc2VjcmV0c01hbmFnZXIoJ215LWdpdGh1Yi10b2tlbicsIHtcbiAgICAgIGpzb25GaWVsZDogJ3Rva2VuJyxcbiAgICB9KSxcbiAgfSlcblxuICBleHBlY3Qoc3RhY2spLnRvSGF2ZVJlc291cmNlKCdBV1M6OkNvZGVTdGFyOjpHaXRIdWJSZXBvc2l0b3J5Jyk7XG59KTtcblxuXG5cbiJdfQ==